/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;

@TraitName(value="pigtrait")
public class PigTrait
extends Trait {
    @Persist
    private Pig.Variant variant;

    public PigTrait() {
        super("pigtrait");
    }

    public Pig.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.variant != null && this.npc.getEntity() instanceof Pig) {
            Pig pig = (Pig)this.npc.getEntity();
            pig.setVariant(this.variant);
        }
    }

    public void setVariant(Pig.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="pig (--variant variant)", desc="", modifiers={"pig"}, min=1, max=1, permission="citizens.npc.pig")
    @Requirements(selected=true, ownership=true, types={EntityType.PIG})
    public static void pig(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) Pig.Variant variant) throws CommandException {
        PigTrait trait = npc.getOrAddTrait(PigTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.pig.invalid-variant", Util.listValuesPretty(Pig.Variant.class));
            }
            trait.setVariant(variant);
            output = output + Messaging.tr("citizens.commands.npc.pig.variant-set", variant);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

