/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabListRemover {
    private final Map<UUID, PlayerEntry> pending = new HashMap<UUID, PlayerEntry>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));

    TabListRemover() {
        Bukkit.getScheduler().runTaskTimer(CitizensAPI.getPlugin(), (Runnable)new Sender(), 2L, 2L);
    }

    public void cancelPackets(Player player) {
        Objects.requireNonNull(player);
        PlayerEntry entry = this.pending.remove(player.getUniqueId());
        if (entry == null) {
            return;
        }
        for (SkinnableEntity entity : entry.toRemove) {
            entity.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
    }

    public void cancelPackets(Player player, SkinnableEntity skinnable) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(skinnable);
        PlayerEntry entry = this.pending.get(player.getUniqueId());
        if (entry == null) {
            return;
        }
        if (entry.toRemove.remove(skinnable)) {
            skinnable.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
        if (entry.toRemove.isEmpty()) {
            this.pending.remove(player.getUniqueId());
        }
    }

    private PlayerEntry getEntry(Player player) {
        PlayerEntry entry = this.pending.get(player.getUniqueId());
        if (entry == null) {
            entry = new PlayerEntry(player);
            this.pending.put(player.getUniqueId(), entry);
        }
        return entry;
    }

    public void sendPacket(Player player, SkinnableEntity entity) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(entity);
        PlayerEntry entry = this.getEntry(player);
        entry.toRemove.add(entity);
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            int maxPacketEntries = 15;
            Iterator entryIterator = TabListRemover.this.pending.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry mapEntry = entryIterator.next();
                PlayerEntry entry = (PlayerEntry)mapEntry.getValue();
                if (!entry.player.isOnline()) {
                    entryIterator.remove();
                    continue;
                }
                int listSize = Math.min(maxPacketEntries, entry.toRemove.size());
                ArrayList<Player> skinnableList = new ArrayList<Player>(listSize);
                Iterator<SkinnableEntity> skinIterator = entry.toRemove.iterator();
                for (int i = 0; skinIterator.hasNext() && i < maxPacketEntries; ++i) {
                    SkinnableEntity next = skinIterator.next();
                    skinnableList.add(next.getBukkitEntity());
                    next.getSkinTracker().notifyRemovePacketSent(entry.player.getUniqueId());
                    skinIterator.remove();
                }
                NMS.sendTabListRemove(entry.player, skinnableList);
                if (!entry.toRemove.isEmpty()) continue;
                entryIterator.remove();
            }
        }
    }

    private static class PlayerEntry {
        Player player;
        Set<SkinnableEntity> toRemove = new HashSet<SkinnableEntity>(20);

        PlayerEntry(Player player) {
            this.player = player;
        }
    }
}

