/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryMultiplexer {
    private final ItemStack[] inventory;
    private final Collection<Inventory> sources;

    public InventoryMultiplexer(Collection<Inventory> sources) {
        this.sources = sources;
        int size = sources.stream().mapToInt(Inventory::getSize).sum();
        this.inventory = new ItemStack[size];
        this.refresh();
    }

    public InventoryMultiplexer(Inventory ... inventories) {
        this((Collection<Inventory>)ImmutableList.copyOf((Object[])inventories));
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void refresh() {
        int i = 0;
        for (Inventory sourceInventory : this.sources) {
            ItemStack[] source = sourceInventory.getContents();
            System.arraycopy(source, 0, this.inventory, i, source.length);
            i += source.length;
        }
    }

    public void transact(Consumer<ItemStack[]> action) {
        action.accept(this.inventory);
        int i = 0;
        for (Inventory source : this.sources) {
            ItemStack[] result = new ItemStack[source.getSize()];
            System.arraycopy(this.inventory, i, result, 0, result.length);
            source.setContents(result);
            i += result.length;
        }
    }
}

