/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.OldEnumCompat;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;

@TraitName(value="frogtrait")
public class FrogTrait
extends Trait {
    @Persist
    private Frog.Variant variant;

    public FrogTrait() {
        super("frogtrait");
    }

    public Frog.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.variant != null && this.npc.getEntity() instanceof Frog) {
            Frog frog = (Frog)this.npc.getEntity();
            frog.setVariant(this.variant);
        }
    }

    public void setVariant(Frog.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="frog (--variant variant)", desc="", modifiers={"frog"}, min=1, max=1, permission="citizens.npc.frog")
    @Requirements(selected=true, ownership=true, types={EntityType.FROG})
    public static void frog(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) Frog.Variant variant) throws CommandException {
        FrogTrait trait = npc.getOrAddTrait(FrogTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.frog.invalid-variant", Util.listValuesPretty(OldEnumCompat.FrogVariantEnum.values()));
            }
            trait.setVariant(variant);
            output = output + Messaging.tr("citizens.commands.npc.frog.variant-set", variant);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

