/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class TimerDecorator
extends BehaviorGoalAdapter {
    private final int limit;
    private int ticks;
    private final Behavior wrapping;

    private TimerDecorator(Behavior wrapping, int tickLimit) {
        this.limit = tickLimit;
        this.wrapping = wrapping;
    }

    @Override
    public void reset() {
        this.ticks = 0;
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        if (++this.ticks >= this.limit) {
            return BehaviorStatus.FAILURE;
        }
        return this.wrapping.run();
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static TimerDecorator tickLimiter(Behavior wrapping, int tickLimit) {
        return new TimerDecorator(wrapping, tickLimit);
    }
}

