/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.npc.ai.NMSChunkBlockSource;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FlyingAStarNavigationStrategy
extends AbstractPathStrategy {
    private int iterations;
    private final NPC npc;
    private final NavigatorParameters parameters;
    private Path plan;
    private boolean planned;
    private AStarMachine.AStarState<VectorNode> state;
    private final Location target;
    private Vector vector;
    private static AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();

    public FlyingAStarNavigationStrategy(NPC npc, Iterable<Vector> path, NavigatorParameters params) {
        super(TargetType.LOCATION);
        ArrayList list = Lists.newArrayList(path);
        this.target = ((Vector)list.get(list.size() - 1)).toLocation(npc.getStoredLocation().getWorld());
        this.parameters = params;
        this.npc = npc;
        this.setPlan(new Path(list));
    }

    public FlyingAStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.target = dest;
        this.parameters = params;
        this.npc = npc;
    }

    @Override
    public Location getCurrentDestination() {
        return this.vector != null ? this.vector.toLocation(this.npc.getEntity().getWorld()) : this.target.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.plan == null ? null : this.plan.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    private void initialisePathfinder() {
        boolean found = false;
        for (BlockExaminer examiner : this.parameters.examiners()) {
            if (!(examiner instanceof FlyingBlockExaminer)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.parameters.examiner(new FlyingBlockExaminer());
        }
        Location location = this.npc.getEntity().getLocation();
        VectorGoal goal = new VectorGoal(this.target, (float)this.parameters.pathDistanceMargin());
        this.state = ASTAR.getStateFor(goal, new VectorNode(goal, location, new NMSChunkBlockSource(location, this.parameters.range()), this.parameters));
    }

    public void setPlan(Path path) {
        this.plan = path;
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
            if (this.parameters.debug()) {
                Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), Util.getFallbackMaterial("DANDELION", "YELLOW_FLOWER"));
            }
        }
        this.planned = true;
    }

    @Override
    public void stop() {
        if (this.plan != null && this.parameters.debug()) {
            Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), null);
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        ItemStack stack;
        if (!this.planned) {
            if (this.state == null) {
                this.initialisePathfinder();
            }
            int maxIterations = Settings.Setting.CITIZENS_PATHFINDER_MAXIMUM_ASTAR_ITERATIONS.asInt();
            int iterationsPerTick = Settings.Setting.CITIZENS_PATHFINDER_ASTAR_ITERATIONS_PER_TICK.asInt();
            Path plan = ASTAR.run(this.state, iterationsPerTick);
            if (plan == null) {
                if (this.state.isEmpty()) {
                    this.setCancelReason(CancelReason.STUCK);
                }
                if (iterationsPerTick > 0 && maxIterations > 0) {
                    this.iterations += iterationsPerTick;
                    if (this.iterations > maxIterations) {
                        this.setCancelReason(CancelReason.STUCK);
                    }
                }
            } else {
                this.setPlan(plan);
            }
        }
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        Location current = this.npc.getEntity().getLocation();
        if (current.toVector().distance(this.vector) <= this.parameters.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
        }
        if (this.parameters.debug()) {
            this.npc.getEntity().getWorld().playEffect(this.vector.toLocation(this.npc.getEntity().getWorld()), Effect.ENDER_SIGNAL, 0);
        }
        if (this.npc.getEntity().getType() == EntityType.PLAYER && SpigotUtil.getVersion()[1] > 8 && (stack = ((Player)this.npc.getEntity()).getInventory().getChestplate()) != null && stack.getType() == Material.ELYTRA && !MinecraftBlockExaminer.canStandOn(current.getBlock().getRelative(BlockFace.DOWN))) {
            PlayerAnimation.START_ELYTRA.play((Player)this.npc.getEntity());
        }
        Vector dest = this.plan.isFinalEntry() ? this.vector : new Vector(this.vector.getX() + 0.5, this.vector.getY() + 0.1, this.vector.getZ() + 0.5);
        double d0 = dest.getX() - current.getX();
        double d1 = dest.getY() - current.getY();
        double d2 = dest.getZ() - current.getZ();
        Vector velocity = this.npc.getEntity().getVelocity();
        double motX = velocity.getX();
        double motY = velocity.getY();
        double motZ = velocity.getZ();
        motX += (Math.signum(d0) * 0.5 - motX) * 0.1;
        motY += (Math.signum(d1) - motY) * 0.1;
        motZ += (Math.signum(d2) * 0.5 - motZ) * 0.1;
        velocity.setX(motX).setY(motY).setZ(motZ).multiply(this.parameters.speed());
        this.npc.getEntity().setVelocity(velocity);
        if (this.npc.getEntity().getType() != EntityType.ENDER_DRAGON) {
            NMS.setVerticalMovement(this.npc.getEntity(), 0.5);
            Util.faceLocation(this.npc.getEntity(), dest.toLocation(this.npc.getEntity().getWorld()));
        }
        this.plan.run(this.npc);
        return false;
    }
}

