/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai.tree;

import com.google.common.primitives.Doubles;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.citizensnpcs.api.expr.CompiledExpression;
import net.citizensnpcs.api.expr.ExpressionEngine;
import net.citizensnpcs.api.expr.ExpressionScope;
import net.citizensnpcs.api.expr.Memory;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import team.unnamed.mocha.MochaEngine;
import team.unnamed.mocha.runtime.MochaFunction;
import team.unnamed.mocha.runtime.value.Function;
import team.unnamed.mocha.runtime.value.MutableObjectBinding;
import team.unnamed.mocha.runtime.value.NumberValue;
import team.unnamed.mocha.runtime.value.ObjectProperty;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.runtime.value.StringValue;
import team.unnamed.mocha.runtime.value.Value;

public class MolangEngine
implements ExpressionEngine {
    private final MochaEngine<?> engine = MochaEngine.createStandard();

    @Override
    public CompiledExpression compile(String expression) throws ExpressionEngine.ExpressionCompileException {
        try {
            return new MolangCompiledExpression(this.engine.prepareEval(expression), this.engine);
        }
        catch (Exception e) {
            throw new ExpressionEngine.ExpressionCompileException("Failed to parse Molang expression: " + expression, e);
        }
    }

    @Override
    public String getName() {
        return "molang";
    }

    private static ObjectValue createInvBinding(NPC npc) {
        MutableObjectBinding binding = new MutableObjectBinding();
        binding.set("has", (Value)((Function)(context, args) -> {
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            Inventory inv = npc.getOrAddTrait(Inventory.class);
            for (ItemStack stack : inv.getContents()) {
                if (stack == null || stack.getType() != item.getType()) continue;
                return NumberValue.of((double)1.0);
            }
            return NumberValue.zero();
        }));
        binding.set("count", (Value)((Function)(context, args) -> {
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            int count = 0;
            Inventory inv = npc.getOrAddTrait(Inventory.class);
            for (ItemStack stack : inv.getContents()) {
                if (stack == null || stack.getType() != item.getType()) continue;
                count += stack.getAmount();
            }
            return NumberValue.of((double)count);
        }));
        binding.set("add", (Value)((Function)(context, args) -> {
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            int amount = args.length() > 1 ? (int)args.next().eval().getAsNumber() : 1;
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), amount);
            if (item == null) {
                return NumberValue.zero();
            }
            Inventory inv = npc.getOrAddTrait(Inventory.class);
            ItemStack[] contents = inv.getContents();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] != null && contents[i].getType() != Material.AIR) continue;
                contents[i] = item;
                inv.setContents(contents);
                return NumberValue.of((double)1.0);
            }
            return NumberValue.zero();
        }));
        binding.set("remove", (Value)((Function)(context, args) -> {
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            int amount = args.length() > 1 ? (int)args.next().eval().getAsNumber() : 1;
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), amount);
            if (item == null) {
                return NumberValue.zero();
            }
            int remaining = amount;
            Inventory inv = npc.getOrAddTrait(Inventory.class);
            ItemStack[] contents = inv.getContents();
            for (int i = 0; i < contents.length && remaining > 0; ++i) {
                if (contents[i] == null || contents[i].getType() != item.getType()) continue;
                int stackAmount = contents[i].getAmount();
                if (stackAmount <= remaining) {
                    contents[i] = null;
                    remaining -= stackAmount;
                    continue;
                }
                contents[i].setAmount(stackAmount - remaining);
                remaining = 0;
            }
            inv.setContents(contents);
            return remaining == 0 ? NumberValue.of((double)1.0) : NumberValue.zero();
        }));
        binding.set("clear", (Value)((Function)(context, args) -> {
            if (npc == null || !npc.isSpawned()) {
                return NumberValue.zero();
            }
            Inventory inv = npc.getOrAddTrait(Inventory.class);
            inv.setContents(new ItemStack[inv.getContents().length]);
            return NumberValue.of((double)1.0);
        }));
        binding.set("set_hand", (Value)((Function)(context, args) -> {
            EntityEquipment equip;
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            if (npc.getEntity() instanceof Player) {
                ((Player)npc.getEntity()).getInventory().setItemInMainHand(item);
                return NumberValue.of((double)1.0);
            }
            EntityEquipment entityEquipment = equip = npc.getEntity() instanceof LivingEntity ? ((LivingEntity)npc.getEntity()).getEquipment() : null;
            if (equip != null) {
                equip.setItemInMainHand(item);
                return NumberValue.of((double)1.0);
            }
            return NumberValue.zero();
        }));
        binding.set("set_offhand", (Value)((Function)(context, args) -> {
            EntityEquipment equip;
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            if (npc.getEntity() instanceof Player) {
                ((Player)npc.getEntity()).getInventory().setItemInOffHand(item);
                return NumberValue.of((double)1.0);
            }
            EntityEquipment entityEquipment = equip = npc.getEntity() instanceof LivingEntity ? ((LivingEntity)npc.getEntity()).getEquipment() : null;
            if (equip != null) {
                equip.setItemInOffHand(item);
                return NumberValue.of((double)1.0);
            }
            return NumberValue.zero();
        }));
        binding.set("hand_is", (Value)((Function)(context, args) -> {
            EntityEquipment equip;
            if (npc == null || !npc.isSpawned() || args.length() < 1) {
                return NumberValue.zero();
            }
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            EntityEquipment entityEquipment = equip = npc.getEntity() instanceof LivingEntity ? ((LivingEntity)npc.getEntity()).getEquipment() : null;
            if (equip != null) {
                ItemStack hand = equip.getItemInMainHand();
                return hand != null && hand.getType() == item.getType() ? NumberValue.of((double)1.0) : NumberValue.zero();
            }
            return NumberValue.zero();
        }));
        binding.set("equip", (Value)((Function)(context, args) -> {
            EntityEquipment equip;
            if (npc == null || !npc.isSpawned() || args.length() < 2) {
                return NumberValue.zero();
            }
            String slotName = args.next().eval().getAsString();
            ItemStack item = MolangEngine.resolveItemStack(args.next().eval(), 1);
            if (item == null) {
                return NumberValue.zero();
            }
            EntityEquipment entityEquipment = equip = npc.getEntity() instanceof LivingEntity ? ((LivingEntity)npc.getEntity()).getEquipment() : null;
            if (equip == null) {
                return NumberValue.zero();
            }
            try {
                EquipmentSlot slot = EquipmentSlot.valueOf((String)slotName.toUpperCase());
                equip.setItem(slot, item);
                return NumberValue.of((double)1.0);
            }
            catch (IllegalArgumentException e) {
                return NumberValue.zero();
            }
        }));
        return binding;
    }

    private static ObjectValue createItemBinding() {
        MutableObjectBinding binding = new MutableObjectBinding();
        binding.set("from_component", (Value)((Function)(context, args) -> {
            if (args.length() < 1) {
                return NumberValue.zero();
            }
            String itemString = args.next().eval().getAsString();
            int amount = args.length() > 1 ? (int)args.next().eval().getAsNumber() : 1;
            ItemStack item = SpigotUtil.parseItemStack(null, itemString);
            if (amount > 1) {
                item.setAmount(amount);
            }
            return new ItemStackValue(item);
        }));
        return binding;
    }

    private static ObjectValue createListBinding(Memory memory) {
        MutableObjectBinding binding = new MutableObjectBinding();
        binding.set("add", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            double value = args.next().eval().getAsNumber();
            memory.listAdd(key, value);
            return NumberValue.of((double)1.0);
        }));
        binding.set("remove", (Value)((Function)(context, args) -> {
            double value;
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            return memory.listRemove(key, value = args.next().eval().getAsNumber()) ? NumberValue.of((double)1.0) : NumberValue.zero();
        }));
        binding.set("remove_at", (Value)((Function)(context, args) -> {
            int index;
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            return memory.listRemoveAt(key, index = (int)args.next().eval().getAsNumber()) != null ? NumberValue.of((double)1.0) : NumberValue.zero();
        }));
        binding.set("clear", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 1) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            memory.listClear(key);
            return NumberValue.of((double)1.0);
        }));
        binding.set("size", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 1) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            return NumberValue.of((double)memory.listSize(key));
        }));
        binding.set("get", (Value)((Function)(context, args) -> {
            int index;
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            Object value = memory.listGet(key, index = (int)args.next().eval().getAsNumber());
            if (value instanceof Number) {
                return NumberValue.of((double)((Number)value).doubleValue());
            }
            return NumberValue.zero();
        }));
        binding.set("contains", (Value)((Function)(context, args) -> {
            double value;
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            return memory.listContains(key, value = args.next().eval().getAsNumber()) ? NumberValue.of((double)1.0) : NumberValue.zero();
        }));
        return binding;
    }

    private static ObjectValue createMemBinding(Memory memory) {
        MutableObjectBinding binding = new MutableObjectBinding();
        binding.set("set", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 2) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            double value = args.next().eval().getAsNumber();
            memory.set(key, value);
            return NumberValue.of((double)value);
        }));
        binding.set("get", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 1) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            double defaultValue = args.length() > 1 ? args.next().eval().getAsNumber() : 0.0;
            return NumberValue.of((double)memory.getNumber(key, defaultValue));
        }));
        binding.set("has", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 1) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            return memory.has(key) ? NumberValue.of((double)1.0) : NumberValue.zero();
        }));
        binding.set("remove", (Value)((Function)(context, args) -> {
            if (memory == null || args.length() < 1) {
                return NumberValue.zero();
            }
            String key = args.next().eval().getAsString();
            memory.remove(key);
            return NumberValue.of((double)1.0);
        }));
        return binding;
    }

    private static ItemStack resolveItemStack(Value value, int amount) {
        Material mat;
        if (value instanceof ItemStackValue) {
            ItemStack stack = ((ItemStackValue)value).getItemStack();
            if (amount != stack.getAmount()) {
                stack = stack.clone();
                stack.setAmount(amount);
            }
            return stack;
        }
        String materialName = value.getAsString();
        if (materialName != null && !materialName.isEmpty() && (mat = Material.matchMaterial((String)materialName)) != null) {
            return new ItemStack(mat, amount);
        }
        return null;
    }

    private static Value toMochaValue(Object value) {
        if (value == null) {
            return NumberValue.zero();
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof Number) {
            return NumberValue.of((double)((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return NumberValue.of((double)((Boolean)value != false ? 1.0 : 0.0));
        }
        if (value instanceof String) {
            return StringValue.of((String)value.toString());
        }
        if (value instanceof ItemStack) {
            return new ItemStackValue((ItemStack)value);
        }
        return NumberValue.zero();
    }

    private static class MolangCompiledExpression
    implements CompiledExpression {
        private final MochaEngine<?> baseEngine;
        private final MochaFunction function;

        MolangCompiledExpression(MochaFunction function, MochaEngine<?> baseEngine) {
            this.function = function;
            this.baseEngine = baseEngine;
        }

        private void bindCustomFunctions(MochaEngine<?> evalEngine, ExpressionScope scope) {
            Memory memory = scope.getMemory();
            NPC npc = scope.getNPC();
            evalEngine.scope().set("list", (Value)MolangEngine.createListBinding(memory));
            evalEngine.scope().set("mem", (Value)MolangEngine.createMemBinding(memory));
            if (npc != null) {
                evalEngine.scope().set("inv", (Value)MolangEngine.createInvBinding(npc));
            }
            evalEngine.scope().set("item", (Value)MolangEngine.createItemBinding());
            evalEngine.scope().set("papi", (Value)((Function)(context, args) -> {
                if (args.length() < 1) {
                    return StringValue.of((String)"");
                }
                String placeholderName = args.next().eval().getAsString();
                Player player = scope.getPlayer();
                return new NumberParseableValue(Placeholders.replace(placeholderName, (OfflinePlayer)player));
            }));
        }

        private void bindScopeVariables(MochaEngine<?> evalEngine, ExpressionScope scope) {
            HashMap<String, LazyObjectBinding> topLevelObjects = new HashMap<String, LazyObjectBinding>();
            for (String name : scope.getVariableNames()) {
                String[] parts = name.split("\\.", 2);
                if (parts.length == 1) {
                    if (scope.isConstant(name)) {
                        Object value = scope.get(name);
                        if (value == null) continue;
                        evalEngine.scope().set(name, MolangEngine.toMochaValue(value));
                        continue;
                    }
                    Supplier<?> supplier = scope.getSupplier(name);
                    if (supplier == null) continue;
                    evalEngine.scope().set(name, (Value)((Function)(ctx, args) -> MolangEngine.toMochaValue(supplier.get())));
                    continue;
                }
                String topLevel = parts[0];
                String remaining = parts[1];
                LazyObjectBinding top = (LazyObjectBinding)topLevelObjects.get(topLevel);
                if (top == null) {
                    top = new LazyObjectBinding();
                    topLevelObjects.put(topLevel, top);
                    evalEngine.scope().set(topLevel, (Value)top);
                }
                this.setNestedProperty(top, remaining, scope, name);
            }
        }

        @Override
        public Object evaluate(ExpressionScope scope) {
            this.bindScopeVariables(this.baseEngine, scope);
            this.bindCustomFunctions(this.baseEngine, scope);
            try {
                return this.function.evaluate();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        @Override
        public boolean evaluateAsBoolean(ExpressionScope scope) {
            Object result = this.evaluate(scope);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof Number) {
                return ((Number)result).doubleValue() != 0.0;
            }
            return result != null;
        }

        @Override
        public double evaluateAsNumber(ExpressionScope scope) {
            Object result = this.evaluate(scope);
            if (result instanceof Number) {
                return ((Number)result).doubleValue();
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? 1.0 : 0.0;
            }
            return 0.0;
        }

        @Override
        public String evaluateAsString(ExpressionScope scope) {
            Object result = this.evaluate(scope);
            return result == null ? "" : result.toString();
        }

        private void setNestedProperty(LazyObjectBinding parent, String path, ExpressionScope scope, String fullName) {
            String[] parts = path.split("\\.", 2);
            String currentPart = parts[0];
            if (parts.length == 1) {
                if (scope.isConstant(fullName)) {
                    Object value = scope.get(fullName);
                    if (value != null) {
                        parent.setEager(currentPart, MolangEngine.toMochaValue(value));
                    }
                } else {
                    Supplier<?> supplier = scope.getSupplier(fullName);
                    if (supplier != null) {
                        parent.setLazy(currentPart, supplier);
                    }
                }
            } else {
                LazyObjectBinding nested;
                Value existing = parent.get(currentPart);
                if (existing instanceof LazyObjectBinding) {
                    nested = (LazyObjectBinding)existing;
                } else {
                    nested = new LazyObjectBinding();
                    parent.setEager(currentPart, (Value)nested);
                }
                this.setNestedProperty(nested, parts[1], scope, fullName);
            }
        }

        public String toString() {
            return "MolangCompiledExpression [function=" + this.function + "]";
        }
    }

    public static class ItemStackValue
    implements Value {
        private final ItemStack itemStack;

        public ItemStackValue(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }

    private static class NumberParseableValue
    implements Value {
        private Double cache;
        private final String string;

        NumberParseableValue(String value) {
            this.string = value;
        }

        public boolean getAsBoolean() {
            try {
                return Double.parseDouble(this.string) != 0.0;
            }
            catch (NumberFormatException e) {
                return "true".equalsIgnoreCase(this.string.trim()) || !this.string.isEmpty();
            }
        }

        public double getAsNumber() {
            if (this.cache == null) {
                this.cache = Doubles.tryParse((String)this.string.trim());
            }
            return this.cache;
        }

        public String getAsString() {
            return this.string;
        }
    }

    private static class LazyObjectBinding
    implements ObjectValue {
        private final Map<String, Value> eagerProperties = new HashMap<String, Value>();
        private final Map<String, Supplier<?>> lazyProperties = new HashMap();

        private LazyObjectBinding() {
        }

        public Value get(String property) {
            Value eagerValue = this.eagerProperties.get(property);
            if (eagerValue != null) {
                return eagerValue;
            }
            Supplier<?> supplier = this.lazyProperties.get(property);
            if (supplier != null) {
                Object value = supplier.get();
                return MolangEngine.toMochaValue(value);
            }
            return NumberValue.zero();
        }

        public ObjectProperty getProperty(String property) {
            return ObjectProperty.property((Value)this.get(property), (boolean)false);
        }

        public boolean set(String property, Value value) {
            this.lazyProperties.remove(property);
            this.eagerProperties.put(property, value);
            return true;
        }

        public void setEager(String name, Value value) {
            this.eagerProperties.put(name, value);
        }

        public void setLazy(String name, Supplier<?> supplier) {
            this.lazyProperties.put(name, supplier);
        }

        public String toString() {
            return "LazyObjectBinding [eagerProperties=" + this.eagerProperties + ", lazyProperties=" + this.lazyProperties + "]";
        }
    }
}

