/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.expr.CompiledExpression;
import net.citizensnpcs.api.expr.ExpressionEngine;
import net.citizensnpcs.api.expr.ExpressionScope;
import net.citizensnpcs.api.expr.Memory;
import org.bukkit.inventory.ItemStack;

public class DenizenHook {
    private final Citizens plugin;

    public DenizenHook(Citizens plugin) {
        this.plugin = plugin;
        plugin.getExpressionRegistry().registerEngine(new DenizenEngine());
        plugin.getExpressionRegistry().setDefaultEngine("denizen");
    }

    public class DenizenEngine
    implements ExpressionEngine {
        @Override
        public CompiledExpression compile(String expression) throws ExpressionEngine.ExpressionCompileException {
            YamlConfiguration config = new YamlConfiguration();
            config.set("type", (Object)"task");
            config.set("script", (Object)Lists.newArrayList((Object[])new String[]{expression}));
            final TaskScriptContainer sc = new TaskScriptContainer(config, UUID.randomUUID().toString());
            return new CompiledExpression(){

                private ObjectTag convert(Object value) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof List) {
                        return new ListTag((Collection)Lists.transform((List)((List)value), this::convert));
                    }
                    if (value instanceof ItemStack) {
                        return new ItemTag((ItemStack)value);
                    }
                    if (value instanceof Byte) {
                        return new ElementTag(((Byte)value).byteValue());
                    }
                    if (value instanceof Integer) {
                        return new ElementTag(((Integer)value).intValue());
                    }
                    if (value instanceof Double) {
                        return new ElementTag(((Double)value).doubleValue());
                    }
                    if (value instanceof Character) {
                        return new ElementTag((int)((Character)value).charValue());
                    }
                    if (value instanceof String) {
                        return new ElementTag((String)value);
                    }
                    if (value instanceof Long) {
                        return new ElementTag(((Long)value).longValue());
                    }
                    if (value instanceof Enum) {
                        return new ElementTag((Enum)value);
                    }
                    if (value instanceof Float) {
                        return new ElementTag(((Float)value).floatValue());
                    }
                    if (value instanceof Boolean) {
                        return new ElementTag(((Boolean)value).booleanValue());
                    }
                    return new JavaReflectedObjectTag(value);
                }

                @Override
                public Object evaluate(ExpressionScope scope) {
                    ScriptQueue sq = sc.run(null, field -> {
                        switch (field) {
                            case "npc": {
                                return new NPCTag(scope.getNPC());
                            }
                            case "player": {
                                return new PlayerTag(scope.getPlayer());
                            }
                            case "memory": {
                                return new MemoryTag(scope.getMemory());
                            }
                        }
                        return this.convert(scope.get(field));
                    });
                    sq.start();
                    return sq.getLastEntryExecuted().getObject("outcome");
                }
            };
        }

        @Override
        public String getName() {
            return "denizen";
        }
    }

    public static class MemoryTag
    implements ObjectTag,
    Adjustable,
    FlaggableObject {
        private final SavableMapFlagTracker flag = new SavableMapFlagTracker();
        private final Memory memory;
        private String prefix = "memory";

        public MemoryTag(Memory memory) {
            this.memory = memory;
        }

        public void adjust(Mechanism mech) {
            if (mech.matches("set")) {
                ListTag value = (ListTag)mech.valueAsType(ListTag.class);
                if (value.size() != 2) {
                    mech.echoError("Must have key and value");
                    return;
                }
                this.memory.set(value.get(0), value.getObject(1).asElement().getJavaObject());
                return;
            }
        }

        public void applyProperty(Mechanism mech) {
            this.adjust(mech);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MemoryTag other = (MemoryTag)obj;
            return !(this.memory == null ? other.memory != null : !this.memory.equals(other.memory));
        }

        public AbstractFlagTracker getFlagTracker() {
            return this.flag;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int hashCode() {
            return 31 + (this.memory == null ? 0 : this.memory.hashCode());
        }

        public String identify() {
            return this.memory.toString();
        }

        public String identifySimple() {
            return this.memory.toString();
        }

        public boolean isUnique() {
            return true;
        }

        public void reapplyTracker(AbstractFlagTracker arg0) {
        }

        public ObjectTag setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }
    }
}

