/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import org.bukkit.Location;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class VectorNode
extends AStarNode
implements PathPoint {
    private float blockCost = -1.0f;
    List<PathPoint.PathCallback> callbacks;
    private final PathInfo info;
    Vector location;
    Vector locationCache;
    List<Vector> pathVectors;
    private static final float TIEBREAKER = 1.01f;

    public VectorNode(VectorGoal goal, Location location, BlockSource source, NavigatorParameters params) {
        this(null, (Vector)new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ()), new PathInfo(source, params, goal));
    }

    public VectorNode(VectorNode parent, Vector location, PathInfo info) {
        super(parent);
        this.location = location;
        this.info = info;
    }

    @Override
    public void addCallback(PathPoint.PathCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<PathPoint.PathCallback>();
        }
        this.callbacks.add(callback);
    }

    @Override
    public Plan buildPlan() {
        return new Path(this.orderedPath(), this.info.goal.getGoalVector());
    }

    @Override
    public VectorNode createChild(int x, int y, int z) {
        return new VectorNode(this, (Vector)new BlockVector(x, y, z), this.info);
    }

    @Override
    public PathPoint createChild(int x, int y, int z, float fixedCost) {
        VectorNode node = this.createChild(x, y, z);
        node.blockCost = node.getBlockCost() + fixedCost;
        return node;
    }

    public float distance(Vector goal) {
        int dx = Math.abs(this.location.getBlockX() - goal.getBlockX());
        int dy = Math.abs(this.location.getBlockY() - goal.getBlockY());
        int dz = Math.abs(this.location.getBlockZ() - goal.getBlockZ());
        return Math.max(dx, Math.max(dy, dz));
    }

    public float distance(VectorNode to) {
        return this.distance(to.location);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VectorNode other = (VectorNode)obj;
        return Objects.equals(this.location, other.location);
    }

    private float getBlockCost() {
        if (this.blockCost == -1.0f) {
            this.blockCost = 0.0f;
            for (BlockExaminer examiner : this.info.params.examiners()) {
                this.blockCost += examiner.getCost(this.info.blockSource, this);
            }
        }
        return this.blockCost;
    }

    @Override
    public Vector getGoal() {
        return this.info.goal.getGoalVector();
    }

    @Override
    public Iterable<AStarNode> getNeighbours() {
        List<PathPoint> neighbours = null;
        for (BlockExaminer examiner : this.info.params.examiners()) {
            if (!(examiner instanceof BlockExaminer.ReplacementNeighbourGenerator)) continue;
            neighbours = ((BlockExaminer.ReplacementNeighbourGenerator)examiner).getNeighbours(this.info.blockSource, this);
            break;
        }
        if (neighbours == null) {
            neighbours = this.getNeighbours(this.info.blockSource, this);
        }
        for (BlockExaminer examiner : this.info.params.examiners()) {
            if (!(examiner instanceof BlockExaminer.AdditionalNeighbourGenerator)) continue;
            ((BlockExaminer.AdditionalNeighbourGenerator)examiner).addNeighbours(this.info.blockSource, this, neighbours);
        }
        ArrayList<AStarNode> nodes = new ArrayList<AStarNode>(neighbours.size());
        for (PathPoint sub : neighbours) {
            if (!this.isPassable(sub)) continue;
            nodes.add((AStarNode)((Object)sub));
        }
        return nodes;
    }

    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point) {
        return this.getNeighbours(source, point, true);
    }

    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point, boolean checkPassable) {
        ArrayList<PathPoint> neighbours = new ArrayList<PathPoint>(26);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                int modY = this.location.getBlockY() + y;
                if (!source.isYWithinBounds(modY)) continue;
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || checkPassable && x != 0 && z != 0 && (!this.isPassable(point.createChild(this.location.getBlockX() + x, modY, this.location.getBlockZ())) || !this.isPassable(point.createChild(this.location.getBlockX(), modY, this.location.getBlockZ() + z)))) continue;
                    neighbours.add(point.createChild(this.location.getBlockX() + x, modY, this.location.getBlockZ() + z));
                }
            }
        }
        return neighbours;
    }

    @Override
    public PathPoint getParentPoint() {
        return (PathPoint)((Object)this.getParent());
    }

    @Override
    public List<Vector> getPathVectors() {
        return this.pathVectors;
    }

    @Override
    public Vector getVector() {
        if (this.locationCache == null) {
            this.locationCache = this.location.clone();
        }
        return this.locationCache.setX(this.location.getBlockX()).setY(this.location.getBlockY()).setZ(this.location.getBlockZ());
    }

    @Override
    public int hashCode() {
        return 31 + (this.location == null ? 0 : this.location.hashCode());
    }

    public float heuristicDistance(Vector goal) {
        return (this.distance(goal) + this.getBlockCost()) * 1.01f;
    }

    private boolean isPassable(PathPoint mod) {
        boolean canStand = false;
        BlockExaminer found = null;
        for (BlockExaminer examiner : this.info.params.examiners()) {
            BlockExaminer.StandableState state = examiner.canStandAt(this.info.blockSource, mod);
            if (state != BlockExaminer.StandableState.STANDABLE) continue;
            canStand = true;
            if (examiner.isPassable(this.info.blockSource, mod) == BlockExaminer.PassableState.PASSABLE) {
                return true;
            }
            found = examiner;
            break;
        }
        if (!canStand) {
            return false;
        }
        boolean passable = false;
        for (BlockExaminer examiner : this.info.params.examiners()) {
            BlockExaminer.PassableState state;
            if (examiner == found || (state = examiner.isPassable(this.info.blockSource, mod)) != BlockExaminer.PassableState.PASSABLE) continue;
            passable = true;
            break;
        }
        return passable;
    }

    @Override
    public void setPathVectors(List<Vector> vectors) {
        this.pathVectors = vectors;
    }

    @Override
    public void setVector(Vector vector) {
        this.location = vector;
    }

    private static class PathInfo {
        private final BlockSource blockSource;
        private final VectorGoal goal;
        private final NavigatorParameters params;

        private PathInfo(BlockSource source, NavigatorParameters params, VectorGoal goal) {
            this.blockSource = source;
            this.params = params;
            this.goal = goal;
        }
    }
}

