/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends PlayerChunkMap.EntityTracker {
    private final Entity tracker;
    private static final MethodHandle E = NMS.getGetter(EntityTrackerEntry.class, (String)"e");
    private static final MethodHandle F = NMS.getGetter(EntityTrackerEntry.class, (String)"f");
    private static volatile Boolean REQUIRES_SYNC = false;
    private static final MethodHandle TRACKER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Entity.class);
    private static final MethodHandle TRACKER_ENTRY = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
    private static final MethodHandle TRACKING_RANGE = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
    private static final MethodHandle TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
    private static final MethodHandle TRACKING_SET_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Set.class);

    public CitizensEntityTracker(PlayerChunkMap map, Entity entity, int i, int j, boolean flag) {
        PlayerChunkMap playerChunkMap = map;
        Objects.requireNonNull(playerChunkMap);
        super(playerChunkMap, entity, i, j, flag);
        this.tracker = entity;
        try {
            final Set set = this.f;
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<ServerPlayerConnection>(){

                public boolean add(ServerPlayerConnection conn) {
                    boolean res = super.add((Object)conn);
                    if (res) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)conn.f().getBukkitEntity(), !Bukkit.isPrimaryThread()));
                    }
                    return res;
                }

                protected Set<ServerPlayerConnection> delegate() {
                    return set;
                }

                public boolean remove(Object conn) {
                    boolean removed = super.remove(conn);
                    if (removed) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((ServerPlayerConnection)conn).f().getBukkitEntity()));
                    }
                    return removed;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public CitizensEntityTracker(PlayerChunkMap map, PlayerChunkMap.EntityTracker entry) {
        this(map, CitizensEntityTracker.getTracker(entry), CitizensEntityTracker.getTrackingDistance(entry), CitizensEntityTracker.getE(entry), CitizensEntityTracker.getF(entry));
    }

    public void b(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.f.contains(entityplayer.b) && this.tracker instanceof NPCHolder) {
            boolean cancelled;
            NPC npc = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (cancelled = ((Boolean)Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent event = new NPCSeenByPlayerEvent(npc, (Player)entityplayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                catch (IllegalStateException e) {
                    REQUIRES_SYNC = true;
                    throw e;
                }
                if (event.isCancelled()) {
                    return true;
                }
                Integer trackingRange = (Integer)npc.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && trackingRange != null && ((Integer)npc.data().get("last-tracking-range", (Object)-1)).intValue() != trackingRange.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, trackingRange);
                        npc.data().set("last-tracking-range", (Object)trackingRange);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }, (boolean)REQUIRES_SYNC)).booleanValue()) {
                return;
            }
        }
        super.b(entityplayer);
    }

    private static int getE(PlayerChunkMap.EntityTracker entry) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static boolean getF(PlayerChunkMap.EntityTracker entry) {
        try {
            return F.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Collection<Player> getSeenBy(PlayerChunkMap.EntityTracker tracker) {
        return tracker.f.stream().map(c -> c.f().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static Entity getTracker(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKING_RANGE.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }
}

