/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity.nonliving;

import java.util.function.Supplier;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.nms.v1_21_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftChestBoat;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;

public class ChestBoatController
extends AbstractEntityController {
    protected Entity createEntity(Location at, NPC npc) {
        EntityTypes type = EntityTypes.aI;
        Item item = Items.oF;
        switch (((MobType)npc.getOrAddTrait(MobType.class)).getType()) {
            case ACACIA_CHEST_BOAT: {
                type = EntityTypes.c;
                item = Items.oN;
                break;
            }
            case BIRCH_CHEST_BOAT: {
                type = EntityTypes.o;
                item = Items.oJ;
                break;
            }
            case CHERRY_CHEST_BOAT: {
                type = EntityTypes.y;
                item = Items.oP;
                break;
            }
            case DARK_OAK_CHEST_BOAT: {
                type = EntityTypes.H;
                item = Items.oR;
                break;
            }
            case JUNGLE_CHEST_BOAT: {
                type = EntityTypes.av;
                item = Items.oL;
                break;
            }
            case MANGROVE_CHEST_BOAT: {
                type = EntityTypes.aC;
                item = Items.oV;
                break;
            }
            case OAK_BOAT: {
                break;
            }
            case SPRUCE_CHEST_BOAT: {
                type = EntityTypes.br;
                item = Items.oH;
                break;
            }
        }
        Item fitem = item;
        EntityChestBoatNPC handle = new EntityChestBoatNPC((EntityTypes<? extends net.minecraft.world.entity.vehicle.ChestBoat>)type, (World)((CraftWorld)at.getWorld()).getHandle(), () -> fitem, npc);
        return handle.getBukkitEntity();
    }

    public ChestBoat getBukkitEntity() {
        return (ChestBoat)super.getBukkitEntity();
    }

    public static class EntityChestBoatNPC
    extends net.minecraft.world.entity.vehicle.ChestBoat
    implements NPCHolder {
        private double aC;
        private float aD;
        private AbstractBoat.EnumStatus aE;
        private AbstractBoat.EnumStatus aF;
        private double ap;
        private double ar;
        private final CitizensNPC npc;

        public EntityChestBoatNPC(EntityTypes<? extends net.minecraft.world.entity.vehicle.ChestBoat> types, World level, Supplier<Item> supplier) {
            this(types, level, supplier, null);
        }

        public EntityChestBoatNPC(EntityTypes<? extends net.minecraft.world.entity.vehicle.ChestBoat> types, World level, Supplier<Item> supplier, NPC npc) {
            super(types, level, supplier);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ChestBoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction i_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.i_();
        }

        private AbstractBoat.EnumStatus getStatus() {
            AbstractBoat.EnumStatus entityboat_Status = this.u();
            if (entityboat_Status != null) {
                this.aC = this.cR().e;
                return entityboat_Status;
            }
            if (this.t()) {
                return AbstractBoat.EnumStatus.a;
            }
            float f = this.l();
            if (f > 0.0f) {
                this.aD = f;
                return AbstractBoat.EnumStatus.d;
            }
            return AbstractBoat.EnumStatus.e;
        }

        public boolean bG() {
            return this.npc == null ? super.bG() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void h_() {
            if (this.npc == null) {
                super.h_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.ak);
            }
        }

        public boolean g(NBTTagCompound save) {
            return this.npc == null ? super.g(save) : false;
        }

        private boolean t() {
            boolean m = false;
            AxisAlignedBB axisalignedbb = this.cR();
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.b);
            int l = MathHelper.c((double)(axisalignedbb.b + 0.001));
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            this.aC = Double.MIN_VALUE;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.dV().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a)) continue;
                        float f = (float)l1 + fluid.a((IBlockAccess)this.dV(), (BlockPosition)blockposition_mutableblockposition);
                        this.aC = Math.max((double)f, this.aC);
                        m = flag | axisalignedbb.b < (double)f;
                    }
                }
            }
            return m;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            if (this.npc != null) {
                this.npc.update();
                this.aF = this.aE;
                this.aE = this.getStatus();
                double d1 = this.bb() ? 0.0 : -0.04;
                double d2 = 0.0;
                this.ap = 0.05f;
                if (this.aF == AbstractBoat.EnumStatus.e && this.aE != AbstractBoat.EnumStatus.e && this.aE != AbstractBoat.EnumStatus.d) {
                    this.aC = this.e(1.0);
                    this.a_(this.dA(), (double)(this.i() - this.dr()) + 0.101, this.dG());
                    this.i(this.dy().d(1.0, 0.0, 1.0));
                    this.aE = AbstractBoat.EnumStatus.a;
                } else {
                    if (this.aE == AbstractBoat.EnumStatus.a) {
                        d2 = (this.aC - this.dC()) / (double)this.dr();
                        this.ap = 0.9f;
                    } else if (this.aE == AbstractBoat.EnumStatus.c) {
                        d1 = -7.0E-4;
                        this.ap = 0.9f;
                    } else if (this.aE == AbstractBoat.EnumStatus.b) {
                        d2 = 0.01;
                        this.ap = 0.45f;
                    } else if (this.aE == AbstractBoat.EnumStatus.e) {
                        this.ap = 0.9f;
                    } else if (this.aE == AbstractBoat.EnumStatus.d) {
                        this.ap = this.aD;
                        if (this.cW() instanceof EntityPlayer) {
                            this.aD /= 2.0f;
                        }
                    }
                    Vec3D vec3d = this.dy();
                    this.n(vec3d.d * this.ap, vec3d.e + d1, vec3d.f * this.ap);
                    this.ar *= this.ap;
                    if (d2 > 0.0) {
                        Vec3D vec3d1 = this.dy();
                        this.n(vec3d1.d, vec3d1.e + d2 * 0.0615, vec3d1.f);
                    }
                }
                this.a(EnumMoveType.a, this.dy());
                if (this.bZ()) {
                    this.w((float)((double)this.dL() + this.ar));
                }
            } else {
                super.g();
            }
        }

        private AbstractBoat.EnumStatus u() {
            AxisAlignedBB axisalignedbb = this.cR();
            double d0 = axisalignedbb.e + 0.001;
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.e);
            int l = MathHelper.c((double)d0);
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.dV().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.dV(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                        if (!fluid.b()) {
                            return AbstractBoat.EnumStatus.c;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? AbstractBoat.EnumStatus.b : null;
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class ChestBoatNPC
    extends CraftChestBoat
    implements ForwardingNPCHolder {
        public ChestBoatNPC(EntityChestBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (AbstractChestBoat)entity);
        }
    }
}

