/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R5.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends atf.b {
    private final bzm tracker;
    private static volatile Boolean REQUIRES_SYNC;
    private static final MethodHandle TRACK_DELTA;
    private static final MethodHandle TRACKER;
    private static final MethodHandle TRACKER_ENTRY;
    private static final MethodHandle TRACKING_RANGE;
    private static final MethodHandle TRACKING_RANGE_SETTER;
    private static final MethodHandle TRACKING_SET_SETTER;
    private static final MethodHandle UPDATE_INTERVAL;

    public CitizensEntityTracker(atf map, bzm entity, int i, int j, boolean flag) {
        atf atf2 = map;
        Objects.requireNonNull(atf2);
        super(atf2, entity, i, j, flag);
        this.tracker = entity;
        try {
            final Set set = this.f;
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<avi>(){

                public boolean add(avi conn) {
                    boolean res = super.add((Object)conn);
                    if (res) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)conn.o().getBukkitEntity(), !Bukkit.isPrimaryThread()));
                    }
                    return res;
                }

                protected Set<avi> delegate() {
                    return set;
                }

                public boolean remove(Object conn) {
                    boolean removed = super.remove(conn);
                    if (removed) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((avi)conn).o().getBukkitEntity()));
                    }
                    return removed;
                }
            });
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public CitizensEntityTracker(atf map, atf.b entry) {
        this(map, CitizensEntityTracker.getTracker(entry), CitizensEntityTracker.getTrackingDistance(entry), CitizensEntityTracker.getUpdateInterval(entry), CitizensEntityTracker.getTrackDelta(entry));
    }

    public void b(auc entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.tracker.dU() && !this.f.contains(entityplayer.g) && this.tracker instanceof NPCHolder) {
            boolean cancelled;
            NPC npc = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (cancelled = ((Boolean)Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent event = new NPCSeenByPlayerEvent(npc, (Player)entityplayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                catch (IllegalStateException e2) {
                    REQUIRES_SYNC = true;
                    throw e2;
                }
                if (event.isCancelled()) {
                    return true;
                }
                Integer trackingRange = (Integer)npc.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && trackingRange != null && ((Integer)npc.data().get("last-tracking-range", (Object)-1)).intValue() != trackingRange.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, trackingRange);
                        npc.data().set("last-tracking-range", (Object)trackingRange);
                    }
                    catch (Throwable e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }, (boolean)REQUIRES_SYNC)).booleanValue()) {
                return;
            }
        }
        super.b(entityplayer);
    }

    public static Collection<Entity> getSeenBy(atf.b tracker) {
        return tracker.f.stream().map(c2 -> c2.o().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static boolean getTrackDelta(atf.b entry) {
        try {
            return TRACK_DELTA.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static bzm getTracker(atf.b entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(atf.b entry) {
        try {
            return TRACKING_RANGE.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static int getUpdateInterval(atf.b entry) {
        try {
            return UPDATE_INTERVAL.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    static {
        TRACK_DELTA = NMSImpl.SERVER_ENTITY_TRACK_DELTA;
        TRACKER = NMS.getFirstGetter(atf.b.class, bzm.class);
        TRACKER_ENTRY = NMS.getFirstGetter(atf.b.class, atz.class);
        TRACKING_RANGE = NMS.getFirstGetter(atf.b.class, Integer.TYPE);
        TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(atf.b.class, Integer.TYPE);
        TRACKING_SET_SETTER = NMS.getFirstFinalSetter(atf.b.class, Set.class);
        UPDATE_INTERVAL = NMSImpl.SERVER_ENTITY_UPDATE_INTERVAL;
    }
}

