/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class HumanController
extends AbstractEntityController {
    protected Entity createEntity(Location at, NPC npc) {
        axf nmsWorld = ((CraftWorld)at.getWorld()).getHandle();
        String coloredName = npc.getFullName();
        String name = coloredName.length() > 16 ? coloredName.substring(0, 16) : coloredName;
        UUID uuid = npc.getMinecraftUniqueId();
        String teamName = Util.getTeamName((UUID)uuid);
        if (npc.requiresNameHologram()) {
            name = teamName;
        }
        if (Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            ((ScoreboardTrait)npc.getOrAddTrait(ScoreboardTrait.class)).createTeam(name);
        }
        GameProfile profile = new GameProfile(uuid, name);
        EntityHumanNPC handle = new EntityHumanNPC(MinecraftServer.getServer(), nmsWorld, profile, awp.a(), npc);
        Skin skin = handle.getSkinTracker().getSkin();
        if (skin != null) {
            skin.apply((SkinnableEntity)handle);
        }
        if (NMSImpl.MOONRISE_IS_REAL_PLAYER != null) {
            try {
                NMSImpl.MOONRISE_IS_REAL_PLAYER.invoke(handle, !npc.shouldRemoveFromPlayerList());
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            if (this.getBukkitEntity() == null || !this.getBukkitEntity().isValid() || this.getBukkitEntity() != handle.getBukkitEntity()) {
                return;
            }
            NMS.addOrRemoveFromPlayerList((Entity)this.getBukkitEntity(), (boolean)npc.shouldRemoveFromPlayerList());
        }, 20L);
        handle.getBukkitEntity().setSleepingIgnored(true);
        return handle.getBukkitEntity();
    }

    public Player getBukkitEntity() {
        return (Player)super.getBukkitEntity();
    }
}

