/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R7.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R7.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R7.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public cno getJumpControl();

    public Map<fls, Float> getMalus();

    public cnq getMoveControl();

    public cre getNavigation();

    default public float getPathfindingMalus(fls var1) {
        Map<fls, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(fls water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        cre nav = this.getNavigation();
        if (!nav.l()) {
            nav.d();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((chl)NMSImpl.getHandle(this.getBukkitEntity())).h(cis.o).a((double)range);
    }

    public static MobAI from(cgk handle) {
        if (handle instanceof chn) {
            final chn mob = (chn)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public cno getJumpControl() {
                    return mob.L();
                }

                @Override
                public Map<fls, Float> getMalus() {
                    return null;
                }

                @Override
                public cnq getMoveControl() {
                    return mob.K();
                }

                @Override
                public cre getNavigation() {
                    return mob.N();
                }

                @Override
                public float getPathfindingMalus(fls var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(fls water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.P().a();
                    mob.N().d();
                    mob.K().a();
                    mob.J().a();
                    mob.L().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public cno getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<fls, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public cnq getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public cre getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final chl entity;
        private final Map<fls, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(chl entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (jd<cin>)cis.o, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.h(cis.x).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.ao());
            this.malus = Maps.newEnumMap(fls.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public cno getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<fls, Float> getMalus() {
            return this.malus;
        }

        @Override
        public cnq getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public cre getNavigation() {
            return this.navigation;
        }
    }
}

