/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.trait.trait.Speech;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.commands.NPCCommandSelector;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.Template;
import net.citizensnpcs.npc.entity.nonliving.FallingBlockController;
import net.citizensnpcs.npc.entity.nonliving.ItemController;
import net.citizensnpcs.npc.entity.nonliving.ItemFrameController;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.NPCSkeletonType;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.ZombieModifier;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
    private final NPCSelector selector;

    public NPCCommands(Citizens plugin) {
        this.selector = plugin.getNPCSelector();
    }

    @Command(aliases={"npc"}, usage="age [age] (-l)", desc="Set the age of a NPC", help="citizens.commands.npc.age.help", flags="l", modifiers={"age"}, min=1, max=2, permission="citizens.npc.age")
    public void age(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof Ageable)) {
            throw new CommandException("citizens.commands.npc.age.cannot-be-aged");
        }
        Age trait = npc.getTrait(Age.class);
        boolean toggleLock = args.hasFlag('l');
        if (toggleLock) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.age.locked" : "citizens.commands.npc.age.unlocked", new Object[0]);
        }
        if (args.argsLength() <= 1) {
            if (!toggleLock) {
                trait.describe(sender);
            }
            return;
        }
        int age = 0;
        try {
            age = args.getInteger(1);
            if (age > 0) {
                throw new CommandException("citizens.commands.npc.age.invalid-age");
            }
            Messaging.sendTr(sender, "citizens.commands.npc.age.set-normal", npc.getName(), age);
        }
        catch (NumberFormatException ex) {
            if (args.getString(1).equalsIgnoreCase("baby")) {
                age = -24000;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-baby", npc.getName());
            }
            if (args.getString(1).equalsIgnoreCase("adult")) {
                age = 0;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-adult", npc.getName());
            }
            throw new CommandException("citizens.commands.npc.age.invalid-age");
        }
        trait.setAge(age);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="anchor (--save [name]|--assume [name]|--remove [name]) (-a)(-c)", desc="Changes/Saves/Lists NPC's location anchor(s)", flags="ac", modifiers={"anchor"}, min=1, max=3, permission="citizens.npc.anchor")
    public void anchor(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Anchors trait = npc.getTrait(Anchors.class);
        if (args.hasValueFlag("save")) {
            if (args.getFlag("save").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (args.hasFlag('c')) {
                if (!trait.addAnchor(args.getFlag("save"), args.getSenderTargetBlockLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", args.getFlag("save"));
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            } else {
                if (!trait.addAnchor(args.getFlag("save"), args.getSenderLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", args.getFlag("save"));
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            }
        } else if (args.hasValueFlag("assume")) {
            if (args.getFlag("assume").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            Anchor anchor = trait.getAnchor(args.getFlag("assume"));
            if (anchor == null) {
                throw new CommandException("citizens.commands.npc.anchor.missing", args.getFlag("assume"));
            }
            npc.teleport(anchor.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        } else if (args.hasValueFlag("remove")) {
            if (args.getFlag("remove").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (!trait.removeAnchor(trait.getAnchor(args.getFlag("remove")))) throw new CommandException("citizens.commands.npc.anchor.missing", args.getFlag("remove"));
            Messaging.sendTr(sender, "citizens.commands.npc.anchor.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            Paginator paginator = new Paginator().header("Anchors");
            paginator.addLine("<e>Key: <a>ID  <b>Name  <c>World  <d>Location (X,Y,Z)");
            for (int i = 0; i < trait.getAnchors().size(); ++i) {
                if (trait.getAnchors().get(i).isLoaded()) {
                    String line = "<a>" + i + "<b>  " + trait.getAnchors().get(i).getName() + "<c>  " + trait.getAnchors().get(i).getLocation().getWorld().getName() + "<d>  " + trait.getAnchors().get(i).getLocation().getBlockX() + ", " + trait.getAnchors().get(i).getLocation().getBlockY() + ", " + trait.getAnchors().get(i).getLocation().getBlockZ();
                    paginator.addLine(line);
                    continue;
                }
                String[] parts = trait.getAnchors().get(i).getUnloadedValue();
                String line = "<a>" + i + "<b>  " + trait.getAnchors().get(i).getName() + "<c>  " + parts[0] + "<d>  " + parts[1] + ", " + parts[2] + ", " + parts[3] + " <f>(unloaded)";
                paginator.addLine(line);
            }
            int page = args.getInteger(1, 1);
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        npc.teleport(args.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    @Command(aliases={"npc"}, usage="controllable|control (-m(ount),-y,-n,-o)", desc="Toggles whether the NPC can be ridden and controlled", modifiers={"controllable", "control"}, min=1, max=1, flags="myno")
    public void controllable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.isSpawned() && !sender.hasPermission("citizens.npc.controllable." + npc.getEntity().getType().name().toLowerCase().replace("_", "")) || !sender.hasPermission("citizens.npc.controllable")) {
            throw new NoPermissionsException();
        }
        if (!npc.hasTrait(Controllable.class)) {
            npc.addTrait(new Controllable(false));
        }
        Controllable trait = npc.getTrait(Controllable.class);
        boolean enabled = trait.toggle();
        if (args.hasFlag('y')) {
            enabled = trait.setEnabled(true);
        } else if (args.hasFlag('n')) {
            enabled = trait.setEnabled(false);
        }
        trait.setOwnerRequired(args.hasFlag('o'));
        String key = enabled ? "citizens.commands.npc.controllable.set" : "citizens.commands.npc.controllable.removed";
        Messaging.sendTr(sender, key, npc.getName());
        if (enabled && args.hasFlag('m') && sender instanceof Player) {
            trait.mount((Player)sender);
        }
    }

    @Command(aliases={"npc"}, usage="copy (--name newname)", desc="Copies an NPC", modifiers={"copy"}, min=1, max=1, permission="citizens.npc.copy")
    public void copy(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String name = args.getFlag("name", npc.getFullName());
        NPC copy = npc.clone();
        if (!copy.getFullName().equals(name)) {
            copy.setName(name);
        }
        if (copy.isSpawned() && args.getSenderLocation() != null) {
            Location location = args.getSenderLocation();
            location.getChunk().load();
            copy.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
            copy.getTrait(CurrentLocation.class).setLocation(location);
        }
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCreateNPCEvent((Player)sender, copy) : new CommandSenderCreateNPCEvent(sender, copy);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            event.getNPC().destroy();
            String reason = "Couldn't create NPC.";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + " Reason: " + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.copy.copied", npc.getName());
        this.selector.select(sender, copy);
    }

    @Command(aliases={"npc"}, usage="create [name] ((-b,u) --at (x:y:z:world) --type (type) --trait ('trait1, trait2...') --b (behaviours))", desc="Create a new NPC", flags="bu", modifiers={"create"}, min=2, permission="citizens.npc.create")
    @Requirements
    public void create(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        StringBuilder builder;
        Iterable parts;
        int nameLength;
        String name = Colorizer.parseColors(args.getJoinedStrings(1).trim());
        EntityType type = EntityType.PLAYER;
        if (args.hasValueFlag("type")) {
            String inputType = args.getFlag("type");
            type = Util.matchEntityType(inputType);
            if (type == null) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.invalid-mobtype", inputType));
            }
            if (!EntityControllers.controllerExistsForType(type)) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.mobtype-missing", inputType));
            }
        }
        int n = nameLength = type == EntityType.PLAYER ? 46 : 64;
        if (name.length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", new Object[0]);
            name = name.substring(0, nameLength);
        }
        if (name.length() == 0) {
            throw new CommandException();
        }
        if (!(sender.hasPermission("citizens.npc.create.*") || sender.hasPermission("citizens.npc.createall") || sender.hasPermission("citizens.npc.create." + type.name().toLowerCase().replace("_", "")))) {
            throw new NoPermissionsException();
        }
        npc = this.npcRegistry.createNPC(type, name);
        String msg = "You created [[" + npc.getName() + "]]";
        int age = 0;
        if (args.hasFlag('b')) {
            if (!Ageable.class.isAssignableFrom(type.getEntityClass())) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.age.cannot-be-aged", type.name().toLowerCase().replace("_", "-"));
            } else {
                age = -24000;
                msg = msg + " as a baby";
            }
        }
        if (!Settings.Setting.SERVER_OWNS_NPCS.asBoolean()) {
            npc.getTrait(Owner.class).setOwner(sender);
        }
        npc.getTrait(MobType.class).setType(type);
        Location spawnLoc = null;
        if (sender instanceof Player) {
            spawnLoc = args.getSenderLocation();
        } else if (sender instanceof BlockCommandSender) {
            spawnLoc = args.getSenderLocation();
        }
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCreateNPCEvent((Player)sender, npc) : new CommandSenderCreateNPCEvent(sender, npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            npc.destroy();
            String reason = "Couldn't create NPC.";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + " Reason: " + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        if (args.hasValueFlag("at")) {
            spawnLoc = CommandContext.parseLocation(args.getSenderLocation(), args.getFlag("at"));
        }
        if (spawnLoc == null) {
            npc.destroy();
            throw new CommandException("citizens.commands.npc.create.invalid-location");
        }
        if (!args.hasFlag('u')) {
            npc.spawn(spawnLoc);
        }
        if (args.hasValueFlag("trait")) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)args.getFlag("trait"));
            builder = new StringBuilder();
            for (String tr : parts) {
                Object trait = CitizensAPI.getTraitFactory().getTrait(tr);
                if (trait == null) continue;
                npc.addTrait((Trait)trait);
                builder.append(StringHelper.wrap(tr) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with traits " + builder.toString();
        }
        if (args.hasValueFlag("template")) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)args.getFlag("template"));
            builder = new StringBuilder();
            for (String part : parts) {
                Template template = Template.byName(part);
                if (template == null) continue;
                template.apply(npc);
                builder.append(StringHelper.wrap(part) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with templates " + builder.toString();
        }
        if (npc.getEntity() instanceof Ageable) {
            npc.getTrait(Age.class).setAge(age);
        }
        this.selector.select(sender, npc);
        Messaging.send(sender, msg + '.');
    }

    @Command(aliases={"npc"}, usage="despawn (id)", desc="Despawn a NPC", modifiers={"despawn"}, min=1, max=2, permission="citizens.npc.despawn")
    @Requirements
    public void despawn(final CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC npc) throws CommandException {
                if (npc == null) {
                    throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
                }
                npc.getTrait(Spawned.class).setSpawned(false);
                npc.despawn(DespawnReason.REMOVAL);
                Messaging.sendTr(sender, "citizens.commands.npc.despawn.despawned", npc.getName());
            }
        };
        if (npc == null || args.argsLength() == 2) {
            if (args.argsLength() < 2) {
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            NPCCommandSelector.startWithCallback(callback, this.npcRegistry, sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="flyable (true|false)", desc="Toggles or sets an NPC's flyable status", modifiers={"flyable"}, min=1, max=2, permission="citizens.npc.flyable")
    @Requirements(selected=true, ownership=true, excludedTypes={EntityType.BAT, EntityType.BLAZE, EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.WITHER})
    public void flyable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean flyable = args.argsLength() == 2 ? args.getString(1).equals("true") : !npc.isFlyable();
        npc.setFlyable(flyable);
        flyable = npc.isFlyable();
        Messaging.sendTr(sender, flyable ? "citizens.commands.npc.flyable.set" : "citizens.commands.npc.flyable.unset", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="gamemode [gamemode]", desc="Changes the gamemode", modifiers={"gamemode"}, min=1, max=2, permission="citizens.npc.gravity")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void gamemode(CommandContext args, CommandSender sender, NPC npc) {
        Player player = (Player)npc.getEntity();
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.gamemode.describe", npc.getName(), player.getGameMode().name().toLowerCase());
            return;
        }
        GameMode mode = null;
        try {
            int value = args.getInteger(1);
            mode = GameMode.getByValue((int)value);
        }
        catch (NumberFormatException ex) {
            try {
                mode = GameMode.valueOf((String)args.getString(1));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (mode == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.gamemode.invalid", args.getString(1));
            return;
        }
        player.setGameMode(mode);
        Messaging.sendTr(sender, "citizens.commands.npc.gamemode.set", mode.name().toLowerCase());
    }

    @Command(aliases={"npc"}, usage="gravity", desc="Toggles gravity", modifiers={"gravity"}, min=1, max=1, permission="citizens.npc.gravity")
    public void gravity(CommandContext args, CommandSender sender, NPC npc) {
        boolean enabled = npc.getTrait(Gravity.class).toggle();
        String key = !enabled ? "citizens.commands.npc.gravity.enabled" : "citizens.commands.npc.gravity.disabled";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="horse (--color color) (--type type) (--style style) (-cb)", desc="Sets horse modifiers", help="Use the -c flag to make the horse have a chest, or the -b flag to stop them from having a chest.", modifiers={"horse"}, min=1, max=1, flags="cb", permission="citizens.npc.horse")
    @Requirements(selected=true, ownership=true, types={EntityType.HORSE})
    public void horse(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String valid;
        HorseModifiers horse = npc.getTrait(HorseModifiers.class);
        String output = "";
        if (args.hasFlag('c')) {
            horse.setCarryingChest(true);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (args.hasFlag('b')) {
            horse.setCarryingChest(false);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (args.hasValueFlag("color") || args.hasValueFlag("colour")) {
            String colorRaw = args.getFlag("color", args.getFlag("colour"));
            Horse.Color color = (Horse.Color)Util.matchEnum((Enum[])Horse.Color.values(), (String)colorRaw);
            if (color == null) {
                String valid2 = Util.listValuesPretty(Horse.Color.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-color", valid2);
            }
            horse.setColor(color);
            output = output + Messaging.tr("citizens.commands.npc.horse.color-set", Util.prettyEnum(color));
        }
        if (args.hasValueFlag("type")) {
            Horse.Variant variant = (Horse.Variant)Util.matchEnum((Enum[])Horse.Variant.values(), (String)args.getFlag("type"));
            if (variant == null) {
                valid = Util.listValuesPretty(Horse.Variant.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-variant", valid);
            }
            horse.setType(variant);
            output = output + Messaging.tr("citizens.commands.npc.horse.type-set", Util.prettyEnum(variant));
        }
        if (args.hasValueFlag("style")) {
            Horse.Style style = (Horse.Style)Util.matchEnum((Enum[])Horse.Style.values(), (String)args.getFlag("style"));
            if (style == null) {
                valid = Util.listValuesPretty(Horse.Style.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-style", valid);
            }
            horse.setStyle(style);
            output = output + Messaging.tr("citizens.commands.npc.horse.style-set", Util.prettyEnum(style));
        }
        if (output.isEmpty()) {
            Messaging.sendTr(sender, "citizens.commands.npc.horse.describe", Util.prettyEnum(horse.getColor()), Util.prettyEnum(horse.getType()), Util.prettyEnum(horse.getStyle()));
        } else {
            sender.sendMessage(output);
        }
    }

    @Command(aliases={"npc"}, usage="id", desc="Sends the selected NPC's ID to the sender", modifiers={"id"}, min=1, max=1, permission="citizens.npc.id")
    public void id(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, npc.getId());
    }

    @Command(aliases={"npc"}, usage="item [item] (data)", desc="Sets the NPC's item", modifiers={"item"}, min=2, max=3, flags="", permission="citizens.npc.item")
    @Requirements(selected=true, ownership=true, types={EntityType.DROPPED_ITEM, EntityType.ITEM_FRAME, EntityType.FALLING_BLOCK})
    public void item(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Material mat = Material.matchMaterial((String)args.getString(1));
        if (mat == null) {
            throw new CommandException("citizens.commands.npc.item.unknown-material");
        }
        int data = args.getInteger(2, 0);
        switch (npc.getEntity().getType()) {
            case DROPPED_ITEM: {
                ((Item)npc.getEntity()).getItemStack().setType(mat);
                ((ItemController.ItemNPC)npc.getEntity()).setType(mat, data);
                break;
            }
            case ITEM_FRAME: {
                ((ItemFrame)npc.getEntity()).getItem().setType(mat);
                ((ItemFrameController.ItemFrameNPC)npc.getEntity()).setType(mat, data);
                break;
            }
            case FALLING_BLOCK: {
                ((FallingBlockController.FallingBlockNPC)npc.getEntity()).setType(mat, data);
                break;
            }
        }
        Messaging.sendTr(sender, "citizens.commands.npc.item.item-set", Util.prettyEnum(mat));
    }

    @Command(aliases={"npc"}, usage="leashable", desc="Toggles leashability", modifiers={"leashable"}, min=1, max=1, flags="t", permission="citizens.npc.leashable")
    public void leashable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = npc.data().get("protected-leash", true) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected-leash", vulnerable);
        } else {
            npc.data().setPersistent("protected-leash", vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.leashable.stopped" : "citizens.commands.npc.leashable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char) --registry (name))", desc="List NPCs", flags="a", modifiers={"list"}, min=1, max=2, permission="citizens.npc.list")
    @Requirements
    public void list(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        NPCRegistry source;
        NPCRegistry nPCRegistry = source = args.hasValueFlag("registry") ? CitizensAPI.getNamedNPCRegistry(args.getFlag("registry")) : this.npcRegistry;
        if (source == null) {
            throw new CommandException();
        }
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        if (args.hasFlag('a')) {
            for (NPC add : source.sorted()) {
                npcs.add(add);
            }
        } else if (args.getValueFlags().size() == 0 && sender instanceof Player) {
            for (NPC add : source.sorted()) {
                if (npcs.contains(add) || !add.getTrait(Owner.class).isOwnedBy(sender)) continue;
                npcs.add(add);
            }
        } else {
            if (args.hasValueFlag("owner")) {
                String name = args.getFlag("owner");
                for (NPC add : source.sorted()) {
                    if (npcs.contains(add) || !add.getTrait(Owner.class).isOwnedBy(name)) continue;
                    npcs.add(add);
                }
            }
            if (args.hasValueFlag("type")) {
                EntityType type = Util.matchEntityType(args.getFlag("type"));
                if (type == null) {
                    throw new CommandException("citizens.commands.invalid-mobtype", type);
                }
                for (NPC add : source) {
                    if (npcs.contains(add) || add.getTrait(MobType.class).getType() != type) continue;
                    npcs.add(add);
                }
            }
        }
        Paginator paginator = new Paginator().header("NPCs");
        paginator.addLine("<e>Key: <a>ID  <b>Name");
        for (int i = 0; i < npcs.size(); i += 2) {
            String line = "<a>" + ((NPC)npcs.get(i)).getId() + "<b>  " + ((NPC)npcs.get(i)).getName();
            if (npcs.size() >= i + 2) {
                line = line + "      <a>" + ((NPC)npcs.get(i + 1)).getId() + "<b>  " + ((NPC)npcs.get(i + 1)).getName();
            }
            paginator.addLine(line);
        }
        int page = args.getInteger(1, 1);
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing");
        }
    }

    @Command(aliases={"npc"}, usage="lookclose", desc="Toggle whether a NPC will look when a player is near", modifiers={"lookclose", "look", "rotate"}, min=1, max=1, permission="citizens.npc.lookclose")
    public void lookClose(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, npc.getTrait(LookClose.class).toggle() ? "citizens.commands.npc.lookclose.set" : "citizens.commands.npc.lookclose.stopped", npc.getName());
    }

    @Command(aliases={"npc"}, usage="minecart (--item item_name(:data)) (--offset offset)", desc="Sets minecart item", modifiers={"minecart"}, min=1, max=1, flags="", permission="citizens.npc.minecart")
    @Requirements(selected=true, ownership=true, types={EntityType.MINECART, EntityType.MINECART_CHEST, EntityType.MINECART_COMMAND, EntityType.MINECART_FURNACE, EntityType.MINECART_HOPPER, EntityType.MINECART_MOB_SPAWNER, EntityType.MINECART_TNT})
    public void minecart(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.hasValueFlag("item")) {
            Material material;
            String raw = args.getFlag("item");
            int data = 0;
            if (raw.contains(":")) {
                int dataIndex = raw.indexOf(58);
                data = Integer.parseInt(raw.substring(dataIndex + 1));
                raw = raw.substring(0, dataIndex);
            }
            if ((material = Material.matchMaterial((String)raw)) == null) {
                throw new CommandException();
            }
            npc.data().setPersistent("minecart-item-name", material.name());
            npc.data().setPersistent("minecart-item-data", data);
        }
        if (args.hasValueFlag("offset")) {
            npc.data().setPersistent("minecart-item-offset", args.getFlagInteger("offset"));
        }
        Messaging.sendTr(sender, "citizens.commands.npc.minecart.set", npc.data().get("minecart-item-name", ""), npc.data().get("minecart-item-data", 0), npc.data().get("minecart-item-offset", 0));
    }

    @Command(aliases={"npc"}, usage="mount", desc="Mounts a controllable NPC", modifiers={"mount"}, min=1, max=1, permission="citizens.npc.controllable")
    public void mount(CommandContext args, Player player, NPC npc) {
        boolean enabled;
        boolean bl = enabled = npc.hasTrait(Controllable.class) && npc.getTrait(Controllable.class).isEnabled();
        if (!enabled) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.controllable.not-controllable", npc.getName());
            return;
        }
        boolean success = npc.getTrait(Controllable.class).mount(player);
        if (!success) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.mount.failed", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="moveto x:y:z:world | x y z world", desc="Teleports a NPC to a given location", modifiers={"moveto"}, min=1, permission="citizens.npc.moveto")
    public void moveto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to;
        if (!npc.isSpawned()) {
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        if (!npc.isSpawned()) {
            throw new CommandException("NPC could not be spawned.");
        }
        Location current = npc.getEntity().getLocation();
        if (args.argsLength() > 1) {
            World world;
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)args.getJoinedStrings(1, ':')), String.class);
            if (parts.length != 4 && parts.length != 3) {
                throw new CommandException("citizens.commands.npc.moveto.format");
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            World world2 = world = parts.length == 4 ? Bukkit.getWorld((String)parts[3]) : current.getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            to = new Location(world, x, y, z, current.getYaw(), current.getPitch());
        } else {
            to = current.clone();
            if (args.hasValueFlag("x")) {
                to.setX(args.getFlagDouble("x"));
            }
            if (args.hasValueFlag("y")) {
                to.setY(args.getFlagDouble("y"));
            }
            if (args.hasValueFlag("z")) {
                to.setZ(args.getFlagDouble("z"));
            }
            if (args.hasValueFlag("yaw")) {
                to.setYaw((float)args.getFlagDouble("yaw"));
            }
            if (args.hasValueFlag("pitch")) {
                to.setPitch((float)args.getFlagDouble("pitch"));
            }
            if (args.hasValueFlag("world")) {
                World world = Bukkit.getWorld((String)args.getFlag("world"));
                if (world == null) {
                    throw new CommandException("citizens.commands.errors.missing-world");
                }
                to.setWorld(world);
            }
        }
        npc.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr(sender, "citizens.commands.npc.moveto.teleported", npc.getName(), to);
    }

    @Command(aliases={"npc"}, modifiers={"name"}, usage="name", desc="Toggle nameplate visibility", min=1, max=1, permission="citizens.npc.name")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public void name(CommandContext args, CommandSender sender, NPC npc) {
        LivingEntity entity;
        entity.setCustomNameVisible(!(entity = (LivingEntity)npc.getEntity()).isCustomNameVisible());
        npc.data().setPersistent("nameplate-visible", entity.isCustomNameVisible());
        Messaging.sendTr(sender, "citizens.commands.npc.nameplate.toggled", new Object[0]);
    }

    @Command(aliases={"npc"}, desc="Show basic NPC information", max=0, permission="citizens.npc.info")
    public void npc(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, StringHelper.wrapHeader(npc.getName()));
        Messaging.send(sender, "    <a>ID: <e>" + npc.getId());
        Messaging.send(sender, "    <a>Type: <e>" + npc.getTrait(MobType.class).getType());
        if (npc.isSpawned()) {
            Location loc = npc.getEntity().getLocation();
            String format = "    <a>Spawned at <e>%d, %d, %d <a>in world<e> %s";
            Messaging.send(sender, String.format(format, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName()));
        }
        Messaging.send(sender, "    <a>Traits<e>");
        for (Trait trait : npc.getTraits()) {
            if (CitizensAPI.getTraitFactory().isInternalTrait(trait)) continue;
            String message = "     <e>- <a>" + trait.getName();
            Messaging.send(sender, message);
        }
    }

    @Command(aliases={"npc"}, usage="ocelot (--type type) (-s(itting), -n(ot sitting))", desc="Set the ocelot type of an NPC and whether it is sitting", modifiers={"ocelot"}, min=1, max=1, flags="sn", permission="citizens.npc.ocelot")
    @Requirements(selected=true, ownership=true, types={EntityType.OCELOT})
    public void ocelot(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        OcelotModifiers trait = npc.getTrait(OcelotModifiers.class);
        if (args.hasFlag('s')) {
            trait.setSitting(true);
        } else if (args.hasFlag('n')) {
            trait.setSitting(false);
        }
        if (args.hasValueFlag("type")) {
            Ocelot.Type type = (Ocelot.Type)Util.matchEnum((Enum[])Ocelot.Type.values(), (String)args.getFlag("type"));
            if (type == null) {
                String valid = Util.listValuesPretty(Ocelot.Type.values());
                throw new CommandException("citizens.commands.npc.ocelot.invalid-type", valid);
            }
            trait.setType(type);
        }
    }

    @Command(aliases={"npc"}, usage="owner [name]", desc="Set the owner of an NPC", modifiers={"owner"}, min=1, max=2, permission="citizens.npc.owner")
    public void owner(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Owner ownerTrait = npc.getTrait(Owner.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.owner.owner", npc.getName(), ownerTrait.getOwner());
            return;
        }
        String name = args.getString(1);
        if (ownerTrait.isOwnedBy(name)) {
            throw new CommandException("citizens.commands.npc.owner.already-owner", name, npc.getName());
        }
        ownerTrait.setOwner(name);
        boolean serverOwner = name.equalsIgnoreCase("server");
        Messaging.sendTr(sender, serverOwner ? "citizens.commands.npc.owner.set-server" : "citizens.commands.npc.owner.set", npc.getName(), name);
    }

    @Command(aliases={"npc"}, usage="passive (--set [true|false])", desc="Sets whether an NPC damages other entities or not", modifiers={"passive"}, min=1, max=1, permission="citizens.npc.passive")
    public void passive(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean passive = args.hasValueFlag("set") ? Boolean.parseBoolean(args.getFlag("set")) : npc.data().get("damage-others", true);
        npc.data().setPersistent("damage-others", !passive);
        Messaging.sendTr(sender, passive ? "citizens.commands.npc.passive.set" : "citizens.commands.npc.passive.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="pathopt --avoid-water|aw [true|false]", desc="Sets an NPC's pathfinding options", modifiers={"pathopt", "po", "patho"}, min=1, max=1, permission="citizens.npc.pathfindingoptions")
    public void pathfindingOptions(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!args.hasValueFlag("avoid-water") && !args.hasValueFlag("aw")) {
            throw new CommandException();
        }
        String raw = args.getFlag("avoid-water", args.getFlag("aw"));
        boolean avoid = Boolean.parseBoolean(raw);
        npc.getNavigator().getDefaultParameters().avoidWater(avoid);
        Messaging.sendTr(sender, avoid ? "citizens.commands.npc.pathopt.avoid-water-set" : "citizens.commands.npc.pathopt.avoid-water-unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="pathrange [range]", desc="Sets an NPC's pathfinding range", modifiers={"pathrange", "pathfindingrange", "prange"}, min=2, max=2, permission="citizens.npc.pathfindingrange")
    public void pathfindingRange(CommandContext args, CommandSender sender, NPC npc) {
        double range = Math.max(1.0, args.getDouble(1));
        npc.getNavigator().getDefaultParameters().range((float)range);
        Messaging.sendTr(sender, "citizens.commands.npc.pathfindingrange.set", range);
    }

    @Command(aliases={"npc"}, usage="playerlist (-a,r)", desc="Sets whether the NPC is put in the playerlist", modifiers={"playerlist"}, min=1, max=1, flags="ar", permission="citizens.npc.playerlist")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerlist(CommandContext args, CommandSender sender, NPC npc) {
        boolean remove;
        boolean bl = remove = npc.data().get("removefromplayerlist", Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()) == false;
        if (args.hasFlag('a')) {
            remove = false;
        } else if (args.hasFlag('r')) {
            remove = true;
        }
        npc.data().setPersistent("removefromplayerlist", remove);
        if (npc.isSpawned()) {
            NMS.addOrRemoveFromPlayerList(npc.getEntity(), remove);
        }
        Messaging.sendTr(sender, remove ? "citizens.commands.npc.playerlist.removed" : "citizens.commands.npc.playerlist.added", npc.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pose (--save [name]|--assume [name]|--remove [name]) (-a)", desc="Changes/Saves/Lists NPC's head pose(s)", flags="a", modifiers={"pose"}, min=1, max=2, permission="citizens.npc.pose")
    public void pose(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Poses trait = npc.getTrait(Poses.class);
        if (args.hasValueFlag("save")) {
            if (args.getFlag("save").isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addPose(args.getFlag("save"), args.getSenderLocation())) throw new CommandException("citizens.commands.npc.pose.already-exists", args.getFlag("save"));
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (args.hasValueFlag("assume")) {
            String pose = args.getFlag("assume");
            if (pose.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.hasPose(pose)) {
                throw new CommandException("citizens.commands.npc.pose.missing", pose);
            }
            trait.assumePose(pose);
        } else if (args.hasValueFlag("remove")) {
            if (args.getFlag("remove").isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.removePose(args.getFlag("remove"))) throw new CommandException("citizens.commands.npc.pose.missing", args.getFlag("remove"));
            Messaging.sendTr(sender, "citizens.commands.npc.pose.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            trait.describe(sender, args.getInteger(1, 1));
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        Location location = args.getSenderLocation();
        trait.assumePose(location);
    }

    @Command(aliases={"npc"}, usage="power", desc="Toggle a creeper NPC as powered", modifiers={"power"}, min=1, max=1, permission="citizens.npc.power")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, npc.getTrait(Powered.class).toggle() ? "citizens.commands.npc.powered.set" : "citizens.commands.npc.powered.stopped", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="profession|prof [profession]", desc="Set a NPC's profession", modifiers={"profession", "prof"}, min=2, max=2, permission="citizens.npc.profession")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER})
    public void profession(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String profession = args.getString(1);
        Villager.Profession parsed = (Villager.Profession)Util.matchEnum((Enum[])Villager.Profession.values(), (String)profession.toUpperCase());
        if (parsed == null) {
            throw new CommandException("citizens.commands.npc.profession.invalid-profession", args.getString(1), StringUtils.join((Object[])Villager.Profession.values(), (String)","));
        }
        npc.getTrait(VillagerProfession.class).setProfession(parsed);
        Messaging.sendTr(sender, "citizens.commands.npc.profession.set", npc.getName(), profession);
    }

    @Command(aliases={"npc"}, usage="rabbittype [type]", desc="Set the Type of a Rabbit NPC", modifiers={"rabbittype", "rbtype"}, min=2, permission="citizens.npc.rabbittype")
    @Requirements(selected=true, ownership=true, types={EntityType.RABBIT})
    public void rabbitType(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        RabbitType.RabbitTypes type;
        try {
            type = RabbitType.RabbitTypes.valueOf(args.getString(1).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CommandException("citizens.commands.npc.rabbittype.invalid-type", StringUtils.join((Object[])RabbitType.RabbitTypes.values(), (String)","));
        }
        npc.getTrait(RabbitType.class).setType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.rabbittype.type-set", npc.getName(), type.name());
    }

    @Command(aliases={"npc"}, usage="remove|rem (all|id|name)", desc="Remove a NPC", modifiers={"remove", "rem"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        if (args.argsLength() == 2) {
            if (args.getString(1).equalsIgnoreCase("all")) {
                if (!sender.hasPermission("citizens.admin.remove.all") && !sender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                this.npcRegistry.deregisterAll();
                Messaging.sendTr(sender, "citizens.commands.npc.remove.removed-all", new Object[0]);
                return;
            }
            NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

                @Override
                public void run(NPC npc) throws CommandException {
                    if (npc == null) {
                        throw new CommandException("citizens.commands.requirements.must-have-selected");
                    }
                    if (!(sender instanceof ConsoleCommandSender) && !npc.getTrait(Owner.class).isOwnedBy(sender)) {
                        throw new CommandException("citizens.commands.requirements.must-be-owner");
                    }
                    if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
                        throw new NoPermissionsException();
                    }
                    npc.destroy();
                    Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName());
                }
            };
            NPCCommandSelector.startWithCallback(callback, this.npcRegistry, sender, args, args.getString(1));
            return;
        }
        if (npc == null) {
            throw new CommandException("citizens.commands.requirements.must-have-selected");
        }
        if (!(sender instanceof ConsoleCommandSender) && !npc.getTrait(Owner.class).isOwnedBy(sender)) {
            throw new CommandException("citizens.commands.requirements.must-be-owner");
        }
        if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        npc.destroy();
        Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName());
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="Rename a NPC", modifiers={"rename"}, min=2, permission="citizens.npc.rename")
    public void rename(CommandContext args, CommandSender sender, NPC npc) {
        int nameLength;
        String oldName = npc.getName();
        String newName = Colorizer.parseColors(args.getJoinedStrings(1));
        int n = nameLength = npc.getTrait(MobType.class).getType() == EntityType.PLAYER ? 16 : 64;
        if (newName.length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", new Object[0]);
            newName = newName.substring(0, nameLength);
        }
        Location prev = npc.isSpawned() ? npc.getEntity().getLocation() : null;
        npc.despawn(DespawnReason.PENDING_RESPAWN);
        npc.setName(newName);
        if (prev != null) {
            npc.spawn(prev);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.rename.renamed", oldName, newName);
    }

    @Command(aliases={"npc"}, usage="respawn [delay in ticks]", desc="Sets an NPC's respawn delay in ticks", modifiers={"respawn"}, min=1, max=2, permission="citizens.npc.respawn")
    public void respawn(CommandContext args, CommandSender sender, NPC npc) {
        if (args.argsLength() > 1) {
            int delay = args.getInteger(1);
            npc.data().setPersistent("respawn-delay", delay);
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.delay-set", delay);
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.describe", npc.data().get("respawn-delay", -1));
        }
    }

    @Command(aliases={"npc"}, usage="select|sel [id|name] (--r range)", desc="Select a NPC with the given ID or name", modifiers={"select", "sel"}, min=1, max=2, permission="citizens.npc.select")
    @Requirements
    public void select(CommandContext args, final CommandSender sender, final NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC toSelect) throws CommandException {
                if (toSelect == null || !toSelect.getTrait(Spawned.class).shouldSpawn()) {
                    throw new CommandException("citizens.notifications.npc-not-found");
                }
                if (npc != null && toSelect.getId() == npc.getId()) {
                    throw new CommandException("citizens.commands.npc.select.already-selected");
                }
                NPCCommands.this.selector.select(sender, toSelect);
                Messaging.sendWithNPC(sender, Settings.Setting.SELECTION_MESSAGE.asString(), toSelect);
            }
        };
        if (args.argsLength() <= 1) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            double range = Math.abs(args.getFlagDouble("r", 10.0));
            Player player = (Player)sender;
            final Location location = args.getSenderLocation();
            List search = player.getNearbyEntities(range, range, range);
            Collections.sort(search, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    double d = o1.getLocation().distanceSquared(location) - o2.getLocation().distanceSquared(location);
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
            });
            for (Entity possibleNPC : search) {
                NPC test = this.npcRegistry.getNPC(possibleNPC);
                if (test == null) continue;
                callback.run(test);
                break;
            }
        } else {
            NPCCommandSelector.startWithCallback(callback, this.npcRegistry, sender, args, args.getString(1));
        }
    }

    @Command(aliases={"npc"}, usage="sheep (--color [color]) (--sheared [sheared])", desc="Sets sheep modifiers", modifiers={"sheep"}, min=1, max=1, permission="citizens.npc.sheep")
    @Requirements(selected=true, ownership=true, types={EntityType.SHEEP})
    public void sheep(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        SheepTrait trait = npc.getTrait(SheepTrait.class);
        boolean hasArg = false;
        if (args.hasValueFlag("sheared")) {
            trait.setSheared(Boolean.valueOf(args.getFlag("sheared")));
            hasArg = true;
        }
        if (args.hasValueFlag("color")) {
            DyeColor color = (DyeColor)Util.matchEnum((Enum[])DyeColor.values(), (String)args.getFlag("color"));
            if (color != null) {
                trait.setColor(color);
                Messaging.sendTr(sender, "citizens.commands.npc.sheep.color-set", color.toString().toLowerCase());
            } else {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.sheep.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandException();
        }
    }

    @Command(aliases={"npc"}, usage="skeletontype [type]", desc="Sets the NPC's skeleton type", modifiers={"skeletontype", "sktype"}, min=2, max=2, permission="citizens.npc.skeletontype")
    @Requirements(selected=true, ownership=true, types={EntityType.SKELETON})
    public void skeletonType(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Skeleton.SkeletonType type;
        try {
            type = Skeleton.SkeletonType.valueOf((String)args.getString(1).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CommandException("citizens.commands.npc.skeletontype.invalid-type", StringUtils.join((Object[])Skeleton.SkeletonType.values(), (String)","));
        }
        npc.getTrait(NPCSkeletonType.class).setType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.skeletontype.set", npc.getName(), type);
    }

    @Command(aliases={"npc"}, usage="skin (-c -p) [name]", desc="Sets an NPC's skin name, Use -p to save a skin snapshot that won't change", modifiers={"skin"}, min=1, max=2, flags="cp", permission="citizens.npc.skin")
    @Requirements(types={EntityType.PLAYER}, selected=true, ownership=true)
    public void skin(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String skinName = npc.getName();
        if (args.hasFlag('c')) {
            npc.data().remove("player-skin-name");
        } else {
            if (args.argsLength() != 2) {
                throw new CommandException();
            }
            npc.data().setPersistent("player-skin-name", args.getString(1));
            if (args.hasFlag('p')) {
                npc.data().setPersistent("player-skin-textures", "cache");
            }
            skinName = args.getString(1);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.skin.set", npc.getName(), skinName);
        if (npc.isSpawned()) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
            npc.spawn(npc.getStoredLocation());
        }
    }

    @Command(aliases={"npc"}, usage="size [size]", desc="Sets the NPC's size", modifiers={"size"}, min=1, max=2, permission="citizens.npc.size")
    @Requirements(selected=true, ownership=true, types={EntityType.MAGMA_CUBE, EntityType.SLIME})
    public void slimeSize(CommandContext args, CommandSender sender, NPC npc) {
        SlimeSize trait = npc.getTrait(SlimeSize.class);
        if (args.argsLength() <= 1) {
            trait.describe(sender);
            return;
        }
        int size = Math.max(-2, args.getInteger(1));
        trait.setSize(size);
        Messaging.sendTr(sender, "citizens.commands.npc.size.set", npc.getName(), size);
    }

    @Command(aliases={"npc"}, usage="sound (--death [death sound|d]) (--ambient [ambient sound|d]) (--hurt [hurt sound|d]) (-n(one)) (-d(efault))", desc="Sets an NPC's played sounds", modifiers={"sound"}, flags="dn", min=1, max=1, permission="citizens.npc.sound")
    @Requirements(selected=true, ownership=true, livingEntity=true, excludedTypes={EntityType.PLAYER})
    public void sound(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String ambientSound = (String)npc.data().get("ambient-sound");
        String deathSound = (String)npc.data().get("death-sound");
        String hurtSound = (String)npc.data().get("hurt-sound");
        if (args.getValueFlags().size() == 0 && args.getFlags().size() == 0) {
            Messaging.sendTr(sender, "citizens.commands.npc.sound.info", npc.getName(), ambientSound, hurtSound, deathSound, Util.listValuesPretty(Sound.values()));
            return;
        }
        if (args.hasFlag('n')) {
            hurtSound = "";
            deathSound = "";
            ambientSound = "";
        }
        if (args.hasFlag('d')) {
            hurtSound = null;
            deathSound = null;
            ambientSound = null;
        } else {
            if (args.hasValueFlag("death")) {
                String string = deathSound = args.getFlag("death").equals("d") ? null : NMS.getSound(args.getFlag("death"));
            }
            if (args.hasValueFlag("ambient")) {
                String string = ambientSound = args.getFlag("ambient").equals("d") ? null : NMS.getSound(args.getFlag("ambient"));
            }
            if (args.hasValueFlag("hurt")) {
                String string = hurtSound = args.getFlag("hurt").equals("d") ? null : NMS.getSound(args.getFlag("hurt"));
            }
        }
        if (deathSound == null) {
            npc.data().remove("death-sound");
        } else {
            npc.data().setPersistent("death-sound", deathSound);
        }
        if (hurtSound == null) {
            npc.data().remove("hurt-sound");
        } else {
            npc.data().setPersistent("hurt-sound", hurtSound);
        }
        if (ambientSound == null) {
            npc.data().remove(ambientSound);
        } else {
            npc.data().setPersistent("ambient-sound", ambientSound);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.sound.set", npc.getName(), ambientSound, hurtSound, deathSound);
    }

    @Command(aliases={"npc"}, usage="spawn (id|name)", desc="Spawn an existing NPC", modifiers={"spawn"}, min=1, max=2, permission="citizens.npc.spawn")
    @Requirements(ownership=true)
    public void spawn(final CommandContext args, final CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = new NPCCommandSelector.Callback(){

            @Override
            public void run(NPC respawn) throws CommandException {
                if (respawn == null) {
                    if (args.argsLength() > 1) {
                        throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
                    }
                    throw new CommandException("citizens.commands.requirements.must-have-selected");
                }
                if (respawn.isSpawned()) {
                    throw new CommandException("citizens.commands.npc.spawn.already-spawned", respawn.getName());
                }
                Location location = respawn.getTrait(CurrentLocation.class).getLocation();
                if (location == null || args.hasValueFlag("location")) {
                    if (args.getSenderLocation() == null) {
                        throw new CommandException("citizens.commands.npc.spawn.no-location");
                    }
                    location = args.getSenderLocation();
                }
                if (respawn.spawn(location)) {
                    NPCCommands.this.selector.select(sender, respawn);
                    Messaging.sendTr(sender, "citizens.commands.npc.spawn.spawned", respawn.getName());
                }
            }
        };
        if (args.argsLength() > 1) {
            NPCCommandSelector.startWithCallback(callback, this.npcRegistry, sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="speak message to speak --target npcid|player_name --type vocal_type", desc="Uses the NPCs SpeechController to talk", modifiers={"speak"}, min=2, permission="citizens.npc.speak")
    public void speak(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String type = npc.getTrait(Speech.class).getDefaultVocalChord();
        String message = Colorizer.parseColors(args.getJoinedStrings(1));
        if (message.length() <= 0) {
            Messaging.send(sender, "Default Vocal Chord for " + npc.getName() + ": " + npc.getTrait(Speech.class).getDefaultVocalChord());
            return;
        }
        SpeechContext context = new SpeechContext(message);
        if (args.hasValueFlag("target")) {
            if (args.getFlag("target").matches("\\d+")) {
                NPC target = CitizensAPI.getNPCRegistry().getById(Integer.valueOf(args.getFlag("target")));
                if (target != null) {
                    context.addRecipient(target.getEntity());
                }
            } else {
                Player player = Bukkit.getPlayer((String)args.getFlag("target"));
                if (player != null) {
                    context.addRecipient((Entity)player);
                }
            }
        }
        if (args.hasValueFlag("type") && CitizensAPI.getSpeechFactory().isRegistered(args.getFlag("type"))) {
            type = args.getFlag("type");
        }
        npc.getDefaultSpeechController().speak(context, type);
    }

    @Command(aliases={"npc"}, usage="speed [speed]", desc="Sets the movement speed of an NPC as a percentage", modifiers={"speed"}, min=2, max=2, permission="citizens.npc.speed")
    public void speed(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        float newSpeed = (float)Math.abs(args.getDouble(1));
        if ((double)newSpeed >= Settings.Setting.MAX_SPEED.asDouble()) {
            throw new CommandException("citizens.commands.npc.speed.modifier-above-limit");
        }
        npc.getNavigator().getDefaultParameters().speedModifier(newSpeed);
        Messaging.sendTr(sender, "citizens.commands.npc.speed.set", Float.valueOf(newSpeed));
    }

    @Command(aliases={"npc"}, usage="swim (--set [true|false])", desc="Sets an NPC to swim or not", modifiers={"swim"}, min=1, max=1, permission="citizens.npc.swim")
    public void swim(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean swim = args.hasValueFlag("set") ? Boolean.parseBoolean(args.getFlag("set")) : npc.data().get("swim", true) == false;
        npc.data().setPersistent("swim", swim);
        Messaging.sendTr(sender, swim ? "citizens.commands.npc.swim.set" : "citizens.commands.npc.swim.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="targetable", desc="Toggles an NPC's targetability", modifiers={"targetable"}, min=1, max=1, permission="citizens.npc.targetable")
    public void targetable(CommandContext args, CommandSender sender, NPC npc) {
        boolean targetable;
        boolean bl = targetable = npc.data().get("protected-target", npc.data().get("protected", true)) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected-target", targetable);
        } else {
            npc.data().setPersistent("protected-target", targetable);
        }
        Messaging.sendTr(sender, targetable ? "citizens.commands.npc.targetable.set" : "citizens.commands.npc.targetable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tp", desc="Teleport to a NPC", modifiers={"tp", "teleport"}, min=1, max=1, permission="citizens.npc.tp")
    public void tp(CommandContext args, Player player, NPC npc) {
        Location to = npc.getTrait(CurrentLocation.class).getLocation();
        if (to == null) {
            Messaging.sendError((CommandSender)player, "citizens.commands.npc.tp.location-not-found");
            return;
        }
        player.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.tp.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tphere", desc="Teleport a NPC to your location", modifiers={"tphere", "tph", "move"}, min=1, max=1, permission="citizens.npc.tphere")
    public void tphere(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        if (!npc.isSpawned()) {
            npc.spawn(args.getSenderLocation());
            if (!sender.hasPermission("citizens.npc.tphere.multiworld") && npc.getEntity().getLocation().getWorld() != args.getSenderLocation().getWorld()) {
                npc.despawn(DespawnReason.REMOVAL);
                throw new CommandException("citizens.commands.npc.tphere.multiworld-not-allowed");
            }
        } else {
            if (!sender.hasPermission("citizens.npc.tphere.multiworld") && npc.getEntity().getLocation().getWorld() != args.getSenderLocation().getWorld()) {
                npc.despawn(DespawnReason.REMOVAL);
                throw new CommandException("citizens.commands.npc.tphere.multiworld-not-allowed");
            }
            npc.teleport(args.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.tphere.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tpto [player name|npc id] [player name|npc id]", desc="Teleport an NPC or player to another NPC or player", modifiers={"tpto"}, min=3, max=3, permission="citizens.npc.tpto")
    @Requirements
    public void tpto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Player to;
        Entity from;
        block9: {
            int id;
            from = null;
            to = null;
            if (npc != null) {
                from = npc.getEntity();
            }
            boolean firstWasPlayer = false;
            try {
                id = args.getInteger(1);
                NPC fromNPC = CitizensAPI.getNPCRegistry().getById(id);
                if (fromNPC != null) {
                    from = fromNPC.getEntity();
                }
            }
            catch (NumberFormatException e) {
                from = Bukkit.getPlayerExact((String)args.getString(1));
                firstWasPlayer = true;
            }
            try {
                id = args.getInteger(2);
                NPC toNPC = CitizensAPI.getNPCRegistry().getById(id);
                if (toNPC != null) {
                    to = toNPC.getEntity();
                }
            }
            catch (NumberFormatException e) {
                if (firstWasPlayer) break block9;
                to = Bukkit.getPlayerExact((String)args.getString(2));
            }
        }
        if (from == null) {
            throw new CommandException("citizens.commands.npc.tpto.from-not-found");
        }
        if (to == null) {
            throw new CommandException("citizens.commands.npc.tpto.to-not-found");
        }
        from.teleport((Entity)to);
        Messaging.sendTr(sender, "citizens.commands.npc.tpto.success", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="type [type]", desc="Sets an NPC's entity type", modifiers={"type"}, min=2, max=2, permission="citizens.npc.type")
    public void type(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        EntityType type = Util.matchEntityType(args.getString(1));
        if (type == null) {
            throw new CommandException("citizens.commands.npc.type.invalid", args.getString(1));
        }
        npc.setBukkitEntityType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.type.set", npc.getName(), args.getString(1));
    }

    @Command(aliases={"npc"}, usage="vulnerable (-t)", desc="Toggles an NPC's vulnerability", modifiers={"vulnerable"}, min=1, max=1, flags="t", permission="citizens.npc.vulnerable")
    public void vulnerable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = npc.data().get("protected", true) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected", vulnerable);
        } else {
            npc.data().setPersistent("protected", vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.vulnerable.stopped" : "citizens.commands.npc.vulnerable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="wolf (-s(itting) a(ngry) t(amed)) --collar [hex rgb color|name]", desc="Sets wolf modifiers", modifiers={"wolf"}, min=1, max=1, flags="sat", permission="citizens.npc.wolf")
    @Requirements(selected=true, ownership=true, types={EntityType.WOLF})
    public void wolf(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        WolfModifiers trait = npc.getTrait(WolfModifiers.class);
        trait.setAngry(args.hasFlag('a'));
        trait.setSitting(args.hasFlag('s'));
        trait.setTamed(args.hasFlag('t'));
        if (args.hasValueFlag("collar")) {
            String unparsed = args.getFlag("collar");
            DyeColor color = null;
            try {
                color = DyeColor.valueOf((String)unparsed.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException e) {
                try {
                    int rgb = Integer.parseInt(unparsed.replace("#", ""), 16);
                    color = DyeColor.getByColor((Color)Color.fromRGB((int)rgb));
                }
                catch (NumberFormatException ex) {
                    throw new CommandException("citizens.commands.npc.wolf.unknown-collar-color", unparsed);
                }
            }
            if (color == null) {
                throw new CommandException("citizens.commands.npc.wolf.collar-color-unsupported", unparsed);
            }
            trait.setCollarColor(color);
        }
        Messaging.sendTr(sender, "citizens.commands.wolf.traits-updated", npc.getName(), args.hasFlag('a'), args.hasFlag('s'), args.hasFlag('t'), trait.getCollarColor().name());
    }

    @Command(aliases={"npc"}, usage="zombiemod (-b(aby), -v(illager))", desc="Sets a zombie NPC to be a baby or villager", modifiers={"zombie", "zombiemod"}, flags="bv", min=1, max=1, permission="citizens.npc.zombiemodifier")
    @Requirements(selected=true, ownership=true, types={EntityType.ZOMBIE, EntityType.PIG_ZOMBIE})
    public void zombieModifier(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ZombieModifier trait = npc.getTrait(ZombieModifier.class);
        if (args.hasFlag('b')) {
            boolean isBaby = trait.toggleBaby();
            Messaging.sendTr(sender, isBaby ? "citizens.commands.npc.zombiemod.baby-set" : "citizens.commands.npc.zombiemod.baby-unset", npc.getName());
        }
        if (args.hasFlag('v')) {
            boolean isVillager = trait.toggleVillager();
            Messaging.sendTr(sender, isVillager ? "citizens.commands.npc.zombiemod.villager-set" : "citizens.commands.npc.zombiemod.villager-unset", npc.getName());
        }
    }
}

