/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class CitizensNPC
extends AbstractNPC {
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private static final String NPC_METADATA_MARKER = "NPC";

    public CitizensNPC(UUID uuid, int id, String name, EntityController entityController, NPCRegistry registry) {
        super(uuid, id, name, registry);
        Preconditions.checkNotNull((Object)entityController);
        this.entityController = entityController;
    }

    @Override
    public boolean despawn(DespawnReason reason) {
        if (!this.isSpawned()) {
            Messaging.debug("Tried to despawn", this.getId(), "while already despawned.");
            if (reason == DespawnReason.REMOVAL) {
                Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this, reason));
            }
            return false;
        }
        NPCDespawnEvent event = new NPCDespawnEvent(this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean());
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.getEntity().getLocation().getChunk();
            Messaging.debug("Couldn't despawn", this.getId(), "due to despawn event cancellation. Force loaded chunk.");
            return false;
        }
        boolean keepSelected = this.getTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        for (Trait trait : this.traits.values()) {
            trait.onDespawn();
        }
        this.navigator.onDespawn();
        this.entityController.remove();
        return true;
    }

    @Override
    public void faceLocation(Location location) {
        if (!this.isSpawned()) {
            return;
        }
        Util.faceLocation(this.getEntity(), location);
    }

    @Override
    public org.bukkit.entity.Entity getEntity() {
        return this.entityController == null ? null : this.entityController.getBukkitEntity();
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Location getStoredLocation() {
        return this.isSpawned() ? this.getEntity().getLocation() : this.getTrait(CurrentLocation.class).getLocation();
    }

    @Override
    public boolean isFlyable() {
        this.updateFlyableState();
        return super.isFlyable();
    }

    @Override
    public void load(DataKey root) {
        super.load(root);
        CurrentLocation spawnLocation = this.getTrait(CurrentLocation.class);
        if (this.getTrait(Spawned.class).shouldSpawn() && spawnLocation.getLocation() != null) {
            this.spawn(spawnLocation.getLocation());
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    @Override
    public void save(DataKey root) {
        super.save(root);
        if (!this.data().get("should-save", true).booleanValue()) {
            return;
        }
        this.navigator.save(root.getRelative("navigator"));
    }

    @Override
    public void setBukkitEntityType(EntityType type) {
        EntityController controller = EntityControllers.createForType(type);
        if (controller == null) {
            throw new IllegalArgumentException("Unsupported entity type " + type);
        }
        this.setEntityController(controller);
    }

    public void setEntityController(EntityController newController) {
        Preconditions.checkNotNull((Object)newController);
        boolean wasSpawned = this.isSpawned();
        Location prev = null;
        if (wasSpawned) {
            prev = this.getEntity().getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
        }
        this.entityController = newController;
        if (wasSpawned) {
            this.spawn(prev);
        }
    }

    @Override
    public void setFlyable(boolean flyable) {
        super.setFlyable(flyable);
        this.updateFlyableState();
    }

    @Override
    public boolean spawn(Location at) {
        Preconditions.checkNotNull((Object)at, (Object)"location cannot be null");
        if (this.isSpawned()) {
            Messaging.debug("Tried to spawn", this.getId(), "while already spawned.");
            return false;
        }
        this.data().get("protected", true);
        at = at.clone();
        this.getTrait(CurrentLocation.class).setLocation(at);
        this.entityController.spawn(at, this);
        Entity mcEntity = ((CraftEntity)this.getEntity()).getHandle();
        boolean couldSpawn = !Util.isLoaded(at) ? false : mcEntity.world.addEntity(mcEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        mcEntity.setPositionRotation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        if (!couldSpawn) {
            Messaging.debug("Retrying spawn of", this.getId(), "later due to chunk being unloaded.", Util.isLoaded(at) ? "Util.isLoaded true" : "Util.isLoaded false");
            this.entityController.remove();
            Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent(this, at));
            return false;
        }
        NMS.setHeadYaw(mcEntity, at.getYaw());
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, at);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            this.entityController.remove();
            Messaging.debug("Couldn't spawn", this.getId(), "due to event cancellation.");
            return false;
        }
        this.getEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        this.getTrait(CurrentLocation.class).setLocation(at);
        this.getTrait(Spawned.class).setSpawned(true);
        this.navigator.onSpawn();
        Collection onSpawn = this.traits.values();
        for (Trait trait : onSpawn.toArray(new Trait[onSpawn.size()])) {
            try {
                trait.onSpawn();
            }
            catch (Throwable ex) {
                Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), this.getId());
                ex.printStackTrace();
            }
        }
        if (this.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)this.getEntity();
            entity.setRemoveWhenFarAway(false);
            entity.setCustomName(this.getFullName());
            if (NMS.getStepHeight(entity) < 1.0f) {
                NMS.setStepHeight(NMS.getHandle(entity), 1.0f);
            }
            if (this.getEntity() instanceof Player) {
                final CraftPlayer player = (CraftPlayer)this.getEntity();
                NMS.replaceTrackerEntry((Player)player);
                new BukkitRunnable(){

                    public void run() {
                        NMS.sendPacketsNearby((Player)player, player.getLocation(), Arrays.asList(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{player.getHandle()})), 200.0);
                        new BukkitRunnable(){

                            public void run() {
                                NMS.sendPacketsNearby((Player)player, player.getLocation(), Arrays.asList(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{player.getHandle()})), 200.0);
                            }
                        }.runTaskLater(CitizensAPI.getPlugin(), 2L);
                    }
                }.runTaskLater(CitizensAPI.getPlugin(), 2L);
            }
        }
        return true;
    }

    @Override
    public void update() {
        try {
            super.update();
            if (!this.isSpawned()) {
                return;
            }
            if (this.data().get("swim", true).booleanValue()) {
                NMS.trySwim(this.getEntity());
            }
            this.navigator.run();
            if (!this.getNavigator().isNavigating() && this.getEntity().getWorld().getFullTime() % (long)Settings.Setting.PACKET_UPDATE_DELAY.asInt() == 0L) {
                if (this.getEntity() instanceof LivingEntity) {
                    ((LivingEntity)this.getEntity()).setCustomName(this.getFullName());
                }
                Player player = this.getEntity() instanceof Player ? (Player)this.getEntity() : null;
                NMS.sendPacketNearby(player, this.getStoredLocation(), (Packet)new PacketPlayOutEntityTeleport(NMS.getHandle(this.getEntity())));
            }
            if (this.getEntity() instanceof LivingEntity) {
                boolean nameplateVisible = this.data().get("nameplate-visible", true);
                ((LivingEntity)this.getEntity()).setCustomNameVisible(nameplateVisible);
                Byte toByte = (byte)(nameplateVisible ? 1 : 0);
                try {
                    ((CraftLivingEntity)this.getEntity()).getHandle().getDataWatcher().watch(3, (Object)toByte);
                }
                catch (NullPointerException e) {
                    ((CraftLivingEntity)this.getEntity()).getHandle().getDataWatcher().a(3, (Object)toByte);
                }
            }
        }
        catch (Exception ex) {
            Throwable error = Throwables.getRootCause((Throwable)ex);
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), error.getMessage());
            error.printStackTrace();
        }
    }

    private void updateFlyableState() {
        EntityType type = this.getTrait(MobType.class).getType();
        if (type == null) {
            return;
        }
        if (Util.isAlwaysFlyable(type)) {
            this.data().setPersistent("flyable", true);
        }
    }
}

