/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.MathHelper;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class FlyingAStarNavigationStrategy
extends AbstractPathStrategy {
    private final NPC npc;
    private final NavigatorParameters parameters;
    private Path plan;
    private final Location target;
    private Vector vector;
    private static final AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();
    private static final Location NPC_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public FlyingAStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.target = dest;
        this.parameters = params;
        this.npc = npc;
        Location location = Util.getEyeLocation(npc.getEntity());
        VectorGoal goal = new VectorGoal(dest, (float)params.pathDistanceMargin());
        boolean found = false;
        for (BlockExaminer examiner : params.examiners()) {
            if (!(examiner instanceof FlyingBlockExaminer)) continue;
            found = true;
            break;
        }
        if (!found) {
            params.examiner(new FlyingBlockExaminer());
        }
        this.plan = ASTAR.runFully(goal, new VectorNode(goal, location, (BlockSource)new ChunkBlockSource(location, params.range()), params.examiners()), 50000);
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
            if (Settings.Setting.DEBUG_PATHFINDING.asBoolean()) {
                this.plan.debug();
            }
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    @Override
    public void stop() {
        if (this.plan != null && Settings.Setting.DEBUG_PATHFINDING.asBoolean()) {
            this.plan.debugEnd();
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        Location current = this.npc.getEntity().getLocation(NPC_LOCATION);
        if (current.toVector().distanceSquared(this.vector) <= this.parameters.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
        }
        double d0 = this.vector.getX() + 0.5 - current.getX();
        double d1 = this.vector.getY() + 0.1 - current.getY();
        double d2 = this.vector.getZ() + 0.5 - current.getZ();
        Vector velocity = this.npc.getEntity().getVelocity();
        double motX = velocity.getX();
        double motY = velocity.getY();
        double motZ = velocity.getZ();
        motX += (Math.signum(d0) * 0.5 - motX) * 0.1;
        motY += (Math.signum(d1) * 0.7 - motY) * 0.1;
        motZ += (Math.signum(d2) * 0.5 - motZ) * 0.1;
        float targetYaw = (float)(Math.atan2(motZ, motX) * 180.0 / Math.PI) - 90.0f;
        float normalisedTargetYaw = MathHelper.g((float)(targetYaw - current.getYaw()));
        velocity.setX(motX).setY(motY).setZ(motZ).multiply(this.parameters.speed());
        this.npc.getEntity().setVelocity(velocity);
        NMS.setVerticalMovement(this.npc.getEntity(), 0.5);
        if (this.npc.getEntity().getType() != EntityType.ENDER_DRAGON) {
            NMS.setHeadYaw(NMS.getHandle(this.npc.getEntity()), current.getYaw() + normalisedTargetYaw);
        }
        this.parameters.run();
        this.plan.run(this.npc);
        return false;
    }
}

