/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;

public class MCNavigationStrategy
extends AbstractPathStrategy {
    private final NavigationAbstract navigation;
    private final NavigatorParameters parameters;
    private final Location target;
    private final EntityLiving handle;
    private static final Location HANDLE_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    MCNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.target = dest;
        this.parameters = params;
        this.handle = ((CraftLivingEntity)npc.getEntity()).getHandle();
        this.handle.onGround = true;
        this.navigation = NMS.getNavigation((Entity)this.handle);
        this.navigation.a(dest.getX(), dest.getY(), dest.getZ(), (double)this.parameters.speed());
        if (NMS.isNavigationFinished(this.navigation)) {
            this.setCancelReason(CancelReason.STUCK);
        }
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.LOCATION;
    }

    @Override
    public void stop() {
        NMS.stopNavigation(this.navigation);
    }

    public String toString() {
        return "MCNavigationStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null) {
            return true;
        }
        this.navigation.a(this.parameters.speed());
        this.parameters.run();
        if (this.distanceSquared() < this.parameters.distanceMargin()) {
            this.stop();
            return true;
        }
        return NMS.isNavigationFinished(this.navigation);
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation(HANDLE_LOCATION).distanceSquared(this.target);
    }
}

