/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCTargetStrategy
implements PathStrategy,
EntityTarget {
    private final boolean aggro;
    private int attackTicks;
    private CancelReason cancelReason;
    private final net.minecraft.server.v1_8_R3.Entity handle;
    private final NPC npc;
    private final NavigatorParameters parameters;
    private final net.minecraft.server.v1_8_R3.Entity target;
    private final TargetNavigator targetNavigator;
    private static final int ATTACK_DELAY_TICKS = 20;
    static final AttackStrategy DEFAULT_ATTACK_STRATEGY = new AttackStrategy(){

        @Override
        public boolean handle(LivingEntity attacker, LivingEntity bukkitTarget) {
            EntityLiving handle = NMS.getHandle(attacker);
            EntityLiving target = NMS.getHandle(bukkitTarget);
            if (handle instanceof EntityPlayer) {
                EntityPlayer humanHandle = (EntityPlayer)handle;
                humanHandle.attack((net.minecraft.server.v1_8_R3.Entity)target);
                PlayerAnimation.ARM_SWING.play((Player)humanHandle.getBukkitEntity());
            } else {
                NMS.attack(handle, (net.minecraft.server.v1_8_R3.Entity)target);
            }
            return false;
        }
    };
    private static final Location HANDLE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static final Location TARGET_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public MCTargetStrategy(NPC npc, Entity target, boolean aggro, NavigatorParameters params) {
        this.npc = npc;
        this.parameters = params;
        this.handle = ((CraftEntity)npc.getEntity()).getHandle();
        this.target = ((CraftEntity)target).getHandle();
        NavigationAbstract nav = NMS.getNavigation(this.handle);
        this.targetNavigator = nav != null && !params.useNewPathfinder() ? new NavigationFieldWrapper(nav) : new AStarTargeter();
        this.aggro = aggro;
    }

    private boolean canAttack() {
        return this.attackTicks == 0 && this.handle.getBoundingBox().e > this.target.getBoundingBox().b && this.handle.getBoundingBox().b < this.target.getBoundingBox().e && this.closeEnough(this.distanceSquared()) && this.hasLineOfSight();
    }

    @Override
    public void clearCancelReason() {
        this.cancelReason = null;
    }

    private boolean closeEnough(double distance) {
        return distance <= this.parameters.attackRange();
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation(HANDLE_LOCATION).distanceSquared(this.target.getBukkitEntity().getLocation(TARGET_LOCATION));
    }

    @Override
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public LivingEntity getTarget() {
        return (LivingEntity)this.target.getBukkitEntity();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.getTarget().getLocation();
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.ENTITY;
    }

    private boolean hasLineOfSight() {
        return ((LivingEntity)this.handle.getBukkitEntity()).hasLineOfSight((Entity)this.target.getBukkitEntity());
    }

    @Override
    public boolean isAggressive() {
        return this.aggro;
    }

    private void setPath() {
        this.targetNavigator.setPath();
    }

    @Override
    public void stop() {
        this.targetNavigator.stop();
    }

    public String toString() {
        return "MCTargetStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.target == null || !this.target.getBukkitEntity().isValid()) {
            this.cancelReason = CancelReason.TARGET_DIED;
            return true;
        }
        if (this.target.world != this.handle.world) {
            this.cancelReason = CancelReason.TARGET_MOVED_WORLD;
            return true;
        }
        if (this.cancelReason != null) {
            return true;
        }
        if (!this.aggro && this.distanceSquared() < this.parameters.distanceMargin()) {
            this.stop();
        } else if (this.target.world.getWorld().getFullTime() % 10L == 0L) {
            this.setPath();
        }
        NMS.look(this.handle, this.target);
        if (this.aggro && this.canAttack()) {
            AttackStrategy strategy = this.parameters.attackStrategy();
            if (!(strategy != null && strategy.handle((LivingEntity)this.handle.getBukkitEntity(), this.getTarget()) || strategy == this.parameters.defaultAttackStrategy())) {
                this.parameters.defaultAttackStrategy().handle((LivingEntity)this.handle.getBukkitEntity(), this.getTarget());
            }
            this.attackTicks = 20;
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        return false;
    }

    private static interface TargetNavigator {
        public void setPath();

        public void stop();
    }

    private class NavigationFieldWrapper
    implements TargetNavigator {
        private final NavigationAbstract navigation;

        private NavigationFieldWrapper(NavigationAbstract navigation) {
            this.navigation = navigation;
        }

        @Override
        public void setPath() {
            this.navigation.a(MCTargetStrategy.this.target, (double)MCTargetStrategy.this.parameters.speed());
        }

        @Override
        public void stop() {
            NMS.stopNavigation(this.navigation);
        }
    }

    private class AStarTargeter
    implements TargetNavigator {
        private int failureTimes = 0;
        private PathStrategy strategy;

        public AStarTargeter() {
            this.setStrategy();
        }

        @Override
        public void setPath() {
            this.setStrategy();
            this.strategy.update();
            CancelReason subReason = this.strategy.getCancelReason();
            if (subReason == CancelReason.STUCK) {
                if (this.failureTimes++ > 10) {
                    MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
                }
            } else {
                this.failureTimes = 0;
                MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
            }
        }

        private void setStrategy() {
            Location location = MCTargetStrategy.this.target.getBukkitEntity().getLocation(TARGET_LOCATION);
            this.strategy = MCTargetStrategy.this.npc.isFlyable() ? new FlyingAStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters) : new AStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters);
        }

        @Override
        public void stop() {
            this.strategy.stop();
        }
    }
}

