/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityEnderman;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class EndermanController
extends MobEntityController {
    public EndermanController() {
        super(EntityEndermanNPC.class);
    }

    public Enderman getBukkitEntity() {
        return (Enderman)super.getBukkitEntity();
    }

    public static class EntityEndermanNPC
    extends EntityEnderman
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEndermanNPC(World world) {
            this(world, null);
        }

        public EntityEndermanNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected void a(double d0, boolean flag, Block block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        protected String bo() {
            return this.npc == null ? super.bo() : this.npc.data().get("hurt-sound", super.bo());
        }

        protected String bp() {
            return this.npc == null ? super.bp() : this.npc.data().get("death-sound", super.bp());
        }

        public boolean cc() {
            if (this.npc == null) {
                return super.cc();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.cc();
            }
            if (super.cc()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            }
        }

        public void E() {
            super.E();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(f, f1);
            } else {
                NMS.flyingMoveLogic((EntityLiving)this, f, f1);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new EndermanNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected boolean k(double d1, double d2, double d3) {
            if (this.npc == null) {
                return super.j(d1, d2, d3);
            }
            return false;
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        protected String z() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.z() : this.npc.data().get("ambient-sound", super.z());
        }
    }

    public static class EndermanNPC
    extends CraftEnderman
    implements NPCHolder {
        private final CitizensNPC npc;

        public EndermanNPC(EntityEndermanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderman)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

