/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.network.EmptyNetHandler;
import net.citizensnpcs.npc.network.EmptyNetworkManager;
import net.citizensnpcs.npc.network.EmptySocket;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.citizensnpcs.util.nms.PlayerControllerJump;
import net.citizensnpcs.util.nms.PlayerControllerLook;
import net.citizensnpcs.util.nms.PlayerControllerMove;
import net.citizensnpcs.util.nms.PlayerNavigation;
import net.minecraft.server.v1_8_R3.AttributeInstance;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EnumProtocolDirection;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketListener;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.WorldServer;
import net.minecraft.server.v1_8_R3.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder {
    private PlayerControllerJump controllerJump;
    private PlayerControllerLook controllerLook;
    private PlayerControllerMove controllerMove;
    private boolean gravity = true;
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private static final float EPSILON = 0.005f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            playerInteractManager.setGameMode(WorldSettings.EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        }
    }

    protected void a(double d0, boolean flag, Block block, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, block, blockposition);
        }
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.velocityChanged) {
            this.velocityChanged = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    EntityHumanNPC.this.velocityChanged = true;
                }
            });
        }
        return damaged;
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                EntityHumanNPC.this.world.removeEntity((Entity)EntityHumanNPC.this);
            }
        }, 35L);
    }

    public void e(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(f, f1);
        }
    }

    public void g(double x, double y, double z) {
        if (this.npc == null) {
            super.g(x, y, z);
            return;
        }
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            if (!this.npc.data().get("protected", true).booleanValue()) {
                super.g(x, y, z);
            }
            return;
        }
        Vector vector = new Vector(x, y, z);
        NPCPushEvent event = Util.callPushEvent(this.npc, vector);
        if (!event.isCancelled()) {
            vector = event.getCollisionVector();
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void g(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.g(f, f1);
        } else {
            NMS.flyingMoveLogic((EntityLiving)this, f, f1);
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && this.bukkitEntity == null) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.a((PacketListener)this.playerConnection);
            socket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        AttributeInstance range = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (range == null) {
            range = this.getAttributeMap().b(GenericAttributes.FOLLOW_RANGE);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerLook = new PlayerControllerLook(this);
        this.controllerMove = new PlayerControllerMove(this);
        this.navigation = new PlayerNavigation(this, this.world);
        NMS.setStepHeight((EntityLiving)this, 1.0f);
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean k_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.k_();
        }
        return false;
    }

    private void moveOnCurrentHeading() {
        NMS.updateAI((EntityLiving)this);
        if (this.aY) {
            if (this.onGround && this.jumpTicks == 0) {
                this.bF();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.aZ *= 0.98f;
        this.ba *= 0.98f;
        this.bb *= 0.9f;
        this.g(this.aZ, this.ba);
        NMS.setHeadYaw((Entity)this, this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.a();
    }

    public void setTargetLook(Entity target, float yawOffset, float renderOffset) {
        this.controllerLook.a(target, yawOffset, renderOffset);
    }

    public void t_() {
        super.t_();
        if (this.npc == null) {
            return;
        }
        boolean navigating = this.npc.getNavigator().isNavigating();
        this.updatePackets(navigating);
        if (this.gravity && !navigating && this.getBukkitEntity() != null && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && !NMS.inWater((org.bukkit.entity.Entity)this.getBukkitEntity())) {
            this.move(0.0, -0.2, 0.0);
        }
        if (Math.abs(this.motX) < (double)0.005f && Math.abs(this.motY) < (double)0.005f && Math.abs(this.motZ) < (double)0.005f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        if (navigating) {
            if (!NMS.isNavigationFinished(this.navigation)) {
                NMS.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        } else if (this.motX != 0.0 || this.motZ != 0.0 || this.motY != 0.0) {
            this.g(0.0f, 0.0f);
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    public void updateAI() {
        this.controllerMove.c();
        this.controllerLook.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.world.getWorld().getFullTime() % (long)Settings.Setting.PACKET_UPDATE_DELAY.asInt() == 0L) {
            try {
                this.datawatcher.watch(10, (Object)127);
            }
            catch (NullPointerException e) {
                this.datawatcher.a(10, (Object)127);
            }
            Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
            Packet[] packets = new Packet[navigating ? 5 : 6];
            if (!navigating) {
                packets[5] = new PacketPlayOutEntityHeadRotation((Entity)this, (byte)MathHelper.d((float)(NMS.getHeadYaw((EntityLiving)this) * 256.0f / 360.0f)));
            }
            for (int i = 0; i < 5; ++i) {
                packets[i] = new PacketPlayOutEntityEquipment(this.getId(), i, this.getEquipment(i));
            }
            boolean removeFromPlayerList = this.npc.data().get("removefromplayerlist", Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean());
            NMS.addOrRemoveFromPlayerList((org.bukkit.entity.Entity)this.getBukkitEntity(), removeFromPlayerList);
            NMS.sendPlayerlistPacket(false, (Player)this.getBukkitEntity());
            NMS.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
        }
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getTrait(Inventory.class);
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setGravityEnabled(boolean enabled) {
            this.getHandle().gravity = enabled;
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

