/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityHorse;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.util.Vector;

public class HorseController
extends MobEntityController {
    public HorseController() {
        super(EntityHorseNPC.class);
    }

    public Horse getBukkitEntity() {
        return (Horse)super.getBukkitEntity();
    }

    @Override
    public void spawn(Location at, NPC npc) {
        npc.getTrait(HorseModifiers.class);
        super.spawn(at, npc);
    }

    public static class HorseNPC
    extends CraftHorse
    implements NPCHolder {
        private final CitizensNPC npc;

        public HorseNPC(EntityHorseNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityHorse)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityHorseNPC
    extends EntityHorse
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityHorseNPC(World world) {
            this(world, null);
        }

        public EntityHorseNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
                ((Horse)this.getBukkitEntity()).setDomestication(((Horse)this.getBukkitEntity()).getMaxDomestication());
            }
        }

        public void a(boolean flag) {
            float oldw = this.width;
            float oldl = this.length;
            super.a(flag);
            if (oldw != this.width || oldl != this.length) {
                this.setPosition(this.locX - 0.01, this.locY, this.locZ - 0.01);
                this.setPosition(this.locX + 0.01, this.locY, this.locZ + 0.01);
            }
        }

        protected void a(double d0, boolean flag, Block block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        protected String bo() {
            return this.npc == null ? super.bo() : this.npc.data().get("hurt-sound", super.bo());
        }

        protected String bp() {
            return this.npc == null ? super.bp() : this.npc.data().get("death-sound", super.bp());
        }

        public boolean cc() {
            if (this.npc == null) {
                return super.cc();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.cc();
            }
            if (super.cc()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            }
        }

        public void E() {
            if (this.npc == null) {
                super.E();
            } else {
                NMS.setStepHeight((EntityLiving)this, 1.0f);
                this.npc.update();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(f, f1);
            } else {
                NMS.flyingMoveLogic((EntityLiving)this, f, f1);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new HorseNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        protected String z() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.z() : this.npc.data().get("ambient-sound", super.z());
        }
    }
}

