/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.regex.Pattern;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class HumanController
extends AbstractEntityController {
    private static final String CACHED_SKIN_UUID_METADATA = "cached-skin-uuid";
    private static final String CACHED_SKIN_UUID_NAME_METADATA = "cached-skin-uuid-name";
    private static Method MAKE_REQUEST;
    private static Pattern NON_ALPHABET_MATCHER;
    private static final String PLAYER_SKIN_TEXTURE_PROPERTIES = "player-skin-textures";
    private static final String PLAYER_SKIN_TEXTURE_PROPERTIES_SIGN = "player-skin-signature";
    private static SkinThread SKIN_THREAD;
    private static final Map<String, Property> TEXTURE_CACHE;
    private static final Map<String, String> UUID_CACHE;

    public HumanController() {
        if (SKIN_THREAD == null) {
            SKIN_THREAD = new SkinThread();
            Bukkit.getScheduler().runTaskTimerAsynchronously(CitizensAPI.getPlugin(), (Runnable)SKIN_THREAD, 10L, 10L);
        }
    }

    @Override
    protected Entity createEntity(Location at, final NPC npc) {
        WorldServer nmsWorld = ((CraftWorld)at.getWorld()).getHandle();
        String coloredName = Colorizer.parseColors(npc.getFullName());
        if (coloredName.length() > 16) {
            coloredName = coloredName.substring(0, 16);
        }
        String prefix = null;
        String suffix = null;
        if (coloredName.length() > 16) {
            prefix = coloredName.substring(0, 16);
            if (coloredName.length() > 30) {
                int len = 30;
                String name = coloredName.substring(16, 30);
                if (NON_ALPHABET_MATCHER.matcher(name).matches()) {
                    if (coloredName.length() >= 32) {
                        len = 32;
                        name = coloredName.substring(16, 32);
                    } else if (coloredName.length() == 31) {
                        len = 31;
                        name = coloredName.substring(16, 31);
                    }
                } else {
                    name = ChatColor.RESET + name;
                }
                suffix = coloredName.substring(len);
            } else {
                String name = coloredName.substring(16);
                if (!NON_ALPHABET_MATCHER.matcher(name).matches()) {
                    name = ChatColor.RESET + name;
                }
                if (name.length() > 16) {
                    suffix = name.substring(16);
                    name = name.substring(0, 16);
                }
            }
        }
        final String prefixCapture = prefix;
        final String suffixCapture = suffix;
        String coloredNameCapture = coloredName;
        UUID uuid = npc.getUniqueId();
        if (uuid.version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        GameProfile profile = new GameProfile(uuid, coloredName);
        this.updateSkin(npc, nmsWorld, profile);
        final EntityHumanNPC handle = new EntityHumanNPC(nmsWorld.getServer().getServer(), nmsWorld, profile, new PlayerInteractManager((World)nmsWorld), npc);
        handle.setPositionRotation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (HumanController.this.getBukkitEntity() == null || !HumanController.this.getBukkitEntity().isValid()) {
                    return;
                }
                boolean removeFromPlayerList = Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean();
                NMS.addOrRemoveFromPlayerList((Entity)HumanController.this.getBukkitEntity(), npc.data().get("removefromplayerlist", removeFromPlayerList));
                if (prefixCapture != null) {
                    String teamName;
                    Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                    Team team = scoreboard.getTeam(teamName = UUID.randomUUID().toString().substring(0, 16));
                    if (team == null) {
                        team = scoreboard.registerNewTeam(teamName);
                        team.setPrefix(prefixCapture);
                        if (suffixCapture != null) {
                            team.setSuffix(suffixCapture);
                        }
                    }
                    team.addPlayer((OfflinePlayer)handle.getBukkitEntity());
                    handle.getNPC().data().set("fake-scoreboard-team-name", teamName);
                }
            }
        }, 1L);
        handle.getBukkitEntity().setSleepingIgnored(true);
        return handle.getBukkitEntity();
    }

    public Player getBukkitEntity() {
        return (Player)super.getBukkitEntity();
    }

    @Override
    public void remove() {
        NMS.sendPlayerlistPacket(false, this.getBukkitEntity());
        super.remove();
    }

    private void updateSkin(NPC npc, WorldServer nmsWorld, GameProfile profile) {
        String skinUUID = (String)npc.data().get("player-skin-name");
        if (skinUUID == null) {
            skinUUID = npc.getName();
        }
        if (npc.data().has(CACHED_SKIN_UUID_METADATA) && npc.data().has(CACHED_SKIN_UUID_NAME_METADATA) && ChatColor.stripColor((String)skinUUID).equalsIgnoreCase(ChatColor.stripColor((String)((String)npc.data().get(CACHED_SKIN_UUID_NAME_METADATA))))) {
            skinUUID = (String)npc.data().get(CACHED_SKIN_UUID_METADATA);
        }
        if (npc.data().has(PLAYER_SKIN_TEXTURE_PROPERTIES) && ((String)npc.data().get(PLAYER_SKIN_TEXTURE_PROPERTIES)).equals("cache")) {
            SKIN_THREAD.addRunnable(new SkinFetcher(new UUIDFetcher(skinUUID, npc), nmsWorld.getMinecraftServer().aD(), npc));
            return;
        }
        Property cached = TEXTURE_CACHE.get(skinUUID);
        if (npc.data().has(PLAYER_SKIN_TEXTURE_PROPERTIES) && npc.data().has(PLAYER_SKIN_TEXTURE_PROPERTIES_SIGN)) {
            cached = new Property("textures", (String)npc.data().get(PLAYER_SKIN_TEXTURE_PROPERTIES), (String)npc.data().get(PLAYER_SKIN_TEXTURE_PROPERTIES_SIGN));
        }
        if (cached != null) {
            profile.getProperties().put((Object)"textures", (Object)cached);
        } else {
            SKIN_THREAD.addRunnable(new SkinFetcher(new UUIDFetcher(skinUUID, npc), nmsWorld.getMinecraftServer().aD(), npc));
        }
    }

    static {
        NON_ALPHABET_MATCHER = Pattern.compile(".*[^A-Za-z0-9_].*");
        TEXTURE_CACHE = Maps.newConcurrentMap();
        UUID_CACHE = Maps.newConcurrentMap();
        try {
            MAKE_REQUEST = YggdrasilAuthenticationService.class.getDeclaredMethod("makeRequest", URL.class, Object.class, Class.class);
            MAKE_REQUEST.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class UUIDFetcher
    implements Callable<String> {
        private final NPC npc;
        private String reportedUUID;

        public UUIDFetcher(String reportedUUID, NPC npc) {
            this.reportedUUID = reportedUUID;
            this.npc = npc;
        }

        @Override
        public String call() throws Exception {
            String skinUUID = (String)UUID_CACHE.get(this.reportedUUID);
            if (skinUUID != null) {
                this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_METADATA, skinUUID);
                this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_NAME_METADATA, this.reportedUUID);
                this.reportedUUID = skinUUID;
            }
            if (this.reportedUUID.contains("-")) {
                return this.reportedUUID;
            }
            GameProfileRepository repo = ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
            repo.findProfilesByNames(new String[]{ChatColor.stripColor((String)this.reportedUUID)}, Agent.MINECRAFT, new ProfileLookupCallback(){

                public void onProfileLookupFailed(GameProfile arg0, Exception arg1) {
                }

                public void onProfileLookupSucceeded(GameProfile profile) {
                    UUID_CACHE.put(UUIDFetcher.this.reportedUUID, profile.getId().toString());
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Fetched UUID " + profile.getId() + " for NPC " + UUIDFetcher.this.npc.getName() + " UUID " + UUIDFetcher.this.npc.getUniqueId());
                    }
                    UUIDFetcher.this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_METADATA, profile.getId().toString());
                    UUIDFetcher.this.npc.data().setPersistent(HumanController.CACHED_SKIN_UUID_NAME_METADATA, profile.getName());
                }
            });
            return this.npc.data().get(HumanController.CACHED_SKIN_UUID_METADATA, this.reportedUUID);
        }
    }

    public static class SkinThread
    implements Runnable {
        private volatile int delay = 0;
        private volatile int retryTimes = 0;
        private final BlockingDeque<Runnable> tasks = new LinkedBlockingDeque<Runnable>();

        public void addRunnable(Runnable r) {
            Iterator<Runnable> itr = this.tasks.iterator();
            while (itr.hasNext()) {
                if (!((SkinFetcher)itr.next()).npc.getUniqueId().equals(((SkinFetcher)r).npc.getUniqueId())) continue;
                itr.remove();
            }
            this.tasks.offer(r);
        }

        public void delay() {
            this.delay = Settings.Setting.NPC_SKIN_RETRY_DELAY.asInt();
            ++this.retryTimes;
            if (Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt() >= 0 && this.retryTimes > Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt()) {
                this.tasks.clear();
                this.retryTimes = 0;
            }
        }

        @Override
        public void run() {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            Runnable r = (Runnable)this.tasks.pollFirst();
            if (r == null) {
                return;
            }
            r.run();
        }
    }

    private static class SkinFetcher
    implements Runnable {
        private final NPC npc;
        private final MinecraftSessionService repo;
        private final Callable<String> uuid;

        public SkinFetcher(Callable<String> uuid, MinecraftSessionService repo, NPC npc) {
            this.uuid = uuid;
            this.repo = repo;
            this.npc = npc;
        }

        private GameProfile fillProfileProperties(YggdrasilAuthenticationService auth, GameProfile profile, boolean requireSecure) throws Exception {
            URL url = HttpAuthenticationService.constantURL((String)("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID((UUID)profile.getId())));
            url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure));
            MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)MAKE_REQUEST.invoke((Object)auth, url, null, MinecraftProfilePropertiesResponse.class);
            if (response == null) {
                return profile;
            }
            GameProfile result = new GameProfile(response.getId(), response.getName());
            result.getProperties().putAll((Multimap)response.getProperties());
            profile.getProperties().putAll((Multimap)response.getProperties());
            return result;
        }

        @Override
        public void run() {
            String realUUID;
            try {
                realUUID = this.uuid.call();
            }
            catch (Exception e) {
                return;
            }
            GameProfile skinProfile = null;
            Property cached = (Property)TEXTURE_CACHE.get(realUUID);
            if (!(cached == null || this.npc.data().has(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES) && ((String)this.npc.data().get(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES)).equals("cache"))) {
                if (Messaging.isDebugging()) {
                    Messaging.debug("Using cached skin texture for NPC " + this.npc.getName() + " UUID " + this.npc.getUniqueId());
                }
                skinProfile = new GameProfile(UUID.fromString(realUUID), "");
                skinProfile.getProperties().put((Object)"textures", (Object)cached);
            } else {
                try {
                    skinProfile = this.fillProfileProperties(((YggdrasilMinecraftSessionService)this.repo).getAuthenticationService(), new GameProfile(UUID.fromString(realUUID), ""), true);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("too many requests") || e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains("too many requests")) {
                        SKIN_THREAD.delay();
                        SKIN_THREAD.addRunnable(this);
                    }
                    return;
                }
                if (skinProfile == null || !skinProfile.getProperties().containsKey((Object)"textures")) {
                    return;
                }
                Property textures = (Property)Iterables.getFirst((Iterable)skinProfile.getProperties().get((Object)"textures"), null);
                if (textures.getValue() == null || textures.getSignature() == null) {
                    return;
                }
                if (this.npc.data().has(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES) && ((String)this.npc.data().get(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES)).equals("cache")) {
                    this.npc.data().setPersistent(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES, textures.getValue());
                    this.npc.data().setPersistent(HumanController.PLAYER_SKIN_TEXTURE_PROPERTIES_SIGN, textures.getSignature());
                }
                if (Messaging.isDebugging()) {
                    Messaging.debug("Fetched skin texture for UUID " + realUUID + " for NPC " + this.npc.getName() + " UUID " + this.npc.getUniqueId());
                }
                TEXTURE_CACHE.put(realUUID, new Property("textures", textures.getValue(), textures.getSignature()));
            }
            if (CitizensAPI.getPlugin().isEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        if (SkinFetcher.this.npc.isSpawned()) {
                            SkinFetcher.this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                            SkinFetcher.this.npc.spawn(SkinFetcher.this.npc.getStoredLocation());
                        }
                    }
                });
            }
        }
    }
}

