/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWither;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wither;
import org.bukkit.util.Vector;

public class WitherController
extends MobEntityController {
    public WitherController() {
        super(EntityWitherNPC.class);
    }

    public Wither getBukkitEntity() {
        return (Wither)super.getBukkitEntity();
    }

    public static class WitherNPC
    extends CraftWither
    implements NPCHolder {
        private final CitizensNPC npc;

        public WitherNPC(EntityWitherNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityWither)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityWitherNPC
    extends EntityWither
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityWitherNPC(World world) {
            this(world, null);
        }

        public EntityWitherNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected String bo() {
            return this.npc == null ? super.bo() : this.npc.data().get("hurt-sound", super.bo());
        }

        protected String bp() {
            return this.npc == null ? super.bp() : this.npc.data().get("death-sound", super.bp());
        }

        public boolean cc() {
            if (this.npc == null) {
                return super.cc();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.cc();
            }
            if (super.cc()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        protected void E() {
            if (this.npc == null) {
                super.E();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new WitherNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void m() {
            if (this.npc == null) {
                super.m();
            } else {
                NMS.updateAI((EntityLiving)this);
                this.npc.update();
            }
        }

        protected String z() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.z() : this.npc.data().get("ambient-sound", super.z());
        }
    }
}

