/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityItem;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemController
extends AbstractEntityController {
    public ItemController() {
        super(EntityItemNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        Material id = Material.STONE;
        int data = npc.data().get("item-type-data", npc.data().get("falling-block-data", 0));
        if (npc.data().has("item-type-id")) {
            id = Material.getMaterial((String)((String)npc.data().get("item-type-id")));
        }
        EntityItemNPC handle = new EntityItemNPC((World)ws, npc, at.getX(), at.getY(), at.getZ(), CraftItemStack.asNMSCopy((ItemStack)new ItemStack(id, 1, (short)data)));
        return handle.getBukkitEntity();
    }

    public Item getBukkitEntity() {
        return (Item)super.getBukkitEntity();
    }

    public static class ItemNPC
    extends CraftItem
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemNPC(EntityItemNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityItem)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", material.name());
            this.npc.data().setPersistent("item-type-data", data);
            if (this.npc.isSpawned()) {
                this.npc.despawn();
                this.npc.spawn(this.npc.getStoredLocation());
            }
        }
    }

    public static class EntityItemNPC
    extends EntityItem
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemNPC(World world) {
            super(world);
            this.npc = null;
        }

        public EntityItemNPC(World world, NPC npc, double x, double y, double z, net.minecraft.server.v1_8_R3.ItemStack stack) {
            super(world, x, y, z, stack);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void d(EntityHuman entityhuman) {
            if (this.npc == null) {
                super.d(entityhuman);
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new ItemNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }
}

