/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityThrownExpBottle;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftThrownExpBottle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.util.Vector;

public class ThrownExpBottleController
extends MobEntityController {
    public ThrownExpBottleController() {
        super(EntityThrownExpBottleNPC.class);
    }

    public ThrownExpBottle getBukkitEntity() {
        return (ThrownExpBottle)super.getBukkitEntity();
    }

    public static class ThrownExpBottleNPC
    extends CraftThrownExpBottle
    implements NPCHolder {
        private final CitizensNPC npc;

        public ThrownExpBottleNPC(EntityThrownExpBottleNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityThrownExpBottle)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityThrownExpBottleNPC
    extends EntityThrownExpBottle
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityThrownExpBottleNPC(World world) {
            this(world, null);
        }

        public EntityThrownExpBottleNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new ThrownExpBottleNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }
}

