/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.command.CommandConfigurable;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class Controllable
extends Trait
implements Toggleable,
CommandConfigurable {
    private MovementController controller = new GroundController();
    @Persist
    private boolean enabled = true;
    private EntityType explicitType;
    @Persist(value="owner_required")
    private boolean ownerRequired;
    private static final Map<EntityType, Class<? extends MovementController>> controllerTypes = Maps.newEnumMap(EntityType.class);

    public Controllable() {
        super("controllable");
    }

    public Controllable(boolean enabled) {
        this();
        this.enabled = enabled;
    }

    @Override
    public void configure(CommandContext args) {
        if (args.hasFlag('f')) {
            this.explicitType = EntityType.BLAZE;
        } else if (args.hasFlag('g')) {
            this.explicitType = EntityType.OCELOT;
        } else if (args.hasFlag('o')) {
            this.explicitType = EntityType.UNKNOWN;
        } else if (args.hasFlag('r')) {
            this.explicitType = null;
        } else if (args.hasValueFlag("explicittype")) {
            this.explicitType = Util.matchEntityType(args.getFlag("explicittype"));
        }
        if (this.npc.isSpawned()) {
            this.loadController();
        }
    }

    private void enterOrLeaveVehicle(Player player) {
        EntityPlayer handle = ((CraftPlayer)player).getHandle();
        if (this.getHandle().passenger != null) {
            if (this.getHandle().passenger == handle) {
                player.leaveVehicle();
            }
            return;
        }
        if (this.ownerRequired && !this.npc.getTrait(Owner.class).isOwnedBy((CommandSender)handle.getBukkitEntity())) {
            return;
        }
        handle.mount(this.getHandle());
    }

    private net.minecraft.server.v1_8_R3.Entity getHandle() {
        return NMS.getHandle(this.npc.getEntity());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (key.keyExists("explicittype")) {
            this.explicitType = Util.matchEntityType(key.getString("explicittype"));
        }
    }

    private void loadController() {
        Class<? extends MovementController> clazz;
        EntityType type = this.npc.getEntity().getType();
        if (this.explicitType != null) {
            type = this.explicitType;
        }
        if ((clazz = controllerTypes.get(type)) == null) {
            this.controller = new GroundController();
            return;
        }
        Constructor<? extends MovementController> innerConstructor = null;
        try {
            innerConstructor = clazz.getConstructor(Controllable.class);
            innerConstructor.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.controller = innerConstructor == null ? clazz.newInstance() : innerConstructor.newInstance(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller = new GroundController();
        }
    }

    public boolean mount(Player toMount) {
        Entity passenger = this.npc.getEntity().getPassenger();
        if (passenger != null && passenger != toMount) {
            return false;
        }
        this.enterOrLeaveVehicle(toMount);
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        Action performed = event.getAction();
        if (!handle.equals((Object)this.getHandle().passenger)) {
            return;
        }
        switch (performed) {
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(event);
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(event);
                break;
            }
        }
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (!(this.enabled && this.npc.isSpawned() && event.getNPC().equals(this.npc))) {
            return;
        }
        this.controller.rightClickEntity(event);
    }

    @Override
    public void onSpawn() {
        this.loadController();
    }

    @Override
    public void run() {
        if (!(this.enabled && this.npc.isSpawned() && this.getHandle().passenger != null && this.getHandle().passenger.getBukkitEntity() instanceof Player)) {
            return;
        }
        this.controller.run((Player)this.getHandle().passenger.getBukkitEntity());
    }

    @Override
    public void save(DataKey key) {
        if (this.explicitType == null) {
            key.removeKey("explicittype");
        } else {
            key.setString("explicittype", this.explicitType.name());
        }
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return enabled;
    }

    private void setMountedYaw(net.minecraft.server.v1_8_R3.Entity handle) {
        if (handle instanceof EntityEnderDragon || !Settings.Setting.USE_BOAT_CONTROLS.asBoolean()) {
            return;
        }
        double tX = handle.locX + handle.motX;
        double tZ = handle.locZ + handle.motZ;
        if (handle.locZ > tZ) {
            handle.yaw = (float)(-Math.toDegrees(Math.atan((handle.locX - tX) / (handle.locZ - tZ)))) + 180.0f;
        } else if (handle.locZ < tZ) {
            handle.yaw = (float)(-Math.toDegrees(Math.atan((handle.locX - tX) / (handle.locZ - tZ))));
        }
        NMS.setHeadYaw(handle, handle.yaw);
    }

    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    @Override
    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && this.getHandle().passenger != null) {
            this.getHandle().passenger.getBukkitEntity().leaveVehicle();
        }
        return this.enabled;
    }

    private double updateHorizontalSpeed(net.minecraft.server.v1_8_R3.Entity handle, net.minecraft.server.v1_8_R3.Entity passenger, double speed, float speedMod) {
        double oldSpeed = Math.sqrt(handle.motX * handle.motX + handle.motZ * handle.motZ);
        double horizontal = ((EntityLiving)passenger).ba;
        if (horizontal > 0.0) {
            double dXcos = -Math.sin((double)passenger.yaw * Math.PI / 180.0);
            double dXsin = Math.cos((double)passenger.yaw * Math.PI / 180.0);
            handle.motX += dXcos * speed * 0.5;
            handle.motZ += dXsin * speed * 0.5;
        }
        handle.motX += passenger.motX * (double)speedMod;
        handle.motZ += passenger.motZ * (double)speedMod;
        double newSpeed = Math.sqrt(handle.motX * handle.motX + handle.motZ * handle.motZ);
        if (newSpeed > 0.35) {
            double movementFactor = 0.35 / newSpeed;
            handle.motX *= movementFactor;
            handle.motZ *= movementFactor;
            newSpeed = 0.35;
        }
        if (newSpeed > oldSpeed && speed < 0.35) {
            return (float)Math.min(0.35, speed + (0.35 - speed) / 35.0);
        }
        return (float)Math.max(0.07, speed - (speed - 0.07) / 35.0);
    }

    public static void registerControllerType(EntityType type, Class<? extends MovementController> clazz) {
        controllerTypes.put(type, clazz);
    }

    static {
        controllerTypes.put(EntityType.BAT, PlayerInputAirController.class);
        controllerTypes.put(EntityType.BLAZE, PlayerInputAirController.class);
        controllerTypes.put(EntityType.ENDER_DRAGON, PlayerInputAirController.class);
        controllerTypes.put(EntityType.GHAST, PlayerInputAirController.class);
        controllerTypes.put(EntityType.WITHER, PlayerInputAirController.class);
        controllerTypes.put(EntityType.UNKNOWN, LookAirController.class);
    }

    public class PlayerInputAirController
    implements MovementController {
        private boolean paused = false;
        private double speed;

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            ((Controllable)Controllable.this).getHandle().motY = -0.3f;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                ((Controllable)Controllable.this).getHandle().motY = 0.001;
                return;
            }
            net.minecraft.server.v1_8_R3.Entity handle = Controllable.this.getHandle();
            EntityPlayer passenger = ((CraftPlayer)rider).getHandle();
            this.speed = Controllable.this.updateHorizontalSpeed(handle, (net.minecraft.server.v1_8_R3.Entity)passenger, this.speed, 1.0f);
            boolean shouldJump = NMS.shouldJump((net.minecraft.server.v1_8_R3.Entity)passenger);
            if (shouldJump) {
                handle.motY = 0.3f;
            }
            handle.motY *= (double)0.98f;
        }
    }

    public static interface MovementController {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1);
    }

    public class LookAirController
    implements MovementController {
        private boolean paused = false;

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                ((Controllable)Controllable.this).getHandle().motY = 0.001;
                return;
            }
            Vector dir = rider.getEyeLocation().getDirection();
            dir.multiply(Controllable.this.npc.getNavigator().getDefaultParameters().speedModifier());
            net.minecraft.server.v1_8_R3.Entity handle = Controllable.this.getHandle();
            handle.motX = dir.getX();
            handle.motY = dir.getY();
            handle.motZ = dir.getZ();
            Controllable.this.setMountedYaw(handle);
        }
    }

    public class GroundController
    implements MovementController {
        private int jumpTicks = 0;
        private double speed = 0.07;
        private static final float AIR_SPEED = 1.5f;
        private static final float GROUND_SPEED = 4.0f;
        private static final float JUMP_VELOCITY = 0.6f;

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            net.minecraft.server.v1_8_R3.Entity handle = Controllable.this.getHandle();
            EntityPlayer passenger = ((CraftPlayer)rider).getHandle();
            boolean onGround = handle.onGround;
            float speedMod = Controllable.this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 4.0f : 1.5f);
            this.speed = Controllable.this.updateHorizontalSpeed(handle, (net.minecraft.server.v1_8_R3.Entity)passenger, this.speed, speedMod);
            boolean shouldJump = NMS.shouldJump((net.minecraft.server.v1_8_R3.Entity)passenger);
            if (shouldJump) {
                if (handle.onGround && this.jumpTicks == 0) {
                    ((Controllable)Controllable.this).getHandle().motY = 0.6f;
                    this.jumpTicks = 10;
                }
            } else {
                this.jumpTicks = 0;
            }
            this.jumpTicks = Math.max(0, this.jumpTicks - 1);
            Controllable.this.setMountedYaw(handle);
        }
    }
}

