/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.DyeColor;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class SheepTrait
extends Trait {
    @Persist(value="color")
    private DyeColor color = DyeColor.WHITE;
    @Persist(value="sheared")
    private boolean sheared = false;

    public SheepTrait() {
        super("sheeptrait");
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent event) {
        if (this.npc != null && this.npc.equals(CitizensAPI.getNPCRegistry().getNPC(event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onSpawn() {
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Sheep) {
            Sheep sheep = (Sheep)this.npc.getEntity();
            sheep.setSheared(this.sheared);
            sheep.setColor(this.color);
        }
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public void setSheared(boolean sheared) {
        this.sheared = sheared;
    }

    public boolean toggleSheared() {
        this.sheared = !this.sheared;
        return this.sheared;
    }
}

