/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.trait.waypoint.EntityEnderSignalMarker;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class WaypointMarkers {
    private final Map<Waypoint, Entity> waypointMarkers = Maps.newHashMap();
    private final World world;

    public WaypointMarkers(World world) {
        this.world = world;
    }

    public Entity createWaypointMarker(Waypoint waypoint) {
        Entity entity = this.spawnMarker(this.world, waypoint.getLocation().clone().add(0.0, 1.0, 0.0));
        if (entity == null) {
            return null;
        }
        this.waypointMarkers.put(waypoint, entity);
        return entity;
    }

    public void destroyWaypointMarkers() {
        for (Entity entity : this.waypointMarkers.values()) {
            entity.remove();
        }
        this.waypointMarkers.clear();
    }

    public void removeWaypointMarker(Waypoint waypoint) {
        Entity entity = this.waypointMarkers.remove(waypoint);
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity spawnMarker(World world, Location at) {
        return NMS.spawnCustomEntity(world, at, EntityEnderSignalMarker.class, EntityType.ENDER_SIGNAL);
    }
}

