/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.Arrays;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutBed;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public enum PlayerAnimation {
    ARM_SWING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 0);
        }
    }
    ,
    CRIT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 4);
        }
    }
    ,
    EAT_FOOD{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 3);
        }
    }
    ,
    HURT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 1);
        }
    }
    ,
    MAGIC_CRIT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 5);
        }
    }
    ,
    SIT{

        @Override
        protected void playAnimation(final EntityPlayer player, int radius) {
            player.getBukkitEntity().setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
            new BukkitRunnable(){

                public void run() {
                    if (player.dead || !player.valid || !((MetadataValue)player.getBukkitEntity().getMetadata("citizens.sitting").get(0)).asBoolean()) {
                        this.cancel();
                        return;
                    }
                    if (player instanceof NPCHolder && !((NPCHolder)player).getNPC().isSpawned()) {
                        this.cancel();
                        return;
                    }
                    if (player.passenger != player) {
                        player.mount((Entity)player);
                    }
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
        }
    }
    ,
    SLEEP{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            PacketPlayOutBed packet = new PacketPlayOutBed((EntityHuman)player, new BlockPosition((int)player.locX, (int)player.locY, (int)player.locZ));
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    SNEAK{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(true);
            this.sendPacketNearby((Packet)new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    START_USE_ITEM{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.f(true);
            this.sendPacketNearby((Packet)new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    STOP_SITTING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setMetadata("citizens.sitting", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)false));
            player.mount(null);
        }
    }
    ,
    STOP_SLEEPING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            this.playDefaultAnimation(player, radius, 2);
        }
    }
    ,
    STOP_SNEAKING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(false);
            this.sendPacketNearby((Packet)new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    STOP_USE_ITEM{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.f(false);
            this.sendPacketNearby((Packet)new PacketPlayOutEntityMetadata(player.getId(), player.getDataWatcher(), true), player, radius);
        }
    };


    public void play(Player player) {
        this.play(player, 64);
    }

    public void play(Player player, int radius) {
        this.playAnimation(((CraftPlayer)player).getHandle(), radius);
    }

    protected void playAnimation(EntityPlayer player, int radius) {
        throw new UnsupportedOperationException("unimplemented animation");
    }

    protected void playDefaultAnimation(EntityPlayer player, int radius, int code) {
        PacketPlayOutAnimation packet = new PacketPlayOutAnimation((Entity)player, code);
        this.sendPacketNearby((Packet)packet, player, radius);
    }

    protected void sendPacketNearby(Packet packet, EntityPlayer player, int radius) {
        NMS.sendPacketsNearby((Player)player.getBukkitEntity(), player.getBukkitEntity().getLocation(), Arrays.asList(packet), radius);
    }
}

