/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluator;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class EntityPathfinder
extends Pathfinder {
    private final int maxVisitedNodes;
    private final PathPoint[] neighbors = new PathPoint[32];
    private final EntityNodeEvaluator nodeEvaluator;
    private final Path openSet = new Path();

    public EntityPathfinder(EntityNodeEvaluator var0, int var1) {
        super((PathfinderAbstract)var0, var1);
        this.nodeEvaluator = var0;
        this.maxVisitedNodes = var1;
    }

    public PathEntity findPath(ChunkCache var0, EntityLiving var1, Set<BlockPosition> var2, float var3, int var4, float var5) {
        this.openSet.a();
        this.nodeEvaluator.prepare(var0, var1);
        PathPoint var6 = this.nodeEvaluator.a();
        Map<PathDestination, BlockPosition> var7 = var2.stream().collect(Collectors.toMap(p -> this.nodeEvaluator.a(p.u(), p.v(), p.w()), Function.identity()));
        PathEntity var8 = this.findPath(null, var6, var7, var3, var4, var5);
        this.nodeEvaluator.b();
        return var8;
    }

    public PathEntity a(ChunkCache var0, EntityInsentient var1, Set<BlockPosition> var2, float var3, int var4, float var5) {
        this.openSet.a();
        this.nodeEvaluator.a(var0, var1);
        PathPoint var6 = this.nodeEvaluator.a();
        Map<PathDestination, BlockPosition> var7 = var2.stream().collect(Collectors.toMap(p -> this.nodeEvaluator.a(p.u(), p.v(), p.w()), Function.identity()));
        PathEntity var8 = this.findPath(null, var6, var7, var3, var4, var5);
        this.nodeEvaluator.b();
        return var8;
    }

    private PathEntity findPath(GameProfilerFiller var0, PathPoint var1, Map<PathDestination, BlockPosition> var2, float range, int reachRange, float var5) {
        Object var11;
        Set<PathDestination> var6 = var2.keySet();
        var1.e = 0.0f;
        var1.g = var1.f = this.getBestH(var1, var6);
        this.openSet.a();
        this.openSet.a(var1);
        ImmutableSet var7 = ImmutableSet.of();
        int var8 = 0;
        HashSet var9 = Sets.newHashSetWithExpectedSize((int)var6.size());
        int var10 = (int)((float)this.maxVisitedNodes * var5);
        while (!this.openSet.e() && ++var8 < var10) {
            var11 = this.openSet.c();
            ((PathPoint)var11).i = true;
            for (PathDestination var13t : var6) {
                if (!(var11.d((PathPoint)var13t) <= (float)reachRange)) continue;
                var13t.e();
                var9.add(var13t);
            }
            if (!var9.isEmpty()) break;
            if (!(var11.a(var1) < range)) continue;
            int var12 = this.nodeEvaluator.a(this.neighbors, (PathPoint)var11);
            for (int i = 0; i < var12; ++i) {
                PathPoint var14 = this.neighbors[i];
                float var15 = this.a((PathPoint)var11, var14);
                var14.j = ((PathPoint)var11).j + var15;
                float var16 = ((PathPoint)var11).e + var15 + var14.k;
                if (!(var14.j < range) || var14.c() && !(var16 < var14.e)) continue;
                var14.h = var11;
                var14.e = var16;
                var14.f = this.getBestH(var14, var6) * 1.5f;
                if (var14.c()) {
                    this.openSet.a(var14, var14.e + var14.f);
                    continue;
                }
                var14.g = var14.e + var14.f;
                this.openSet.a(var14);
            }
        }
        Optional<Object> optional = var11 = !var9.isEmpty() ? var9.stream().map(var1x -> this.reconstructPath(var1x.d(), (BlockPosition)var2.get(var1x), true)).min(Comparator.comparingInt(PathEntity::e)) : this.getFallbackDestinations(var2, var6);
        if (!((Optional)var11).isPresent()) {
            return null;
        }
        PathEntity var12 = (PathEntity)((Optional)var11).get();
        return var12;
    }

    private float getBestH(PathPoint var0, Set<PathDestination> var1) {
        float var2 = Float.MAX_VALUE;
        for (PathDestination var4 : var1) {
            float var5 = var0.a((PathPoint)var4);
            var4.a(var5, var0);
            var2 = Math.min(var5, var2);
        }
        return var2;
    }

    public Optional<PathEntity> getFallbackDestinations(Map<PathDestination, BlockPosition> var1, Set<PathDestination> var5) {
        if (Settings.Setting.DISABLE_MC_NAVIGATION_FALLBACK.asBoolean()) {
            return Optional.empty();
        }
        return var5.stream().map(var1x -> this.reconstructPath(var1x.d(), (BlockPosition)var1.get(var1x), false)).min(Comparator.comparingDouble(PathEntity::n).thenComparingInt(PathEntity::e));
    }

    private PathEntity reconstructPath(PathPoint var0, BlockPosition var1, boolean var2) {
        ArrayList var3 = Lists.newArrayList();
        PathPoint var4 = var0;
        var3.add(0, var4);
        while (var4.h != null) {
            var4 = var4.h;
            var3.add(0, var4);
        }
        return new PathEntity((List)var3, var1, var2);
    }
}

