/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.npc.skin.profile.ProfileFetcher;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.SkinProperty;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.scheduler.BukkitTask;

public class Skin {
    private boolean fetching;
    private int fetchRetries = -1;
    private boolean hasFetched;
    private volatile boolean isValid = true;
    private final Map<SkinnableEntity, Void> pending = new WeakHashMap<SkinnableEntity, Void>(15);
    private BukkitTask retryTask;
    private volatile SkinProperty skinData;
    private volatile UUID skinId;
    private final String skinName;
    private static final Map<String, Skin> CACHE = new HashMap<String, Skin>(20);
    public static final String CACHED_SKIN_UUID_METADATA = "cached-skin-uuid";
    public static final String CACHED_SKIN_UUID_NAME_METADATA = "cached-skin-uuid-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Skin(String skinName) {
        this.skinName = skinName.toLowerCase(Locale.ROOT);
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            if (CACHE.containsKey(this.skinName)) {
                throw new IllegalArgumentException("There is already a skin named " + skinName);
            }
            CACHE.put(this.skinName, this);
        }
    }

    public boolean apply(SkinnableEntity entity) {
        Objects.requireNonNull(entity);
        NPC npc = entity.getNPC();
        SkinTrait skinTrait = npc.getOrAddTrait(SkinTrait.class);
        String cachedName = (String)npc.data().get(CACHED_SKIN_UUID_NAME_METADATA);
        String texture = skinTrait.getTexture();
        if (this.skinName.equals(cachedName) && texture != null && !texture.equals("cache")) {
            Skin.setNPCTexture(entity, new SkinProperty("textures", texture, skinTrait.getSignature()));
            if (!skinTrait.shouldUpdateSkins()) {
                return true;
            }
        }
        if (!this.hasSkinData()) {
            String npcName = ChatColor.stripColor((String)npc.getName()).toLowerCase(Locale.ROOT);
            if (!skinTrait.shouldUpdateSkins() && !skinTrait.fetchDefaultSkin() && this.skinName.equals(npcName)) {
                return false;
            }
            if (this.hasFetched) {
                return true;
            }
            if (!this.fetching) {
                this.fetch();
            }
            this.pending.put(entity, null);
            return false;
        }
        Skin.setNPCSkinData(entity, this.skinName, this.skinId, this.skinData);
        return true;
    }

    public void applyAndRespawn(SkinnableEntity entity) {
        Objects.requireNonNull(entity);
        if (!this.apply(entity)) {
            return;
        }
        NPC npc = entity.getNPC();
        if (!npc.isSpawned()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
            npc.spawn(npc.getStoredLocation(), SpawnReason.RESPAWN);
        });
    }

    private void fetch() {
        int maxRetries = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (maxRetries > -1 && this.fetchRetries >= maxRetries) {
            Messaging.idebug(() -> "Reached max skin fetch retries for '" + this.skinName + "'");
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            return;
        }
        if (this.skinName.toLowerCase(Locale.ROOT).startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetch(this.skinName, request -> {
            this.hasFetched = true;
            switch (request.getResult()) {
                case NOT_FOUND: {
                    this.isValid = false;
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    if (maxRetries == 0) break;
                    ++this.fetchRetries;
                    long delay = Settings.Setting.NPC_SKIN_RETRY_DELAY.asTicks();
                    this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), this::fetch, delay);
                    Messaging.idebug(() -> "Retrying skin fetch for '" + this.skinName + "' in " + delay + " ticks.");
                    break;
                }
                case SUCCESS: {
                    GameProfile profile = request.getProfile();
                    this.setData(profile);
                    break;
                }
            }
        });
    }

    private void fetchForced() {
        int maxRetries = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (maxRetries > -1 && this.fetchRetries >= maxRetries) {
            Messaging.idebug(() -> "Reached max skin fetch retries for '" + this.skinName + "'");
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            return;
        }
        if (this.skinName.toLowerCase(Locale.ROOT).startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetchForced(this.skinName, request -> {
            this.hasFetched = true;
            switch (request.getResult()) {
                case NOT_FOUND: {
                    this.isValid = false;
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    if (maxRetries == 0) break;
                    ++this.fetchRetries;
                    int delay = Settings.Setting.NPC_SKIN_RETRY_DELAY.asTicks();
                    this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), this::fetchForced, (long)delay);
                    Messaging.idebug(() -> "Retrying skin fetch for '" + this.skinName + "' in " + delay + " ticks.");
                    break;
                }
                case SUCCESS: {
                    GameProfile profile = request.getProfile();
                    this.setData(profile);
                    break;
                }
            }
        });
    }

    @Nullable
    public UUID getSkinId() {
        return this.skinId;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public boolean hasSkinData() {
        return this.skinData != null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void setData(@Nullable GameProfile profile) {
        if (profile == null) {
            this.isValid = false;
            return;
        }
        if (!profile.getName().toLowerCase(Locale.ROOT).equals(this.skinName)) {
            Messaging.debug("GameProfile name (" + profile.getName() + ") and skin name (" + this.skinName + ") do not match. Has the user renamed recently?");
        }
        this.skinId = profile.getId();
        this.skinData = SkinProperty.fromMojangProfile(profile);
        ArrayList<SkinnableEntity> entities = new ArrayList<SkinnableEntity>(this.pending.keySet());
        for (SkinnableEntity entity : entities) {
            this.applyAndRespawn(entity);
        }
        this.pending.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            for (Skin skin : CACHE.values()) {
                skin.pending.clear();
                if (skin.retryTask == null) continue;
                skin.retryTask.cancel();
            }
            CACHE.clear();
        }
    }

    public static Skin get(SkinnableEntity entity) {
        return Skin.get(entity, false);
    }

    public static Skin get(SkinnableEntity entity, boolean forceUpdate) {
        Objects.requireNonNull(entity);
        return Skin.get(entity.getSkinName(), forceUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin get(String skinName, boolean forceUpdate) {
        Skin skin;
        Objects.requireNonNull(skinName);
        skinName = skinName.toLowerCase(Locale.ROOT);
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            skin = CACHE.get(skinName);
        }
        if (skin == null) {
            skin = new Skin(skinName);
        } else if (forceUpdate) {
            skin.fetchForced();
        }
        return skin;
    }

    private static void setNPCSkinData(SkinnableEntity entity, String skinName, UUID skinId, SkinProperty skinProperty) {
        NPC npc = entity.getNPC();
        SkinTrait skinTrait = npc.getOrAddTrait(SkinTrait.class);
        npc.data().setPersistent(CACHED_SKIN_UUID_NAME_METADATA, (Object)skinName);
        npc.data().setPersistent(CACHED_SKIN_UUID_METADATA, (Object)skinId.toString());
        if (skinProperty.value != null) {
            skinTrait.setTexture(skinProperty.value, skinProperty.signature == null ? "" : skinProperty.signature);
            Skin.setNPCTexture(entity, skinProperty);
        } else {
            skinTrait.clearTexture();
        }
    }

    private static void setNPCTexture(SkinnableEntity entity, SkinProperty skinProperty) {
        GameProfile profile = entity.getProfile();
        SkinProperty current = SkinProperty.fromMojangProfile(profile);
        if (current != null && current.value.equals(skinProperty.value) && current.signature != null && current.signature.equals(skinProperty.signature)) {
            return;
        }
        skinProperty.apply(profile);
    }
}

