/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util.schedulers.adapter;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import net.citizensnpcs.api.util.schedulers.SchedulerAdapter;
import net.citizensnpcs.api.util.schedulers.SchedulerTask;
import net.citizensnpcs.api.util.schedulers.adapter.FoliaSchedulerTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements SchedulerAdapter {
    private final AsyncScheduler asyncScheduler;
    private final GlobalRegionScheduler globalScheduler;
    private final Plugin plugin;
    private final RegionScheduler regionScheduler;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.globalScheduler = Bukkit.getGlobalRegionScheduler();
        this.asyncScheduler = Bukkit.getAsyncScheduler();
        this.regionScheduler = Bukkit.getRegionScheduler();
    }

    @Override
    public SchedulerTask runEntityTask(Entity entity, Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = entity.getScheduler().run(this.plugin, t -> runnable.run(), null);
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runEntityTaskLater(Entity entity, Runnable runnable, long delayTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = entity.getScheduler().runDelayed(this.plugin, t -> runnable.run(), null, Math.max(1L, delayTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runEntityTaskTimer(Entity entity, Runnable runnable, long delayTicks, long periodTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = entity.getScheduler().runAtFixedRate(this.plugin, t -> runnable.run(), null, Math.max(1L, delayTicks), Math.max(1L, periodTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTask(Location location, Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.run(this.plugin, location, t -> runnable.run());
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTask(World world, int chunkX, int chunkZ, Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.run(this.plugin, world, chunkX, chunkZ, t -> runnable.run());
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTaskLater(Location location, Runnable runnable, long delayTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.runDelayed(this.plugin, location, t -> runnable.run(), Math.max(1L, delayTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTaskLater(World world, int chunkX, int chunkZ, Runnable runnable, long delayTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.runDelayed(this.plugin, world, chunkX, chunkZ, t -> runnable.run(), Math.max(1L, delayTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTaskTimer(Location location, Runnable runnable, long delayTicks, long periodTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.runAtFixedRate(this.plugin, location, t -> runnable.run(), Math.max(1L, delayTicks), Math.max(1L, periodTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runRegionTaskTimer(World world, int chunkX, int chunkZ, Runnable runnable, long delayTicks, long periodTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.regionScheduler.runAtFixedRate(this.plugin, world, chunkX, chunkZ, t -> runnable.run(), Math.max(1L, delayTicks), Math.max(1L, periodTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTask(Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.globalScheduler.run(this.plugin, t -> runnable.run());
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTaskAsynchronously(Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.asyncScheduler.runNow(this.plugin, t -> runnable.run());
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTaskLater(Runnable runnable, long delayTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.globalScheduler.runDelayed(this.plugin, t -> runnable.run(), Math.max(1L, delayTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTaskLaterAsynchronously(Runnable runnable, long delayTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.asyncScheduler.runDelayed(this.plugin, t -> runnable.run(), this.ticksToMillis(Math.max(1L, delayTicks)), TimeUnit.MILLISECONDS);
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTaskTimer(Runnable runnable, long delayTicks, long periodTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.globalScheduler.runAtFixedRate(this.plugin, t -> runnable.run(), Math.max(1L, delayTicks), Math.max(1L, periodTicks));
        return this.wrap(task);
    }

    @Override
    public SchedulerTask runTaskTimerAsynchronously(Runnable runnable, long delayTicks, long periodTicks) {
        if (!this.plugin.isEnabled()) {
            return null;
        }
        ScheduledTask task = this.asyncScheduler.runAtFixedRate(this.plugin, t -> runnable.run(), this.ticksToMillis(Math.max(1L, delayTicks)), this.ticksToMillis(Math.max(1L, periodTicks)), TimeUnit.MILLISECONDS);
        return this.wrap(task);
    }

    @Override
    public boolean isOnOwnerThread(Entity entity) {
        return Bukkit.isOwnedByCurrentRegion((Entity)entity);
    }

    @Override
    public boolean isOnOwnerThread(Location location) {
        return Bukkit.isOwnedByCurrentRegion((Location)location);
    }

    @Override
    public boolean isOnOwnerThread(World world, int chunkX, int chunkZ) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ);
    }

    @Override
    public boolean isOnOwnerThread(Block block) {
        return Bukkit.isOwnedByCurrentRegion((Block)block);
    }

    private long ticksToMillis(long ticks) {
        return ticks * 50L;
    }

    private SchedulerTask wrap(ScheduledTask task) {
        return new FoliaSchedulerTask(task);
    }
}

