/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R5.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R5.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R5.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R5.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftSalmon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Salmon;

public class SalmonController
extends MobEntityController {
    public SalmonController() {
        super(EntitySalmonNPC.class, EntityTypes.bc);
    }

    public Salmon getBukkitEntity() {
        return (Salmon)super.getBukkitEntity();
    }

    public static class EntitySalmonNPC
    extends EntitySalmon
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntitySalmonNPC(EntityTypes<? extends EntitySalmon> types, World level) {
            this(types, level, null);
        }

        public EntitySalmonNPC(EntityTypes<? extends EntitySalmon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.oldMoveController = this.ce;
                this.ce = new ControllerMove((EntityInsentient)this);
            }
        }

        public void e_() {
            boolean lastInWater = this.ad;
            if (this.npc != null) {
                this.ad = false;
            }
            super.e_();
            if (this.npc != null) {
                this.ad = lastInWater;
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dJ() {
            if (this.npc == null) {
                super.dJ();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            if (this.npc != null) {
                NMSImpl.setNotInSchool((EntityFish)this);
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.ce != this.oldMoveController) {
                    this.ce = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.ce == this.oldMoveController) {
                    this.ce = new EntityMoveControl((EntityLiving)this);
                }
            }
            super.a(level);
            if (this.npc != null) {
                this.npc.update();
            }
        }

        protected SoundEffect p() {
            return NMSImpl.getSoundEffect(this.npc, super.p(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new SalmonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect f_() {
            return NMSImpl.getSoundEffect(this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fn() {
            return NMS.getJumpPower(this.npc, super.fn());
        }

        public int cI() {
            return NMS.getFallDistance(this.npc, super.cI());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean R_() {
            return NMSImpl.isLeashed(this.npc, () -> super.R_(), (EntityInsentient)this);
        }

        public boolean bL() {
            return this.npc == null ? super.bL() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityhuman, enumhand);
            }
            ItemStack itemstack = entityhuman.b(enumhand);
            if (itemstack.h() == Items.rG && this.bO()) {
                return EnumInteractionResult.d;
            }
            return super.b(entityhuman, enumhand);
        }

        public boolean eV() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.eV();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void k(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3d)) {
                    super.k(vec3d);
                }
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dA().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class SalmonNPC
    extends CraftSalmon
    implements ForwardingNPCHolder {
        public SalmonNPC(EntitySalmonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntitySalmon)entity);
        }
    }
}

