/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin.profile;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.profile.ProfileFetchResult;

public class ProfileRequest {
    private Deque<Consumer<ProfileRequest>> handlers;
    private final String playerName;
    private GameProfile profile;
    private volatile ProfileFetchResult result = ProfileFetchResult.PENDING;

    public ProfileRequest(String playerName, Consumer<ProfileRequest> handler) {
        Objects.requireNonNull(playerName);
        this.playerName = playerName;
        if (handler != null) {
            this.addHandler(handler);
        }
    }

    public void addHandler(Consumer<ProfileRequest> handler) {
        Objects.requireNonNull(handler);
        if (this.result != ProfileFetchResult.PENDING) {
            handler.accept(this);
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayDeque<Consumer<ProfileRequest>>();
        }
        this.handlers.addLast(handler);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileRequest other = (ProfileRequest)obj;
        return !(this.playerName == null ? other.playerName != null : !this.playerName.equals(other.playerName));
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public ProfileFetchResult getResult() {
        return this.result;
    }

    public int hashCode() {
        return 31 + (this.playerName == null ? 0 : this.playerName.hashCode());
    }

    void setResult(@Nullable GameProfile profile, ProfileFetchResult result) {
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        CitizensAPI.getScheduler().runTask(() -> {
            this.profile = profile;
            this.result = result;
            if (this.handlers == null) {
                return;
            }
            while (!this.handlers.isEmpty()) {
                this.handlers.removeFirst().accept(this);
            }
            this.handlers = null;
        });
    }
}

