/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCCommandDispatchEvent;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.trait.shop.ExperienceAction;
import net.citizensnpcs.trait.shop.ItemAction;
import net.citizensnpcs.trait.shop.MoneyAction;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;

@TraitName(value="commandtrait")
public class CommandTrait
extends Trait {
    @Persist(keyType=Integer.class)
    @DelegatePersistence(value=NPCCommandPersister.class)
    private final Map<Integer, NPCCommand> commands = Maps.newHashMap();
    @Persist
    private double cost = -1.0;
    @Persist(keyType=CommandTraitError.class)
    private final Map<CommandTraitError, String> customErrorMessages = Maps.newEnumMap(CommandTraitError.class);
    private final Map<String, Set<CommandTraitError>> executionErrors = Maps.newHashMap();
    @Persist
    private ExecutionMode executionMode = ExecutionMode.LINEAR;
    @Persist
    private int experienceCost = -1;
    @Persist(valueType=Long.class)
    private final Map<String, Long> globalCooldowns = Maps.newHashMap();
    @Persist(valueType=Integer.class)
    private final Map<String, Integer> globalUses = Maps.newHashMap();
    @Persist
    private boolean hideErrorMessages;
    @Persist
    private final List<ItemStack> itemRequirements = Lists.newArrayList();
    private int lastUsedId = -1;
    @Persist(keyType=UUID.class, reify=true, value="cooldowns")
    private final Map<UUID, PlayerNPCCommand> playerTracking = Maps.newHashMap();
    @Persist(value="persistSequence")
    private boolean rememberLastUsed = false;
    @Persist
    private final List<String> temporaryPermissions = Lists.newArrayList();
    @Persist
    private int temporaryPermissionsDuration;

    public CommandTrait() {
        super("commandtrait");
    }

    public int addCommand(NPCCommandBuilder builder) {
        int id = this.getNewId();
        this.commands.put(id, builder.build(id));
        return id;
    }

    private NPCShopAction.Transaction chargeCommandCosts(Player player, Hand hand, NPCCommand command) {
        NPCShopAction.Transaction action;
        if (player.hasPermission("citizens.npc.command.ignoreerrors.*")) {
            return NPCShopAction.Transaction.success();
        }
        ArrayList txns = Lists.newArrayList();
        if (this.nonZeroOrNegativeOne(command.cost) && !player.hasPermission("citizens.npc.command.ignoreerrors.cost")) {
            action = new MoneyAction(command.cost).take(player, 1);
            if (!action.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_MONEY, null, command.cost);
            }
            txns.add(action);
        }
        if (command.experienceCost != -1 && !player.hasPermission("citizens.npc.command.ignoreerrors.expcost")) {
            action = new ExperienceAction(command.experienceCost).take(player, 1);
            if (!action.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_EXPERIENCE, null, command.experienceCost);
            }
            txns.add(action);
        }
        if (command.itemCost != null && command.itemCost.size() > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.itemcost")) {
            action = new ItemAction(command.itemCost).take(player, 1);
            if (!action.isPossible()) {
                ItemStack stack = command.itemCost.get(0);
                this.sendErrorMessage(player, CommandTraitError.MISSING_ITEM, null, stack.hasItemMeta() && stack.getItemMeta().hasDisplayName() ? stack.getItemMeta().getDisplayName() : Util.prettyEnum(stack.getType()), stack.getAmount());
            }
            txns.add(action);
        }
        return NPCShopAction.Transaction.compose(txns);
    }

    private NPCShopAction.Transaction chargeGlobalCommandCosts(Player player, Hand hand) {
        NPCShopAction.Transaction action;
        if (player.hasPermission("citizens.npc.command.ignoreerrors.*")) {
            return NPCShopAction.Transaction.success();
        }
        ArrayList txns = Lists.newArrayList();
        if (this.nonZeroOrNegativeOne(this.cost) && !player.hasPermission("citizens.npc.command.ignoreerrors.cost")) {
            action = new MoneyAction(this.cost).take(player, 1);
            if (!action.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_MONEY, null, this.cost);
            }
            txns.add(action);
        }
        if (this.experienceCost > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.expcost")) {
            action = new ExperienceAction(this.experienceCost).take(player, 1);
            if (!action.isPossible()) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_EXPERIENCE, null, this.experienceCost);
            }
            txns.add(action);
        }
        if (this.itemRequirements.size() > 0 && !player.hasPermission("citizens.npc.command.ignoreerrors.itemcost")) {
            action = new ItemAction(this.itemRequirements).take(player, 1);
            if (!action.isPossible()) {
                ItemStack stack = this.itemRequirements.get(0);
                this.sendErrorMessage(player, CommandTraitError.MISSING_ITEM, null, stack.hasItemMeta() && stack.getItemMeta().hasDisplayName() ? stack.getItemMeta().getDisplayName() : Util.prettyEnum(stack.getType()), stack.getAmount());
            }
            txns.add(action);
        }
        return NPCShopAction.Transaction.compose(txns);
    }

    public void clear() {
        this.commands.clear();
    }

    public void clearHistory(CommandTraitError which, UUID who) {
        ArrayList toClear = Lists.newArrayList();
        if (who != null) {
            toClear.add(this.playerTracking.get(who));
        } else {
            toClear.addAll(this.playerTracking.values());
        }
        switch (which.ordinal()) {
            case 1: {
                for (PlayerNPCCommand tracked : toClear) {
                    tracked.nUsed.clear();
                }
                break;
            }
            case 6: {
                for (PlayerNPCCommand tracked : toClear) {
                    tracked.lastUsed.clear();
                }
                break;
            }
            case 7: {
                this.globalCooldowns.clear();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void clearPlayerHistory(UUID who) {
        if (who == null) {
            this.playerTracking.clear();
        } else {
            this.playerTracking.remove(who);
        }
    }

    public void describe(CommandSender sender) {
        ArrayList left = Lists.newArrayList();
        ArrayList right = Lists.newArrayList();
        for (NPCCommand nPCCommand : this.commands.values()) {
            if (nPCCommand.hand == Hand.LEFT || nPCCommand.hand == Hand.SHIFT_LEFT || nPCCommand.hand == Hand.BOTH) {
                left.add(nPCCommand);
            }
            if (nPCCommand.hand != Hand.RIGHT && nPCCommand.hand != Hand.SHIFT_RIGHT && nPCCommand.hand != Hand.BOTH) continue;
            right.add(nPCCommand);
        }
        ArrayList outputList = Lists.newArrayList();
        if (this.cost > 0.0) {
            outputList.add("Cost: " + StringHelper.wrap(this.cost));
        }
        if (this.experienceCost > 0) {
            outputList.add("XP cost: " + StringHelper.wrap(this.experienceCost));
        }
        if (left.size() > 0) {
            outputList.add(Messaging.tr("citizens.commands.npc.command.left-hand-header", new Object[0]));
            for (NPCCommand command : left) {
                outputList.add(this.describe(command));
            }
        }
        if (right.size() > 0) {
            outputList.add(Messaging.tr("citizens.commands.npc.command.right-hand-header", new Object[0]));
            for (NPCCommand command : right) {
                outputList.add(this.describe(command));
            }
        }
        if (outputList.isEmpty()) {
            outputList.add(Messaging.tr("citizens.commands.npc.command.none-added", new Object[0]));
        } else {
            outputList.add(0, this.executionMode.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String item : outputList) {
            stringBuilder.append(item);
            stringBuilder.append(" ");
        }
        Messaging.send(sender, stringBuilder.toString().trim());
    }

    private String describe(NPCCommand command) {
        String output = Messaging.tr("citizens.commands.npc.command.describe-format", command.command, StringHelper.wrap(command.cooldown != 0 ? command.cooldown : Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds()), StringHelper.wrap(command.cost > 0.0 ? Double.valueOf(command.cost) : "default"), StringHelper.wrap(command.experienceCost > 0 ? Integer.valueOf(command.experienceCost) : "default"), command.id);
        if (command.globalCooldown > 0) {
            output = output + "[global " + StringHelper.wrap(command.globalCooldown) + "s]";
        }
        if (command.delay > 0) {
            output = output + "[delay " + StringHelper.wrap(command.delay) + "t]";
        }
        if (command.n > 0) {
            output = output + "[" + StringHelper.wrap(command.n) + " uses]";
        }
        if (command.gn > 0) {
            output = output + "[" + StringHelper.wrap(command.gn) + " global uses]";
        }
        if (command.op) {
            output = output + " -o";
        }
        if (command.player) {
            output = output + " -p";
        }
        return output;
    }

    public void dispatch(final Player player, Hand handIn) {
        final Hand hand = player.isSneaking() ? (handIn == Hand.LEFT ? Hand.SHIFT_LEFT : Hand.SHIFT_RIGHT) : handIn;
        NPCCommandDispatchEvent event = new NPCCommandDispatchEvent(this.npc, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        NPCShopAction.Transaction global = this.chargeGlobalCommandCosts(player, hand);
        if (!global.isPossible()) {
            return;
        }
        global.run();
        Runnable task = new Runnable(){
            boolean failedCharge;

            @Override
            public void run() {
                ArrayList commandList = Lists.newArrayList((Iterable)Iterables.filter(CommandTrait.this.commands.values(), command -> command.hand == hand || command.hand == Hand.BOTH));
                if (CommandTrait.this.executionMode == ExecutionMode.RANDOM) {
                    if (commandList.size() > 0) {
                        this.runCommand(player, hand, (NPCCommand)commandList.get(Util.getFastRandom().nextInt(commandList.size())));
                    }
                    return;
                }
                int max = -1;
                if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL || CommandTrait.this.executionMode == ExecutionMode.CYCLE) {
                    commandList.sort(Comparator.comparing(o1 -> o1.id));
                    int n = max = commandList.size() > 0 ? ((NPCCommand)commandList.get((int)(commandList.size() - 1))).id : -1;
                }
                if (CommandTrait.this.executionMode == ExecutionMode.LINEAR) {
                    CommandTrait.this.executionErrors.put(player.getUniqueId().toString(), EnumSet.noneOf(CommandTraitError.class));
                }
                for (NPCCommand command2 : commandList) {
                    PlayerNPCCommand info = null;
                    if (CommandTrait.this.executionMode == ExecutionMode.CYCLE && command2.id <= CommandTrait.this.lastUsedId) {
                        if (CommandTrait.this.lastUsedId != max) continue;
                        CommandTrait.this.lastUsedId = -1;
                    }
                    if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL && (info = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player.getUniqueId())) != null) {
                        if (info.lastUsedHand != hand) {
                            info.lastUsedHand = hand;
                            info.lastUsedId = -1;
                        }
                        if (command2.id <= info.lastUsedId) {
                            if (info.lastUsedId != max) continue;
                            info.lastUsedId = -1;
                        }
                    }
                    this.runCommand(player, hand, command2);
                    if (CommandTrait.this.executionMode != ExecutionMode.SEQUENTIAL && CommandTrait.this.executionMode != ExecutionMode.CYCLE && !this.failedCharge) continue;
                    break;
                }
            }

            private void runCommand(Player player2, Hand hand2, NPCCommand command) {
                Runnable runnable = () -> {
                    PermissionAttachment attachment;
                    PlayerNPCCommand info = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player2.getUniqueId());
                    if (info == null && (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL || PlayerNPCCommand.requiresTracking(command))) {
                        info = new PlayerNPCCommand();
                        CommandTrait.this.playerTracking.put(player2.getUniqueId(), info);
                    }
                    NPCShopAction.Transaction charge = null;
                    if (!this.failedCharge && !(charge = CommandTrait.this.chargeCommandCosts(player2, hand2, command)).isPossible()) {
                        this.failedCharge = true;
                        return;
                    }
                    if (info != null && !info.canUse(CommandTrait.this, player2, hand2, command)) {
                        return;
                    }
                    if (!this.failedCharge) {
                        charge.run();
                    }
                    if (CommandTrait.this.temporaryPermissions.size() > 0 && (attachment = player2.addAttachment(CitizensAPI.getPlugin())) != null) {
                        for (String permission : CommandTrait.this.temporaryPermissions) {
                            attachment.setPermission(permission, true);
                        }
                        command.run(CommandTrait.this.npc, player2);
                        if (CommandTrait.this.temporaryPermissionsDuration <= 0) {
                            attachment.remove();
                        } else {
                            CitizensAPI.getScheduler().runEntityTask((Entity)player2, () -> ((PermissionAttachment)attachment).remove());
                        }
                        return;
                    }
                    command.run(CommandTrait.this.npc, player2);
                };
                if (command.delay <= 0) {
                    runnable.run();
                } else {
                    CitizensAPI.getScheduler().runEntityTaskLater((Entity)player2, runnable, command.delay);
                }
            }
        };
        CitizensAPI.getScheduler().checkedRunEntityTask((Entity)player, task);
    }

    public double getCost() {
        return this.cost;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    private int getNewId() {
        int i = 0;
        while (this.commands.containsKey(i)) {
            ++i;
        }
        return i;
    }

    public boolean hasCommandId(int id) {
        return this.commands.containsKey(id);
    }

    public boolean isHideErrorMessages() {
        return this.hideErrorMessages;
    }

    private boolean nonZeroOrNegativeOne(double value) {
        return Math.abs(value) > 1.0E-4 && Math.abs(-1.0 - value) > 1.0E-4;
    }

    public boolean rememberLastUsed() {
        return this.rememberLastUsed;
    }

    public void removeCommandById(int id) {
        this.commands.remove(id);
    }

    @Override
    public void save(DataKey key) {
        Collection<NPCCommand> commands = this.commands.values();
        Iterator<PlayerNPCCommand> itr = this.playerTracking.values().iterator();
        while (itr.hasNext()) {
            PlayerNPCCommand playerCommand = itr.next();
            playerCommand.pruneCooldowns(this.globalCooldowns, commands);
            if (!playerCommand.lastUsed.isEmpty() || !playerCommand.nUsed.isEmpty() || this.rememberLastUsed && playerCommand.lastUsedId != -1) continue;
            itr.remove();
        }
    }

    private void sendErrorMessage(Player player, CommandTraitError msg, Function<String, String> transform, Object ... objects) {
        if (this.hideErrorMessages) {
            return;
        }
        Set<CommandTraitError> sent = this.executionErrors.get(player.getUniqueId().toString());
        if (sent != null) {
            if (sent.contains((Object)msg)) {
                return;
            }
            sent.add(msg);
        }
        String messageRaw = Placeholders.replace(this.customErrorMessages.getOrDefault((Object)msg, msg.setting.asString()), (CommandSender)player, this.npc);
        if (transform != null) {
            messageRaw = transform.apply(messageRaw);
        }
        if (messageRaw != null && messageRaw.trim().length() > 0) {
            Messaging.send((CommandSender)player, Translator.format(messageRaw, objects));
        }
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setCustomErrorMessage(CommandTraitError which, String message) {
        this.customErrorMessages.put(which, message);
    }

    public void setExecutionMode(ExecutionMode mode) {
        this.executionMode = mode;
    }

    public void setExperienceCost(int experienceCost) {
        this.experienceCost = experienceCost;
    }

    public void setHideErrorMessages(boolean hide) {
        this.hideErrorMessages = hide;
    }

    public void setRememberLastUsed(boolean rememberLastUsed) {
        this.rememberLastUsed = rememberLastUsed;
    }

    public void setTemporaryPermissions(List<String> permissions) {
        this.setTemporaryPermissions(permissions, -1);
    }

    public void setTemporaryPermissions(List<String> permissions, int duration) {
        this.temporaryPermissions.clear();
        this.temporaryPermissions.addAll(permissions);
        this.temporaryPermissionsDuration = duration;
    }

    public static enum CommandTraitError {
        GLOBAL_MAXIMUM_TIMES_USED(Settings.Setting.NPC_COMMAND_GLOBAL_MAXIMUM_TIMES_USED_MESSAGE),
        MAXIMUM_TIMES_USED(Settings.Setting.NPC_COMMAND_MAXIMUM_TIMES_USED_MESSAGE),
        MISSING_EXPERIENCE(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_EXPERIENCE_MESSAGE),
        MISSING_ITEM(Settings.Setting.NPC_COMMAND_MISSING_ITEM_MESSAGE),
        MISSING_MONEY(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_MONEY_MESSAGE),
        NO_PERMISSION(Settings.Setting.NPC_COMMAND_NO_PERMISSION_MESSAGE),
        ON_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_COOLDOWN_MESSAGE),
        ON_GLOBAL_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_GLOBAL_COOLDOWN_MESSAGE);

        private final Settings.Setting setting;

        private CommandTraitError(Settings.Setting setting) {
            this.setting = setting;
        }
    }

    public static enum Hand {
        BOTH,
        LEFT,
        RIGHT,
        SHIFT_LEFT,
        SHIFT_RIGHT;

    }

    private static class NPCCommand {
        String command;
        int cooldown;
        double cost = -1.0;
        int delay;
        int experienceCost = -1;
        int globalCooldown;
        int gn;
        Hand hand;
        int id;
        List<ItemStack> itemCost;
        String key;
        int n;
        boolean npc;
        boolean op;
        List<String> perms;
        boolean player;

        public NPCCommand(int id, String command, Hand hand, boolean player, boolean op, int cooldown, List<String> perms, int n, int gn, int delay, int globalCooldown, double cost, int experienceCost, List<ItemStack> itemCost, boolean npc) {
            this.id = id;
            this.command = command;
            this.hand = hand;
            this.player = player;
            this.op = op;
            this.cooldown = cooldown;
            this.perms = perms;
            this.gn = gn;
            this.n = n;
            this.delay = delay;
            this.globalCooldown = globalCooldown;
            this.cost = cost;
            this.experienceCost = experienceCost;
            this.itemCost = itemCost;
            this.npc = npc;
        }

        public String getEncodedKey() {
            if (this.key != null) {
                return this.key;
            }
            this.key = BaseEncoding.base64().encode(this.command.getBytes());
            return this.key;
        }

        public void run(NPC npc, Player clicker) {
            if (this.npc && npc.getEntity() instanceof Player) {
                clicker = (Player)npc.getEntity();
            }
            Util.runCommand(npc, clicker, this.command, this.op, this.player);
        }
    }

    public static enum ExecutionMode {
        CYCLE,
        LINEAR,
        RANDOM,
        SEQUENTIAL;


        public String toString() {
            return this.name().charAt(0) + this.name().substring(1).toLowerCase(Locale.ROOT);
        }
    }

    public static class NPCCommandBuilder {
        String command;
        int cooldown;
        double cost = -1.0;
        int delay;
        int experienceCost = -1;
        int globalCooldown;
        int gn = -1;
        Hand hand;
        List<ItemStack> itemCost = Lists.newArrayList();
        int n = -1;
        boolean npc;
        boolean op;
        List<String> perms = Lists.newArrayList();
        boolean player;

        public NPCCommandBuilder(String command, Hand hand) {
            this.command = command;
            this.hand = hand;
        }

        public NPCCommandBuilder addPerm(String permission) {
            this.perms.add(permission);
            return this;
        }

        public NPCCommandBuilder addPerms(List<String> perms) {
            this.perms.addAll(perms);
            return this;
        }

        private NPCCommand build(int id) {
            return new NPCCommand(id, this.command, this.hand, this.player, this.op, this.cooldown, this.perms, this.n, this.gn, this.delay, this.globalCooldown, this.cost, this.experienceCost, this.itemCost, this.npc);
        }

        public NPCCommandBuilder command(String command) {
            this.command = command;
            return this;
        }

        public NPCCommandBuilder cooldown(Duration cd) {
            return this.cooldown(Util.convert(TimeUnit.SECONDS, cd));
        }

        public NPCCommandBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public NPCCommandBuilder cost(double cost) {
            this.cost = cost;
            return this;
        }

        public NPCCommandBuilder delay(Duration delay) {
            this.delay = SpigotUtil.toTicks(delay);
            return this;
        }

        public NPCCommandBuilder experienceCost(int experienceCost) {
            this.experienceCost = experienceCost;
            return this;
        }

        public NPCCommandBuilder globalCooldown(Duration cd) {
            return this.globalCooldown(Util.convert(TimeUnit.SECONDS, cd));
        }

        public NPCCommandBuilder globalCooldown(int cooldown) {
            this.globalCooldown = cooldown;
            return this;
        }

        public NPCCommandBuilder globalN(int n) {
            this.gn = n;
            return this;
        }

        public NPCCommandBuilder itemCost(List<ItemStack> itemCost) {
            this.itemCost = itemCost;
            return this;
        }

        public NPCCommandBuilder n(int n) {
            this.n = n;
            return this;
        }

        public NPCCommandBuilder npc(boolean npc) {
            this.npc = npc;
            return this;
        }

        public NPCCommandBuilder op(boolean op) {
            this.op = op;
            return this;
        }

        public NPCCommandBuilder player(boolean player) {
            this.player = player;
            return this;
        }
    }

    private static class PlayerNPCCommand {
        @Persist(valueType=Long.class)
        Map<String, Long> lastUsed = Maps.newHashMap();
        @Persist
        Hand lastUsedHand;
        @Persist
        int lastUsedId = -1;
        @Persist
        Map<String, Integer> nUsed = Maps.newHashMap();

        public boolean canUse(CommandTrait trait, Player player, Hand hand, NPCCommand command) {
            long deadline;
            for (String perm : command.perms) {
                if (player.hasPermission(perm)) continue;
                trait.sendErrorMessage(player, CommandTraitError.NO_PERMISSION, null, new Object[0]);
                return false;
            }
            long globalDelay = Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds();
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            String commandKey = command.getEncodedKey();
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.cooldown") && this.lastUsed.containsKey(commandKey)) {
                deadline = this.lastUsed.get(commandKey) + (command.cooldown != 0 ? (long)command.cooldown : globalDelay);
                if (currentTimeSec < deadline) {
                    long seconds = deadline - currentTimeSec;
                    trait.sendErrorMessage(player, CommandTraitError.ON_COOLDOWN, new TimeVariableFormatter(seconds, TimeUnit.SECONDS), new Object[]{seconds});
                    return false;
                }
                this.lastUsed.remove(commandKey);
            }
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.globalcooldown") && command.globalCooldown > 0 && trait.globalCooldowns.containsKey(commandKey)) {
                deadline = (Long)trait.globalCooldowns.get(commandKey) + (long)command.globalCooldown;
                if (currentTimeSec < deadline) {
                    long seconds = deadline - currentTimeSec;
                    trait.sendErrorMessage(player, CommandTraitError.ON_GLOBAL_COOLDOWN, new TimeVariableFormatter(seconds, TimeUnit.SECONDS), new Object[]{seconds});
                    return false;
                }
                trait.globalCooldowns.remove(commandKey);
            }
            int timesUsed = this.nUsed.getOrDefault(commandKey, 0);
            if (!player.hasPermission("citizens.npc.command.ignoreerrors.nused") && command.n > 0 && command.n <= timesUsed) {
                trait.sendErrorMessage(player, CommandTraitError.MAXIMUM_TIMES_USED, null, new Object[]{command.n});
                return false;
            }
            if (command.cooldown > 0 || globalDelay > 0L) {
                this.lastUsed.put(commandKey, currentTimeSec);
            }
            if (command.globalCooldown > 0) {
                trait.globalCooldowns.put(commandKey, currentTimeSec);
            }
            if (command.n > 0) {
                this.nUsed.put(commandKey, timesUsed + 1);
            }
            if (command.gn > 0) {
                trait.globalUses.put(commandKey, trait.globalUses.getOrDefault(commandKey, 0) + 1);
            }
            this.lastUsedId = command.id;
            this.lastUsedHand = hand;
            return true;
        }

        public void pruneCooldowns(Map<String, Long> globalCooldowns, Collection<NPCCommand> commands) {
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            HashSet encodedCommandKeys = Sets.newHashSet();
            for (NPCCommand command : commands) {
                String commandKey = command.getEncodedKey();
                encodedCommandKeys.add(commandKey);
                Number number = this.lastUsed.get(commandKey);
                if (number != null && number.longValue() + (long)(command.cooldown != 0 ? command.cooldown : Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds()) < currentTimeSec) {
                    this.lastUsed.remove(commandKey);
                }
                if (globalCooldowns == null || (number = (Number)globalCooldowns.get(commandKey)) == null || number.longValue() + (long)command.globalCooldown >= currentTimeSec) continue;
                globalCooldowns.remove(commandKey);
            }
            HashSet diff = Sets.newHashSet(this.lastUsed.keySet());
            diff.removeAll(encodedCommandKeys);
            for (String key : diff) {
                this.lastUsed.remove(key);
                this.nUsed.remove(key);
            }
        }

        public static boolean requiresTracking(NPCCommand command) {
            return command.globalCooldown > 0 || command.cooldown > 0 || command.n > 0 || command.gn > 0 || command.perms != null && command.perms.size() > 0 || Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_COOLDOWN.asSeconds() > 0;
        }
    }

    private static class TimeVariableFormatter
    implements Function<String, String> {
        private final Map<String, String> map = Maps.newHashMapWithExpectedSize((int)5);

        public TimeVariableFormatter(long source, TimeUnit unit) {
            long seconds = TimeUnit.SECONDS.convert(source, unit);
            long minutes = TimeUnit.MINUTES.convert(source, unit);
            long hours = TimeUnit.HOURS.convert(source, unit);
            long days = TimeUnit.DAYS.convert(source, unit);
            this.map.put("seconds", "" + seconds);
            this.map.put("seconds_over", "" + (seconds - TimeUnit.SECONDS.convert(minutes, TimeUnit.MINUTES)));
            this.map.put("minutes", "" + minutes);
            this.map.put("minutes_over", "" + (minutes - TimeUnit.MINUTES.convert(hours, TimeUnit.HOURS)));
            this.map.put("hours", "" + hours);
            this.map.put("hours_over", "" + (hours - TimeUnit.HOURS.convert(days, TimeUnit.DAYS)));
            this.map.put("days", "" + days);
        }

        @Override
        public String apply(String t) {
            return StrSubstitutor.replace((Object)t, this.map, (String)"{", (String)"}");
        }
    }

    private static class NPCCommandPersister
    implements Persister<NPCCommand> {
        @Override
        public NPCCommand create(DataKey root) {
            ArrayList perms = Lists.newArrayList();
            for (DataKey key : root.getRelative("permissions").getIntegerSubKeys()) {
                perms.add(key.getString(""));
            }
            ArrayList items = Lists.newArrayList();
            for (DataKey key : root.getRelative("itemCost").getIntegerSubKeys()) {
                items.add(ItemStorage.loadItemStack(key));
            }
            return new NPCCommand(Integer.parseInt(root.name()), root.getString("command"), Hand.valueOf(root.getString("hand")), root.getBoolean("player", false), root.getBoolean("op", false), root.getInt("cooldown", 0), perms, root.getInt("n", 0), root.getInt("gn", 0), root.getInt("delay", 0), root.getInt("globalcooldown", 0), root.getDouble("cost", -1.0), root.getInt("experienceCost", -1), items, root.getBoolean("npc", false));
        }

        @Override
        public void save(NPCCommand instance, DataKey root) {
            int i;
            root.setString("command", instance.command);
            root.setString("hand", instance.hand.name());
            if (instance.player) {
                root.setBoolean("player", instance.player);
            }
            if (instance.npc) {
                root.setBoolean("npc", instance.npc);
            }
            if (instance.op) {
                root.setBoolean("op", instance.op);
            }
            if (instance.cooldown > 0) {
                root.setInt("cooldown", instance.cooldown);
            }
            if (instance.globalCooldown > 0) {
                root.setInt("globalcooldown", instance.globalCooldown);
            }
            if (instance.n > 0) {
                root.setInt("n", instance.n);
            }
            if (instance.gn > 0) {
                root.setInt("gn", instance.gn);
            }
            if (instance.delay > 0) {
                root.setInt("delay", instance.delay);
            }
            if (instance.cost != -1.0) {
                root.setDouble("cost", instance.cost);
            }
            if (instance.experienceCost != -1) {
                root.setInt("experienceCost", instance.experienceCost);
            }
            root.removeKey("permissions");
            for (i = 0; i < instance.perms.size(); ++i) {
                root.setString("permissions." + i, instance.perms.get(i));
            }
            root.removeKey("itemCost");
            for (i = 0; i < instance.itemCost.size(); ++i) {
                ItemStorage.saveItem(root.getRelative("itemCost." + i), instance.itemCost.get(i));
            }
        }
    }

    @Menu(title="Drag items for requirements", type=InventoryType.CHEST, dimensions={5, 9})
    public static class ItemRequirementGUI
    extends InventoryMenuPage {
        private int id = -1;
        private Inventory inventory;
        private CommandTrait trait;

        private ItemRequirementGUI() {
            throw new UnsupportedOperationException();
        }

        public ItemRequirementGUI(CommandTrait trait) {
            this.trait = trait;
        }

        public ItemRequirementGUI(CommandTrait trait, int id) {
            this.trait = trait;
            this.id = id;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.inventory = ctx.getInventory();
            if (this.id == -1) {
                for (ItemStack stack : this.trait.itemRequirements) {
                    this.inventory.addItem(new ItemStack[]{stack.clone()});
                }
            } else {
                for (ItemStack stack : ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost) {
                    this.inventory.addItem(new ItemStack[]{stack.clone()});
                }
            }
        }

        @Override
        public void onClick(InventoryMenuSlot slot, InventoryClickEvent event) {
            event.setCancelled(false);
        }

        @Override
        public void onClose(HumanEntity player) {
            ArrayList requirements = Lists.newArrayList();
            for (ItemStack stack : this.inventory.getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                requirements.add(stack);
            }
            if (this.id == -1) {
                this.trait.itemRequirements.clear();
                this.trait.itemRequirements.addAll(requirements);
            } else {
                ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost.clear();
                ((NPCCommand)((CommandTrait)this.trait).commands.get((Object)Integer.valueOf((int)this.id))).itemCost.addAll(requirements);
            }
        }
    }
}

