/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;

@TraitName(value="itemdisplaytrait")
public class ItemDisplayTrait
extends Trait
implements Cloneable {
    @Persist
    private ItemDisplay.ItemDisplayTransform transform;

    public ItemDisplayTrait() {
        super("itemdisplaytrait");
    }

    public ItemDisplay.ItemDisplayTransform getTransform() {
        return this.transform;
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getCosmeticEntity() instanceof ItemDisplay)) {
            return;
        }
        ItemDisplay display = (ItemDisplay)this.npc.getCosmeticEntity();
        if (this.transform != null) {
            display.setItemDisplayTransform(this.transform);
        }
    }

    public void setTransform(ItemDisplay.ItemDisplayTransform transform) {
        this.transform = transform;
    }

    @Command(aliases={"npc"}, usage="itemdisplay --transform [transform]", desc="", modifiers={"itemdisplay"}, min=1, max=1, permission="citizens.npc.itemdisplay")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.ITEM_DISPLAY})
    public static void itemdisplay(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"transform"}) ItemDisplay.ItemDisplayTransform transform) throws CommandException {
        ItemDisplayTrait trait = npc.getOrAddTrait(ItemDisplayTrait.class);
        String output = "";
        if (transform != null) {
            trait.setTransform(transform);
        }
        if (npc.isSpawned()) {
            trait.onSpawn();
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output.trim());
        }
    }
}

