/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util.cuboid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.citizensnpcs.api.util.cuboid.BookmarkedResult;
import net.citizensnpcs.api.util.cuboid.Cuboid;
import net.citizensnpcs.api.util.cuboid.QuadNode;

public class QuadTree {
    QuadNode root;

    private void addAndFixListHolders(QuadNode node, Cuboid cuboid) {
        node.cuboids.add(cuboid);
        if (node.cuboids.size() > 1) {
            return;
        }
        ArrayDeque<QuadNode> todo = new ArrayDeque<QuadNode>();
        todo.push(node);
        do {
            QuadNode current = (QuadNode)todo.pop();
            for (QuadNode child : current.quads) {
                if (child == null) continue;
                if (child.cuboids.size() == 0) {
                    todo.push(child);
                }
                child.nextListHolder = node;
            }
        } while (!todo.isEmpty());
    }

    private QuadNode ascendFirstSearch(QuadNode node, int x, int z) {
        while (node != null && (node.x > x || node.z > z || node.x + node.size < x || node.z + node.size < z)) {
            node = node.parent;
        }
        if (node == null) {
            return null;
        }
        return this.descendAndSearch(node, x, z);
    }

    private void beginTree(Cuboid cuboid) {
        int minSizeB;
        int size = 128;
        int minSize = Math.abs(cuboid.lowCoords[0] - cuboid.highCoords[0]);
        if (minSize < (minSizeB = Math.abs(cuboid.lowCoords[2] - cuboid.highCoords[2]))) {
            minSize = minSizeB;
        }
        while (size < minSize) {
            size <<= 1;
        }
        this.root = new QuadNode(cuboid.lowCoords[0], cuboid.lowCoords[2], size - 1, null);
    }

    private int containerFit(QuadNode node, Cuboid cuboid) {
        int minSizeB;
        int minSizeA = Math.abs(cuboid.lowCoords[0] - cuboid.highCoords[0]);
        int fitSize = minSizeA < (minSizeB = Math.abs(cuboid.lowCoords[2] - cuboid.highCoords[2])) ? minSizeB : minSizeA;
        if (node.size < fitSize) {
            return -1;
        }
        if (node.size == 1 || node.size >> 1 < fitSize) {
            return 0;
        }
        return 1;
    }

    private QuadNode descendAndCreate(QuadNode start, Cuboid cuboid) {
        QuadNode next = start;
        while (this.containerFit(next, cuboid) > 0) {
            int i = 0;
            int nX = 0;
            int nZ = 0;
            int half = next.size >> 1;
            if (cuboid.lowCoords[0] > next.x + half) {
                ++i;
                nX = half + 1;
            }
            if (cuboid.lowCoords[2] > next.z + half) {
                i += 2;
                nZ = half + 1;
            }
            if (next.quads[i] == null) {
                next.quads[i] = new QuadNode(next.x + nX, next.z + nZ, half, next);
            }
            next = next.quads[i];
        }
        return next;
    }

    private QuadNode descendAndSearch(QuadNode node, int x, int z) {
        QuadNode next = node;
        while (next != null) {
            node = next;
            int half = node.size >> 1;
            int i = 0;
            if (x > node.x + half) {
                ++i;
            }
            if (z > node.z + half) {
                i += 2;
            }
            next = node.quads[i];
        }
        return node;
    }

    private QuadNode descendNoCreate(QuadNode start, Cuboid cuboid) {
        QuadNode next = start;
        while (this.containerFit(next, cuboid) > 0) {
            int i = 0;
            int nX = 0;
            int nZ = 0;
            int half = next.size >> 1;
            if (cuboid.lowCoords[0] > next.x + half) {
                ++i;
                nX = half + 1;
            }
            if (cuboid.lowCoords[2] > next.z + half) {
                i += 2;
                nZ = half + 1;
            }
            if (next.quads[i] == null) {
                next = new QuadNode(next.x + nX, next.z + nZ, half, next);
                continue;
            }
            next = next.quads[i];
        }
        return next;
    }

    public BookmarkedResult findOverlappingCuboids(int x, int y, int z) {
        return this.relatedSearch(null, x, y, z);
    }

    public BookmarkedResult findOverlappingCuboidsFromBookmark(BookmarkedResult bookmark, int x, int y, int z) {
        return this.relatedSearch(bookmark.bookmark, x, y, z);
    }

    private List<Cuboid> generateShards(QuadNode node, Cuboid cuboid) {
        int tmp;
        ArrayList<Cuboid> shards = new ArrayList<Cuboid>(4);
        int top = node.z + node.size;
        int right = node.x + node.size;
        if (top < cuboid.highCoords[2]) {
            tmp = right < cuboid.highCoords[0] ? right : cuboid.highCoords[0];
            shards.add(new Cuboid(cuboid.lowCoords[0], 0, top + 1, tmp, 0, cuboid.highCoords[2]));
        }
        if (right < cuboid.highCoords[0]) {
            tmp = top < cuboid.highCoords[2] ? top : cuboid.highCoords[2];
            shards.add(new Cuboid(right + 1, 0, cuboid.lowCoords[2], cuboid.highCoords[0], 0, tmp));
        }
        if (right < cuboid.highCoords[0] && top < cuboid.highCoords[2]) {
            shards.add(new Cuboid(right + 1, 0, top + 1, cuboid.highCoords[0], 0, cuboid.highCoords[2]));
        }
        if (shards.size() > 0) {
            shards.add(new Cuboid(cuboid.lowCoords[0], 0, cuboid.lowCoords[2], right, 0, top));
        }
        return shards;
    }

    public List<Cuboid> getAllOverlapsWith(Cuboid cuboid) {
        if (this.root == null) {
            return Collections.emptyList();
        }
        if (!this.nodeFullyContainsCuboid(this.root, cuboid)) {
            this.repotTree(cuboid);
        }
        QuadNode node = this.root;
        node = this.descendNoCreate(node, cuboid);
        List<QuadNode> targets = this.getAllTargetsNoCreate(node, cuboid);
        ArrayDeque<QuadNode> children = new ArrayDeque<QuadNode>();
        HashSet<Cuboid> cuboids = new HashSet<Cuboid>(256);
        for (QuadNode target : targets) {
            children.add(target);
            do {
                QuadNode childTarget = (QuadNode)children.pop();
                for (QuadNode child : childTarget.quads) {
                    if (child == null) continue;
                    children.push(child);
                    cuboids.addAll(child.cuboids);
                }
            } while (!children.isEmpty());
            while (target != null) {
                cuboids.addAll(target.cuboids);
                target = target.nextListHolder;
            }
        }
        ArrayList<Cuboid> overlaps = new ArrayList<Cuboid>();
        for (Cuboid pc : cuboids) {
            if (!cuboid.overlaps(pc)) continue;
            overlaps.add(pc);
        }
        return overlaps;
    }

    private List<QuadNode> getAllTargets(QuadNode initialNode, Cuboid cuboid) {
        ArrayList<QuadNode> targets = new ArrayList<QuadNode>();
        ArrayDeque<Cuboid> shards = new ArrayDeque<Cuboid>();
        shards.addAll(this.generateShards(initialNode, cuboid));
        while (!shards.isEmpty()) {
            Cuboid shard = (Cuboid)shards.pop();
            QuadNode node = this.descendAndCreate(this.root, shard);
            List<Cuboid> newShards = this.generateShards(node, shard);
            if (newShards.size() == 0) {
                targets.add(node);
                continue;
            }
            shards.addAll(newShards);
        }
        if (targets.size() == 0) {
            targets.add(initialNode);
        }
        return targets;
    }

    private List<QuadNode> getAllTargetsNoCreate(QuadNode initialNode, Cuboid cuboid) {
        ArrayList<QuadNode> targets = new ArrayList<QuadNode>();
        ArrayDeque<Cuboid> shards = new ArrayDeque<Cuboid>();
        shards.addAll(this.generateShards(initialNode, cuboid));
        while (!shards.isEmpty()) {
            Cuboid shard = (Cuboid)shards.pop();
            QuadNode node = this.descendNoCreate(this.root, shard);
            List<Cuboid> newShards = this.generateShards(node, shard);
            if (newShards.size() == 0) {
                targets.add(node);
                continue;
            }
            shards.addAll(newShards);
        }
        if (targets.size() == 0) {
            targets.add(initialNode);
        }
        return targets;
    }

    private List<Cuboid> getMatchingCuboids(QuadNode target, int x, int y, int z) {
        ArrayList<Cuboid> matches = new ArrayList<Cuboid>();
        while (target != null) {
            for (Cuboid potential : target.cuboids) {
                if (!potential.includesPoint(x, y, z)) continue;
                matches.add(potential);
            }
            target = target.nextListHolder;
        }
        return matches;
    }

    public void insert(Cuboid cuboid) {
        if (this.root == null) {
            this.beginTree(cuboid);
        }
        if (!this.nodeFullyContainsCuboid(this.root, cuboid)) {
            this.repotTree(cuboid);
        }
        QuadNode node = this.root;
        node = this.descendAndCreate(node, cuboid);
        List<QuadNode> targets = this.getAllTargets(node, cuboid);
        for (QuadNode target : targets) {
            this.addAndFixListHolders(target, cuboid);
        }
    }

    public boolean insertIfNoOverlaps(Cuboid cuboid) {
        if (this.root == null) {
            this.insert(cuboid);
            return true;
        }
        if (!this.nodeFullyContainsCuboid(this.root, cuboid)) {
            this.repotTree(cuboid);
        }
        QuadNode node = this.root;
        node = this.descendAndCreate(node, cuboid);
        List<QuadNode> targets = this.getAllTargets(node, cuboid);
        ArrayDeque<QuadNode> children = new ArrayDeque<QuadNode>();
        HashSet<Cuboid> cuboids = new HashSet<Cuboid>(256);
        for (QuadNode target : targets) {
            children.add(target);
            do {
                QuadNode childTarget = (QuadNode)children.pop();
                for (QuadNode child : childTarget.quads) {
                    if (child == null) continue;
                    children.push(child);
                    cuboids.addAll(child.cuboids);
                }
            } while (!children.isEmpty());
            while (target != null) {
                cuboids.addAll(target.cuboids);
                target = target.nextListHolder;
            }
        }
        for (Cuboid pc : cuboids) {
            if (!cuboid.overlaps(pc)) continue;
            for (QuadNode target : targets) {
                if (target.cuboids.size() != 0) continue;
                this.pruneTree(node);
            }
            return false;
        }
        for (QuadNode target : targets) {
            this.addAndFixListHolders(target, cuboid);
        }
        return true;
    }

    private boolean nodeFullyContainsCuboid(QuadNode node, Cuboid cuboid) {
        return node.x <= cuboid.lowCoords[0] && node.z <= cuboid.lowCoords[2] && node.x + node.size >= cuboid.highCoords[0] && node.z + node.size >= cuboid.highCoords[2];
    }

    public boolean overlapsExisting(Cuboid cuboid) {
        if (this.root == null) {
            return false;
        }
        if (!this.nodeFullyContainsCuboid(this.root, cuboid)) {
            this.repotTree(cuboid);
        }
        QuadNode node = this.root;
        node = this.descendNoCreate(node, cuboid);
        List<QuadNode> targets = this.getAllTargetsNoCreate(node, cuboid);
        ArrayDeque<QuadNode> children = new ArrayDeque<QuadNode>();
        HashSet<Cuboid> cuboids = new HashSet<Cuboid>(256);
        for (QuadNode target : targets) {
            children.add(target);
            do {
                QuadNode childTarget = (QuadNode)children.pop();
                for (QuadNode child : childTarget.quads) {
                    if (child == null) continue;
                    children.push(child);
                    cuboids.addAll(child.cuboids);
                }
            } while (!children.isEmpty());
            while (target != null) {
                cuboids.addAll(target.cuboids);
                target = target.nextListHolder;
            }
        }
        for (Cuboid pc : cuboids) {
            if (!cuboid.overlaps(pc)) continue;
            return true;
        }
        return false;
    }

    private void pruneTree(QuadNode node) {
        while (node.parent != null && node.quads[0] == null && node.quads[1] == null && node.quads[2] == null && node.quads[3] == null) {
            int i = 0;
            if (node.x != node.parent.x) {
                ++i;
            }
            if (node.z != node.parent.z) {
                i += 2;
            }
            node = node.parent;
            node.quads[i] = null;
        }
    }

    private BookmarkedResult relatedSearch(QuadNode bookmark, int x, int y, int z) {
        if (bookmark == null) {
            bookmark = this.root;
        }
        QuadNode node = this.ascendFirstSearch(bookmark, x, z);
        return new BookmarkedResult(node, this.getMatchingCuboids(node, x, y, z));
    }

    public void remove(Cuboid cuboid) {
        if (this.root == null) {
            return;
        }
        QuadNode node = this.descendAndCreate(this.root, cuboid);
        List<QuadNode> targets = this.getAllTargets(node, cuboid);
        for (QuadNode target : targets) {
            this.removeAndFixListHolders(target, cuboid);
        }
    }

    private void removeAndFixListHolders(QuadNode node, Cuboid cuboid) {
        node.cuboids.remove(cuboid);
        if (node.cuboids.size() > 0) {
            return;
        }
        ArrayDeque<QuadNode> todo = new ArrayDeque<QuadNode>();
        todo.push(node);
        do {
            QuadNode current = (QuadNode)todo.pop();
            for (QuadNode child : current.quads) {
                if (child == null) continue;
                if (child.cuboids.size() == 0) {
                    todo.push(child);
                }
                child.nextListHolder = node.nextListHolder;
            }
        } while (!todo.isEmpty());
        this.pruneTree(node);
    }

    private void repotTree(Cuboid cuboid) {
        do {
            QuadNode oldRoot = this.root;
            oldRoot.parent = this.root = new QuadNode(oldRoot.x, oldRoot.z, (oldRoot.size << 1) + 1, null);
            int i = 0;
            if (cuboid.lowCoords[0] < this.root.x) {
                ++i;
                this.root.x -= oldRoot.size + 1;
            }
            if (cuboid.lowCoords[2] < this.root.z) {
                i += 2;
                this.root.z -= oldRoot.size + 1;
            }
            this.root.quads[i] = oldRoot;
        } while (!this.nodeFullyContainsCuboid(this.root, cuboid));
    }

    public List<Cuboid> search(int x, int y, int z) {
        QuadNode node = this.descendAndSearch(this.root, x, z);
        return this.getMatchingCuboids(node, x, y, z);
    }
}

