/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Zombie;
import org.bukkit.util.Vector;

public class CitizensZombieNPC
extends CitizensMobNPC {
    public CitizensZombieNPC(int id, String name) {
        super(id, name, EntityZombieNPC.class);
    }

    public Zombie getBukkitEntity() {
        return (Zombie)super.getBukkitEntity();
    }

    public static class ZombieNPC
    extends CraftZombie
    implements NPCHolder {
        private final CitizensNPC npc;

        public ZombieNPC(EntityZombieNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityZombie)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityZombieNPC
    extends EntityZombie
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityZombieNPC(World world) {
            this(world, null);
        }

        public EntityZombieNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void bb() {
            if (this.npc == null) {
                super.bb();
            }
        }

        public void bc() {
            super.bc();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public Entity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new ZombieNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

