/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.trait.waypoint.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.WaypointTriggerRegistry;
import org.bukkit.Location;

public class Waypoint {
    @Persist(required=true)
    private Location location;
    @Persist
    private List<WaypointTrigger> triggers;

    public Waypoint() {
    }

    public Waypoint(Location at) {
        this.location = at;
    }

    public Location getLocation() {
        return this.location;
    }

    public void onReach(NPC npc) {
        for (WaypointTrigger trigger : this.triggers) {
            trigger.onWaypointReached(npc, this.location);
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(WaypointTrigger.class, WaypointTriggerRegistry.class);
    }
}

