/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.triggers.TriggerAddPrompt;
import net.citizensnpcs.trait.waypoint.triggers.TriggerRemovePrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TriggerEditPrompt
extends StringPrompt {
    private final WaypointEditor editor;

    public TriggerEditPrompt(WaypointEditor editor) {
        this.editor = editor;
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        if ((input = input.toLowerCase().trim()).contains("add")) {
            return new TriggerAddPrompt(this.editor);
        }
        if (input.contains("remove")) {
            return new TriggerRemovePrompt(this.editor);
        }
        return this;
    }

    public String getPromptText(ConversationContext context) {
        context.setSessionData((Object)"previous", (Object)this);
        String base = Messaging.tr("citizens.editors.waypoints.triggers.main.prompt", new Object[0]);
        if (this.editor.getCurrentWaypoint() != null) {
            Waypoint waypoint = this.editor.getCurrentWaypoint();
            for (WaypointTrigger trigger : waypoint.getTriggers()) {
                base = base + "\n    - " + trigger.description();
            }
        }
        Messaging.send((CommandSender)context.getForWhom(), base);
        return "";
    }

    public static Conversation start(Player player, WaypointEditor editor) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).withEscapeSequence("exit").withEscapeSequence("/npc path").withModality(false).withFirstPrompt((Prompt)new TriggerEditPrompt(editor)).buildConversation((Conversable)player);
        conversation.begin();
        return conversation;
    }
}

