/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

public abstract class AbstractNPC
implements NPC {
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    protected final MetadataStore metadata = new SimpleMetadataStore();
    private String name;
    protected final List<Runnable> runnables = Lists.newArrayList();
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();

    protected AbstractNPC(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            System.err.println("[Citizens] Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait.getNPC() == null) {
            trait.linkToNPC(this);
        }
        this.runnables.add(trait);
        if (this.traits.containsKey(trait.getClass())) {
            this.runnables.remove(this.traits.get(trait.getClass()));
        }
        Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        this.traits.put(trait.getClass(), trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove();
        }
        this.traits.clear();
        CitizensAPI.getNPCRegistry().deregister(this);
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        String parsed = this.name;
        for (ChatColor color : ChatColor.values()) {
            if (!parsed.contains("<" + color.getChar() + ">")) continue;
            parsed = parsed.replace("<" + color.getChar() + ">", "");
        }
        return parsed;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)(trait != null ? (Trait)clazz.cast(trait) : null);
    }

    protected abstract Trait getTraitFor(Class<? extends Trait> var1);

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.values();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public void removeTrait(Class<? extends Trait> trait) {
        Trait t = this.traits.remove(trait);
        if (t != null) {
            this.runnables.remove(t);
            HandlerList.unregisterAll((Listener)t);
            t.onRemove();
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }
}

