/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class LocationGoal
implements AStarGoal {
    private final Vector goal;

    public LocationGoal(Vector goal) {
        this.goal = goal;
    }

    @Override
    public float g(AStarNode from, AStarNode to) {
        return ((LocationNode)from).distance((LocationNode)to);
    }

    @Override
    public float getInitialCost(AStarNode node) {
        return ((LocationNode)node).distance(this.goal);
    }

    @Override
    public float h(AStarNode from) {
        return ((LocationNode)from).distance(this.goal);
    }

    @Override
    public boolean isFinished(AStarNode node) {
        return ((LocationNode)node).at(this.goal);
    }

    public static class LocationPlan
    implements Plan {
        @Override
        public int compareTo(Plan o) {
            return 0;
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public void update() {
        }
    }

    public static class LocationNode
    extends AStarNode {
        private final BlockSource blockSource;
        private final Vector location;

        public LocationNode(Vector location, BlockSource source) {
            this.location = location;
            this.blockSource = source;
        }

        public boolean at(Vector goal) {
            return this.distance(goal) < 1.0f;
        }

        @Override
        public Plan buildPlan() {
            Iterable parents = this.getParents();
            for (LocationNode parent : parents) {
                System.err.println(parent.location);
            }
            return null;
        }

        public float distance(LocationNode to) {
            return this.distance(to.location);
        }

        public float distance(Vector goal) {
            return (float)this.location.distanceSquared(goal);
        }

        @Override
        public Iterable<AStarNode> getNeighbours() {
            ArrayList nodes = Lists.newArrayList();
            HashSet mods = Sets.newHashSet();
            for (BlockFace face : BlockFace.values()) {
                Vector mod = this.location.clone().add(new Vector(face.getModX(), face.getModY(), face.getModZ()));
                if (mods.contains(mod) || mod.equals((Object)this.location)) continue;
                mods.add(mod);
                nodes.add(new LocationNode(mod, this.blockSource));
            }
            return nodes;
        }
    }

    public static interface BlockSource {
        public int getBlockTypeIdAt(int var1, int var2, int var3);
    }
}

