/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.LocationPlan;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class LocationNode
extends AStarNode {
    private float blockCost = -1.0f;
    final BlockSource blockSource;
    private final BlockExaminer[] examiners;
    final Vector location;

    public LocationNode(Location location, BlockSource source, BlockExaminer ... examiners) {
        this(location.toVector(), source, examiners);
    }

    private LocationNode(Vector location, BlockSource source, BlockExaminer ... examiners) {
        this.location = location;
        this.blockSource = source;
        this.examiners = examiners == null ? new BlockExaminer[]{} : examiners;
    }

    boolean at(Vector goal) {
        return this.heuristicDistance(goal) < 1.0f;
    }

    @Override
    public Plan buildPlan() {
        Iterable<LocationNode> parents = this.getParents();
        return new LocationPlan(parents);
    }

    public float distance(LocationNode to) {
        return (float)this.location.distanceSquared(to.location);
    }

    private float getBlockCost() {
        if (this.blockCost == -1.0f) {
            this.blockCost = 0.0f;
            for (BlockExaminer examiner : this.examiners) {
                this.blockCost += examiner.getCost(this.blockSource, this.location);
            }
        }
        return this.blockCost;
    }

    @Override
    public Iterable<AStarNode> getNeighbours() {
        ArrayList nodes = Lists.newArrayList();
        for (BlockFace face : BlockFace.values()) {
            Vector mod = this.location.clone().add(new Vector(face.getModX(), face.getModY(), face.getModZ()));
            if (mod.equals((Object)this.location) || !this.isPassable(mod)) continue;
            nodes.add(this.getNewNode(mod));
        }
        return nodes;
    }

    private AStarNode getNewNode(Vector mod) {
        return new LocationNode(mod, this.blockSource, this.examiners);
    }

    public float heuristicDistance(Vector goal) {
        return (float)this.location.distanceSquared(goal) + this.getBlockCost();
    }

    private boolean isPassable(Vector mod) {
        for (BlockExaminer examiner : this.examiners) {
            if (examiner.isPassable(this.blockSource, mod)) continue;
            return false;
        }
        return true;
    }
}

