/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.LocationNode;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class LocationPlan
implements Plan {
    private int index = 0;
    private final Vector[] path;

    public LocationPlan(Iterable<LocationNode> unfiltered) {
        this.path = this.cull(unfiltered);
    }

    private Vector[] cull(Iterable<LocationNode> unfiltered) {
        ArrayList path = Lists.newArrayList();
        Vector last = null;
        for (LocationNode node : unfiltered) {
            Vector vector = node.location;
            if (last != null && vector.getBlockY() == last.getBlockY() && node.blockSource.getMaterialAt(vector) == Material.AIR && node.blockSource.getMaterialAt(last) == Material.AIR) continue;
            last = vector;
            path.add(vector);
        }
        return path.toArray(new Vector[path.size()]);
    }

    public Vector getCurrentVector() {
        return this.path[this.index];
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    @Override
    public void update() {
        ++this.index;
    }
}

