/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private int index = 0;
    private final PathEntry[] path;

    Path(Iterable<VectorNode> unfiltered) {
        this.path = this.cull(unfiltered);
    }

    private PathEntry[] cull(Iterable<VectorNode> unfiltered) {
        ArrayList path = Lists.newArrayList();
        Vector last = null;
        for (VectorNode node : unfiltered) {
            if (node.callbacks != null) continue;
            Vector vector = node.location;
            if (last != null && vector.getBlockY() == last.getBlockY() && node.blockSource.getMaterialAt(vector) == Material.AIR && node.blockSource.getMaterialAt(last) == Material.AIR) continue;
            last = vector;
            path.add(new PathEntry(vector, node.callbacks));
        }
        return path.toArray(new PathEntry[path.size()]);
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        PathEntry entry = this.path[this.index];
        if (entry.hasCallbacks()) {
            NPC npc = (NPC)agent;
            Block block = entry.getBlockUsingWorld(npc.getBukkitEntity().getWorld());
            for (PathPoint.PathCallback callback : entry.callbacks) {
                callback.run(npc, block);
            }
        }
        ++this.index;
    }

    private static class PathEntry {
        final Iterable<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> callbacks) {
            this.vector = vector;
            this.callbacks = callbacks;
        }

        private Block getBlockUsingWorld(World world) {
            return world.getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
        }

        private boolean hasCallbacks() {
            return this.callbacks != null;
        }
    }
}

