/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.command.SelectionPrompt;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.npc.Template;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.Behaviour;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.NPCSkeletonType;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.ZombieModifier;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Paginator;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
    private final NPCSelector selector;

    public NPCCommands(Citizens plugin) {
        this.selector = plugin.getNPCSelector();
    }

    @Command(aliases={"npc"}, usage="age [age] (-l)", desc="Set the age of a NPC", help="citizens.commands.npc.age.help", flags="l", modifiers={"age"}, min=1, max=2, permission="npc.age")
    @Requirements(selected=true, ownership=true, types={EntityType.CHICKEN, EntityType.COW, EntityType.OCELOT, EntityType.PIG, EntityType.SHEEP, EntityType.VILLAGER, EntityType.WOLF})
    public void age(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Age trait = npc.getTrait(Age.class);
        boolean toggleLock = args.hasFlag('l');
        if (toggleLock) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.age.locked" : "citizens.commands.npc.age.unlocked", new Object[0]);
        }
        if (args.argsLength() <= 1) {
            if (!toggleLock) {
                trait.describe(sender);
            }
            return;
        }
        int age = 0;
        try {
            age = args.getInteger(1);
            if (age < -24000 || age > 0) {
                throw new CommandException("citizens.commands.npc.age.invalid-age");
            }
            Messaging.sendTr(sender, "citizens.commands.npc.age.set-normal", npc.getName(), age);
        }
        catch (NumberFormatException ex) {
            if (args.getString(1).equalsIgnoreCase("baby")) {
                age = -24000;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-baby", npc.getName());
            }
            if (args.getString(1).equalsIgnoreCase("adult")) {
                age = 0;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-adult", npc.getName());
            }
            throw new CommandException("citizens.commands.npc.age.invalid-age");
        }
        trait.setAge(age);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="anchor (--save [name]|--assume [name]|--remove [name]) (-a)", desc="Changes/Saves/Lists NPC's location anchor(s)", flags="a", modifiers={"anchor"}, min=1, max=2, permission="npc.anchor")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void anchor(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Anchors trait = npc.getTrait(Anchors.class);
        if (args.hasValueFlag("save")) {
            if (args.getFlag("save").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addAnchor(args.getFlag("save"), args.getSenderLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", args.getFlag("save"));
            Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
        } else if (args.hasValueFlag("assume")) {
            if (args.getFlag("assume").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            Anchor anchor = trait.getAnchor(args.getFlag("assume"));
            if (anchor == null) {
                throw new CommandException("citizens.commands.npc.anchor.missing", args.getFlag("assume"));
            }
            npc.getBukkitEntity().teleport(anchor.getLocation());
        } else if (args.hasValueFlag("remove")) {
            if (args.getFlag("remove").isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (!trait.removeAnchor(trait.getAnchor(args.getFlag("remove")))) throw new CommandException("citizens.commands.npc.anchor.missing", args.getFlag("remove"));
            Messaging.sendTr(sender, "citizens.commands.npc.anchor.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            Paginator paginator = new Paginator().header("Anchors");
            paginator.addLine("<e>Key: <a>ID  <b>Name  <c>World  <d>Location (X,Y,Z)");
            for (int i = 0; i < trait.getAnchors().size(); ++i) {
                String line = "<a>" + i + "<b>  " + trait.getAnchors().get(i).getName() + "<c>  " + trait.getAnchors().get(i).getLocation().getWorld().getName() + "<d>  " + trait.getAnchors().get(i).getLocation().getBlockX() + ", " + trait.getAnchors().get(i).getLocation().getBlockY() + ", " + trait.getAnchors().get(i).getLocation().getBlockZ();
                paginator.addLine(line);
            }
            int page = args.getInteger(1, 1);
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing");
            }
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        npc.getBukkitEntity().teleport(args.getSenderLocation());
    }

    @Command(aliases={"npc"}, usage="behaviour [scripts] (-r)", desc="Sets the behaviour of a NPC", help="citizens.commands.npc.behaviour.help", modifiers={"behaviour", "behavior", "ai"}, flags="r", min=2, permission="npc.behaviour")
    public void behaviour(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Iterable files = Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(1, ','));
        if (args.hasFlag('r')) {
            npc.getTrait(Behaviour.class).removeScripts(files);
            Messaging.sendTr(sender, "citizens.commands.npc.behaviour.removed", new Object[0]);
        } else {
            npc.getTrait(Behaviour.class).addScripts(files);
            Messaging.sendTr(sender, "citizens.commands.npc.behaviour.added", new Object[0]);
        }
    }

    @Command(aliases={"npc"}, usage="controllable|control -f", desc="Toggles whether the NPC can be ridden and controlled", modifiers={"controllable", "control"}, min=1, max=1, flags="f")
    public void controllable(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc.isSpawned() && !sender.hasPermission("citizens.npc.controllable." + npc.getBukkitEntity().getType().toString().toLowerCase()) || !sender.hasPermission("citizens.npc.controllable")) {
            throw new NoPermissionsException();
        }
        Controllable trait = npc.getTrait(Controllable.class);
        boolean enabled = trait.toggle();
        String key = enabled ? "citizens.commands.npc.controllable.set" : "citizens.commands.npc.controllable.removed";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="copy (--name newname)", desc="Copies an NPC", modifiers={"copy"}, min=1, max=1, permission="npc.copy")
    public void copy(CommandContext args, CommandSender sender, NPC npc) {
        EntityType type = npc.getTrait(MobType.class).getType();
        String name = args.getFlag("name", npc.getFullName());
        CitizensNPC copy = (CitizensNPC)this.npcRegistry.createNPC(type, name);
        CitizensNPC from = (CitizensNPC)npc;
        MemoryDataKey key = new MemoryDataKey();
        from.save(key);
        copy.load(key);
        if (copy.isSpawned() && args.getSenderLocation() != null) {
            Location location = args.getSenderLocation();
            copy.getBukkitEntity().teleport(location);
            copy.getTrait(CurrentLocation.class).setLocation(location);
        }
        for (Trait trait : copy.getTraits()) {
            trait.onCopy();
        }
        Messaging.sendTr(sender, "citizens.commands.npc.copy.copied", npc.getName());
        this.selector.select(sender, copy);
    }

    @Command(aliases={"npc"}, usage="create [name] ((-b,u) --at (x:y:z:world) --type (type) --trait ('trait1, trait2...') --b (behaviours))", desc="Create a new NPC", flags="bu", modifiers={"create"}, min=2, permission="npc.create")
    @Requirements
    public void create(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        StringBuilder builder;
        Object parts;
        String name = StringHelper.parseColors(args.getJoinedStrings(1));
        if (name.length() > 16) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", new Object[0]);
            name = name.substring(0, 15);
        }
        EntityType type = EntityType.PLAYER;
        if (args.hasValueFlag("type")) {
            String inputType = args.getFlag("type");
            type = Util.matchEntityType(inputType);
            if (type == null) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.create.invalid-mobtype", inputType);
                type = EntityType.PLAYER;
            } else if (!LivingEntity.class.isAssignableFrom(type.getEntityClass())) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.create.not-living-mobtype", type);
                type = EntityType.PLAYER;
            }
        }
        npc = this.npcRegistry.createNPC(type, name);
        String msg = "You created [[" + npc.getName() + "]]";
        int age = 0;
        if (args.hasFlag('b')) {
            if (!Ageable.class.isAssignableFrom(type.getEntityClass())) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.age.cannot-be-aged", type.name().toLowerCase().replace("_", "-"));
            } else {
                age = -24000;
                msg = msg + " as a baby";
            }
        }
        if (args.hasValueFlag("b") || args.hasValueFlag("behaviours") || args.hasValueFlag("behaviors")) {
            String behaviours = args.getFlag("b", args.getFlag("behaviours", args.getFlag("behaviors")));
            npc.getTrait(Behaviour.class).addScripts(Splitter.on((char)',').split((CharSequence)behaviours));
            msg = msg + " with the specified behaviours";
        }
        msg = msg + ".";
        if (!Settings.Setting.SERVER_OWNS_NPCS.asBoolean()) {
            npc.getTrait(Owner.class).setOwner(sender.getName());
        }
        npc.getTrait(MobType.class).setType(type);
        Location spawnLoc = null;
        if (sender instanceof Player) {
            spawnLoc = args.getSenderLocation();
            PlayerCreateNPCEvent event = new PlayerCreateNPCEvent((Player)sender, npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                npc.destroy();
                String reason = "Couldn't create NPC.";
                if (!event.getCancelReason().isEmpty()) {
                    reason = reason + " Reason: " + event.getCancelReason();
                }
                throw new CommandException(reason);
            }
        } else if (sender instanceof BlockCommandSender) {
            spawnLoc = args.getSenderLocation();
        }
        if (args.hasValueFlag("at")) {
            parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)args.getFlag("at")), String.class);
            if (((String[])parts).length > 0) {
                Object worldName = args.getSenderLocation() != null ? args.getSenderLocation().getWorld().getName() : "";
                int x = 0;
                int y = 0;
                int z = 0;
                float yaw = 0.0f;
                float pitch = 0.0f;
                switch (((Object)parts).length) {
                    case 6: {
                        pitch = Float.parseFloat((String)parts[5]);
                    }
                    case 5: {
                        yaw = Float.parseFloat((String)parts[4]);
                    }
                    case 4: {
                        worldName = parts[3];
                    }
                    case 3: {
                        x = Integer.parseInt((String)parts[0]);
                        y = Integer.parseInt((String)parts[1]);
                        z = Integer.parseInt((String)parts[2]);
                        break;
                    }
                    default: {
                        throw new CommandException("citizens.commands.npc.create.invalid-location");
                    }
                }
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    throw new CommandException("citizens.commands.npc.create.invalid-location");
                }
                spawnLoc = new Location(world, (double)x, (double)y, (double)z, yaw, pitch);
            } else {
                Player search = Bukkit.getPlayerExact((String)args.getFlag("at"));
                if (search == null) {
                    throw new CommandException("citizens.commands.npc.create.no-player-for-spawn");
                }
                spawnLoc = search.getLocation();
            }
        }
        if (spawnLoc == null) {
            npc.destroy();
            throw new CommandException("citizens.commands.npc.create.invalid-location");
        }
        if (!args.hasFlag('u')) {
            npc.spawn(spawnLoc);
        }
        if (args.hasValueFlag("trait")) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)args.getFlag("trait"));
            builder = new StringBuilder();
            Iterator i$ = parts.iterator();
            while (i$.hasNext()) {
                String tr = (String)i$.next();
                Object trait = CitizensAPI.getTraitFactory().getTrait(tr);
                if (trait == null) continue;
                npc.addTrait((Trait)trait);
                builder.append(StringHelper.wrap(tr) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with traits " + builder.toString();
        }
        if (args.hasValueFlag("template")) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)args.getFlag("template"));
            builder = new StringBuilder();
            Iterator i$ = parts.iterator();
            while (i$.hasNext()) {
                String part = (String)i$.next();
                Template template = Template.byName(part);
                if (template == null) continue;
                template.apply(npc);
                builder.append(StringHelper.wrap(part) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with templates " + builder.toString();
        }
        if (npc.getBukkitEntity() instanceof Ageable) {
            npc.getTrait(Age.class).setAge(age);
        }
        this.selector.select(sender, npc);
        Messaging.send(sender, msg);
    }

    @Command(aliases={"npc"}, usage="despawn (id)", desc="Despawn a NPC", modifiers={"despawn"}, min=1, max=2, permission="npc.despawn")
    @Requirements
    public void despawn(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (npc == null || args.argsLength() == 2) {
            if (args.argsLength() < 2) {
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            int id = args.getInteger(1);
            npc = CitizensAPI.getNPCRegistry().getById(id);
            if (npc == null) {
                throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", id);
            }
        }
        npc.getTrait(Spawned.class).setSpawned(false);
        npc.despawn();
        Messaging.sendTr(sender, "citizens.commands.npc.despawn.despawned", npc.getName());
    }

    @Command(aliases={"npc"}, usage="gamemode [gamemode]", desc="Changes the gamemode", modifiers={"gravity"}, min=1, max=2, permission="npc.gravity")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void gamemode(CommandContext args, CommandSender sender, NPC npc) {
        Player player = (Player)npc.getBukkitEntity();
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.gamemode.describe", npc.getName(), player.getGameMode().name().toLowerCase());
            return;
        }
        GameMode mode = null;
        try {
            int value = args.getInteger(1);
            mode = GameMode.getByValue((int)value);
        }
        catch (NumberFormatException ex) {
            try {
                mode = GameMode.valueOf((String)args.getString(1));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (mode == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.gamemode.invalid", args.getString(1));
            return;
        }
        player.setGameMode(mode);
        Messaging.sendTr(sender, "citizens.commands.npc.gamemode.set", mode.name().toLowerCase());
    }

    @Command(aliases={"npc"}, usage="gravity", desc="Toggles gravity", modifiers={"gravity"}, min=1, max=1, permission="npc.gravity")
    public void gravity(CommandContext args, CommandSender sender, NPC npc) {
        boolean enabled = npc.getTrait(Gravity.class).toggle();
        String key = enabled ? "citizens.commands.npc.gravity.enabled" : "citizens.commands.npc.gravity.disabled";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char))", desc="List NPCs", flags="a", modifiers={"list"}, min=1, max=2, permission="npc.list")
    @Requirements
    public void list(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        if (args.hasFlag('a')) {
            for (NPC add : this.npcRegistry) {
                npcs.add(add);
            }
        } else if (args.getValueFlags().size() == 0 && sender instanceof Player) {
            for (NPC add : this.npcRegistry) {
                if (npcs.contains(add) || !add.getTrait(Owner.class).isOwnedBy(sender)) continue;
                npcs.add(add);
            }
        } else {
            if (args.hasValueFlag("owner")) {
                String name = args.getFlag("owner");
                for (NPC add : this.npcRegistry) {
                    if (npcs.contains(add) || !add.getTrait(Owner.class).isOwnedBy(name)) continue;
                    npcs.add(add);
                }
            }
            if (args.hasValueFlag("type")) {
                EntityType type = Util.matchEntityType(args.getFlag("type"));
                if (type == null) {
                    throw new CommandException("citizens.commands.invalid-mobtype", type);
                }
                for (NPC add : this.npcRegistry) {
                    if (npcs.contains(add) || add.getTrait(MobType.class).getType() != type) continue;
                    npcs.add(add);
                }
            }
        }
        Paginator paginator = new Paginator().header("NPCs");
        paginator.addLine("<e>Key: <a>ID  <b>Name");
        for (int i = 0; i < npcs.size(); i += 2) {
            String line = "<a>" + ((NPC)npcs.get(i)).getId() + "<b>  " + ((NPC)npcs.get(i)).getName();
            if (npcs.size() >= i + 2) {
                line = line + "      <a>" + ((NPC)npcs.get(i + 1)).getId() + "<b>  " + ((NPC)npcs.get(i + 1)).getName();
            }
            paginator.addLine(line);
        }
        int page = args.getInteger(1, 1);
        if (!paginator.sendPage(sender, page)) {
            throw new CommandException("citizens.commands.page-missing");
        }
    }

    @Command(aliases={"npc"}, usage="lookclose", desc="Toggle whether a NPC will look when a player is near", modifiers={"lookclose", "look", "rotate"}, min=1, max=1, permission="npc.lookclose")
    public void lookClose(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, npc.getTrait(LookClose.class).toggle() ? "citizens.commands.npc.lookclose.set" : "citizens.commands.npc.lookclose.stopped", npc.getName());
    }

    @Command(aliases={"npc"}, usage="mount", desc="Mounts a controllable NPC", modifiers={"mount"}, min=1, max=1, permission="npc.controllable")
    public void mount(CommandContext args, Player player, NPC npc) {
        boolean enabled;
        boolean bl = enabled = npc.hasTrait(Controllable.class) && npc.getTrait(Controllable.class).isEnabled();
        if (!enabled) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.controllable.not-controllable", npc.getName());
            return;
        }
        boolean success = npc.getTrait(Controllable.class).mount(player);
        if (!success) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.mount.failed", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="moveto x:y:z:world | x y z world", desc="Teleports a NPC to a given location", modifiers={"moveto"}, min=1, permission="npc.moveto")
    public void moveto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to;
        if (!npc.isSpawned()) {
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        Location current = npc.getBukkitEntity().getLocation();
        if (args.argsLength() > 1) {
            World world;
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)args.getJoinedStrings(1, ':')), String.class);
            if (parts.length != 4 && parts.length != 3) {
                throw new CommandException("citizens.commands.npc.moveto.format");
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            World world2 = world = parts.length == 4 ? Bukkit.getWorld((String)parts[3]) : current.getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            to = new Location(world, x, y, z, current.getYaw(), current.getPitch());
        } else {
            to = current.clone();
            if (args.hasValueFlag("x")) {
                to.setX(args.getFlagDouble("x"));
            }
            if (args.hasValueFlag("y")) {
                to.setY(args.getFlagDouble("y"));
            }
            if (args.hasValueFlag("z")) {
                to.setZ(args.getFlagDouble("z"));
            }
            if (args.hasValueFlag("yaw")) {
                to.setYaw((float)args.getFlagDouble("yaw"));
            }
            if (args.hasValueFlag("pitch")) {
                to.setPitch((float)args.getFlagDouble("pitch"));
            }
            if (args.hasValueFlag("world")) {
                World world = Bukkit.getWorld((String)args.getFlag("world"));
                if (world == null) {
                    throw new CommandException("citizens.commands.errors.missing-world");
                }
                to.setWorld(world);
            }
        }
        npc.getBukkitEntity().teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr(sender, "citizens.commands.npc.moveto.teleported", npc.getName(), to);
    }

    @Command(aliases={"npc"}, desc="Show basic NPC information", max=0, permission="npc.info")
    public void npc(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, StringHelper.wrapHeader(npc.getName()));
        Messaging.send(sender, "    <a>ID: <e>" + npc.getId());
        Messaging.send(sender, "    <a>Type: <e>" + npc.getTrait(MobType.class).getType());
        if (npc.isSpawned()) {
            Location loc = npc.getBukkitEntity().getLocation();
            String format = "    <a>Spawned at <e>%d, %d, %d <a>in world<e> %s";
            Messaging.send(sender, String.format(format, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName()));
        }
        Messaging.send(sender, "    <a>Traits<e>");
        for (Trait trait : npc.getTraits()) {
            if (CitizensAPI.getTraitFactory().isInternalTrait(trait)) continue;
            String message = "     <e>- <a>" + trait.getName();
            Messaging.send(sender, message);
        }
    }

    @Command(aliases={"npc"}, usage="owner [name]", desc="Set the owner of an NPC", modifiers={"owner"}, min=1, max=2, permission="npc.owner")
    public void owner(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Owner ownerTrait = npc.getTrait(Owner.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.owner.owner", npc.getName(), ownerTrait.getOwner());
            return;
        }
        String name = args.getString(1);
        if (ownerTrait.isOwnedBy(name)) {
            throw new CommandException("citizens.commands.npc.owner.already-owner", name, npc.getName());
        }
        ownerTrait.setOwner(name);
        boolean serverOwner = name.equalsIgnoreCase("server");
        Messaging.sendTr(sender, serverOwner ? "citizens.commands.npc.owner.set-server" : "citizens.commands.npc.owner.set", npc.getName(), name);
    }

    @Command(aliases={"npc"}, usage="pathrange [range]", desc="Sets an NPC's pathfinding range", modifiers={"pathrange", "pathfindingrange", "prange"}, min=2, max=2, permission="npc.pathfindingrange")
    public void pathfindingRange(CommandContext args, CommandSender sender, NPC npc) {
        double range = Math.max(1.0, args.getDouble(1));
        npc.getNavigator().getDefaultParameters().range((float)range);
        Messaging.sendTr(sender, "citizens.commands.npc.pathfindingrange.set", range);
    }

    @Command(aliases={"npc"}, usage="playerlist (-a,r)", desc="Sets whether the NPC is put in the playerlist", modifiers={"playerlist"}, min=1, max=1, flags="ar", permission="npc.playerlist")
    @Requirements(types={EntityType.PLAYER})
    public void playerlist(CommandContext args, CommandSender sender, NPC npc) {
        boolean remove;
        boolean bl = remove = npc.data().get("removefromplayerlist", Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()) == false;
        if (args.hasFlag('a')) {
            remove = false;
        } else if (args.hasFlag('r')) {
            remove = true;
        }
        npc.data().setPersistent("removefromplayerlist", remove);
        if (npc.isSpawned()) {
            NMS.addOrRemoveFromPlayerList(npc.getBukkitEntity(), remove);
        }
        Messaging.sendTr(sender, remove ? "citizens.commands.npc.playerlist.removed" : "citizens.commands.npc.playerlist.added", npc.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pose (--save [name]|--assume [name]|--remove [name]) (-a)", desc="Changes/Saves/Lists NPC's head pose(s)", flags="a", modifiers={"pose"}, min=1, max=2, permission="npc.pose")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void pose(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Poses trait = npc.getTrait(Poses.class);
        if (args.hasValueFlag("save")) {
            if (args.getFlag("save").isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addPose(args.getFlag("save"), args.getSenderLocation())) throw new CommandException("citizens.commands.npc.pose.already-exists", args.getFlag("assume"));
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (args.hasValueFlag("assume")) {
            String pose = args.getFlag("assume");
            if (pose.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.hasPose(pose)) {
                throw new CommandException("citizens.commands.npc.pose.missing", pose);
            }
            trait.assumePose(pose);
        } else if (args.hasValueFlag("remove")) {
            if (args.getFlag("remove").isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.removePose(args.getFlag("remove"))) throw new CommandException("citizens.commands.npc.pose.missing", args.getFlag("remove"));
            Messaging.sendTr(sender, "citizens.commands.npc.pose.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            trait.describe(sender, args.getInteger(1, 1));
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        Location location = args.getSenderLocation();
        trait.assumePose(location);
    }

    @Command(aliases={"npc"}, usage="power", desc="Toggle a creeper NPC as powered", modifiers={"power"}, min=1, max=1, permission="npc.power")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.sendTr(sender, npc.getTrait(Powered.class).toggle() ? "citizens.commands.npc.powered.set" : "citizens.commands.npc.powered.stopped", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="profession|prof [profession]", desc="Set a NPC's profession", modifiers={"profession", "prof"}, min=2, max=2, permission="npc.profession")
    @Requirements(selected=true, ownership=true, types={EntityType.VILLAGER})
    public void profession(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Villager.Profession parsed;
        String profession = args.getString(1);
        try {
            parsed = Villager.Profession.valueOf((String)profession.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new CommandException("citizens.commands.npc.profession.invalid-profession");
        }
        npc.getTrait(VillagerProfession.class).setProfession(parsed);
        Messaging.sendTr(sender, "citizens.commands.npc.profession.set", npc.getName(), profession);
    }

    @Command(aliases={"npc"}, usage="remove|rem (all)", desc="Remove a NPC", modifiers={"remove", "rem"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.argsLength() == 2) {
            if (!args.getString(1).equalsIgnoreCase("all")) {
                throw new CommandException("citizens.commands.npc.remove.incorrect-syntax");
            }
            if (!sender.hasPermission("citizens.admin.remove.all") && !sender.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            this.npcRegistry.deregisterAll();
            Messaging.sendTr(sender, "citizens.commands.npc.remove.removed-all", new Object[0]);
            return;
        }
        if (!(sender instanceof Player)) {
            throw new CommandException("citizens.commands.requirements.must-be-ingame");
        }
        Player player = (Player)sender;
        if (npc == null) {
            throw new CommandException("citizens.commands.requirements.must-have-selected");
        }
        if (!npc.getTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            throw new CommandException("citizens.commands.requirements.must-be-owner");
        }
        if (!player.hasPermission("citizens.npc.remove") && !player.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        npc.destroy();
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.remove.removed", npc.getName());
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="Rename a NPC", modifiers={"rename"}, min=2, permission="npc.rename")
    public void rename(CommandContext args, CommandSender sender, NPC npc) {
        String oldName = npc.getName();
        String newName = args.getJoinedStrings(1);
        if (newName.length() > 16) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", new Object[0]);
            newName = newName.substring(0, 15);
        }
        Location prev = npc.isSpawned() ? npc.getBukkitEntity().getLocation() : null;
        npc.despawn();
        npc.setName(newName);
        if (prev != null) {
            npc.spawn(prev);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.rename.renamed", oldName, newName);
    }

    /*
     * Unable to fully structure code
     */
    @Command(aliases={"npc"}, usage="select|sel [id|name] (--r range)", desc="Select a NPC with the given ID or name", modifiers={"select", "sel"}, min=1, max=2, permission="npc.select")
    @Requirements
    public void select(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        toSelect = null;
        if (args.argsLength() <= 1) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            range = Math.abs(args.getFlagDouble("r", 10.0));
            player = (Player)sender;
            location = args.getSenderLocation();
            search = player.getNearbyEntities(range, range, range);
            Collections.sort(search, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    double d = o1.getLocation().distanceSquared(location) - o2.getLocation().distanceSquared(location);
                    return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                }
            });
            for (Entity possibleNPC : search) {
                test = this.npcRegistry.getNPC(possibleNPC);
                if (test == null) continue;
                toSelect = test;
                break;
            }
        } else {
            try {
                id = args.getInteger(1);
                toSelect = this.npcRegistry.getById(id);
            }
            catch (NumberFormatException ex) {
                name = args.getString(1);
                possible = Lists.newArrayList();
                for (NPC test : this.npcRegistry) {
                    if (!test.getName().equalsIgnoreCase(name)) continue;
                    possible.add(test);
                }
                if (possible.size() == 1) {
                    toSelect = (NPC)possible.get(0);
                }
                if (possible.size() <= 1) ** GOTO lbl34
                SelectionPrompt.start(this.selector, (Player)sender, possible);
                return;
            }
        }
        if (toSelect == null || !toSelect.getTrait(Spawned.class).shouldSpawn()) {
            throw new CommandException("citizens.notifications.npc-not-found");
        }
        if (npc != null && toSelect.getId() == npc.getId()) {
            throw new CommandException("citizens.commands.npc.select.already-selected");
        }
        this.selector.select(sender, toSelect);
        Messaging.sendWithNPC(sender, Settings.Setting.SELECTION_MESSAGE.asString(), toSelect);
    }

    @Command(aliases={"npc"}, usage="skeletontype [type]", desc="Sets the NPC's skeleton type", modifiers={"skeletontype", "sktype"}, min=2, max=2, permission="npc.skeletontype")
    @Requirements(selected=true, ownership=true, types={EntityType.SKELETON})
    public void skeletonType(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Skeleton.SkeletonType type = Skeleton.SkeletonType.getType((int)args.getInteger(1));
        Skeleton.SkeletonType skeletonType = type = type == null ? Skeleton.SkeletonType.valueOf((String)args.getString(1)) : type;
        if (type == null) {
            throw new CommandException("citizens.commands.npc.skeletontype.invalid-type");
        }
        npc.getTrait(NPCSkeletonType.class).setType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.skeletontype.set", npc.getName(), type);
    }

    @Command(aliases={"npc"}, usage="size [size]", desc="Sets the NPC's size", modifiers={"size"}, min=1, max=2, permission="npc.size")
    @Requirements(selected=true, ownership=true, types={EntityType.MAGMA_CUBE, EntityType.SLIME})
    public void slimeSize(CommandContext args, CommandSender sender, NPC npc) {
        SlimeSize trait = npc.getTrait(SlimeSize.class);
        if (args.argsLength() <= 1) {
            trait.describe(sender);
            return;
        }
        int size = Math.max(1, args.getInteger(1));
        trait.setSize(size);
        Messaging.sendTr(sender, "citizens.commands.npc.size.set", npc.getName(), size);
    }

    @Command(aliases={"npc"}, usage="spawn [id]", desc="Spawn an existing NPC", modifiers={"spawn"}, min=2, max=2, permission="npc.spawn")
    @Requirements(ownership=true)
    public void spawn(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        NPC respawn = this.npcRegistry.getById(args.getInteger(1));
        if (respawn == null) {
            throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getInteger(1));
        }
        if (respawn.isSpawned()) {
            throw new CommandException("citizens.commands.npc.spawn.already-spawned", respawn.getName());
        }
        Location location = respawn.getTrait(CurrentLocation.class).getLocation();
        if (location == null) {
            if (args.getSenderLocation() == null) {
                throw new CommandException("citizens.commands.npc.spawn.no-location");
            }
            location = args.getSenderLocation();
        }
        if (respawn.spawn(location)) {
            this.selector.select(sender, respawn);
            Messaging.sendTr(sender, "citizens.commands.npc.spawn.spawned", respawn.getName());
        }
    }

    @Command(aliases={"npc"}, usage="speed [speed]", desc="Sets the movement speed of an NPC as a percentage", modifiers={"speed"}, min=2, max=2, permission="npc.speed")
    public void speed(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        float newSpeed = (float)Math.abs(args.getDouble(1));
        if ((double)newSpeed >= Settings.Setting.MAX_SPEED.asDouble()) {
            throw new CommandException("citizens.commands.npc.speed.modifier-above-limit");
        }
        npc.getNavigator().getDefaultParameters().speedModifier(newSpeed);
        Messaging.sendTr(sender, "citizens.commands.npc.speed.set", Float.valueOf(newSpeed));
    }

    @Command(aliases={"npc"}, usage="tp", desc="Teleport to a NPC", modifiers={"tp", "teleport"}, min=1, max=1, permission="npc.tp")
    public void tp(CommandContext args, Player player, NPC npc) {
        Location to = npc.getTrait(CurrentLocation.class).getLocation();
        player.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.tp.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tphere", desc="Teleport a NPC to your location", modifiers={"tphere", "tph", "move"}, min=1, max=1, permission="npc.tphere")
    public void tphere(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        if (!npc.isSpawned()) {
            npc.spawn(args.getSenderLocation());
        } else {
            npc.getBukkitEntity().teleport(args.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.tphere.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="type [type]", desc="Sets an NPC's entity type", modifiers={"type"}, min=2, max=2, permission="npc.type")
    public void type(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        EntityType type = Util.matchEntityType(args.getString(1));
        if (type == null) {
            throw new CommandException("citizens.commands.npc.type.invalid", args.getString(1));
        }
        ((CitizensNPC)npc).setEntityController(EntityControllers.createForType(type));
        Messaging.sendTr(sender, "citizens.commands.npc.type.set", npc.getName(), args.getString(1));
    }

    @Command(aliases={"npc"}, usage="vulnerable (-t)", desc="Toggles an NPC's vulnerability", modifiers={"vulnerable"}, min=1, max=1, flags="t", permission="npc.vulnerable")
    public void vulnerable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = npc.data().get("protected", true) == false;
        if (args.hasFlag('t')) {
            npc.data().set("protected", vulnerable);
        } else {
            npc.data().setPersistent("protected", vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.vulnerable.stopped" : "citizens.commands.npc.vulnerable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="zombiemod (-b(aby), -v(illager))", desc="Sets a zombie NPC to be a baby or villager", modifiers={"zombie", "zombiemod"}, flags="bv", min=1, max=1, permission="npc.zombiemodifier")
    @Requirements(selected=true, ownership=true, types={EntityType.ZOMBIE})
    public void zombieModifier(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ZombieModifier trait = npc.getTrait(ZombieModifier.class);
        if (args.hasFlag('b')) {
            boolean isBaby = trait.toggleBaby();
            Messaging.sendTr(sender, isBaby ? "citizens.commands.npc.zombiemod.baby-set" : "citizens.commands.npc.zombiemod.baby-unset", npc.getName());
        }
        if (args.hasFlag('v')) {
            boolean isVillager = trait.toggleVillager();
            Messaging.sendTr(sender, isVillager ? "citizens.commands.npc.zombiemod.villager-set" : "citizens.commands.npc.zombiemod.villager-unset", npc.getName());
        }
    }
}

