/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Waypoints
extends Trait {
    private WaypointProvider provider = new LinearWaypointProvider();
    private String providerName = "linear";
    private static final Map<String, Class<? extends WaypointProvider>> providers = Maps.newHashMap();

    public Waypoints() {
        super("waypoints");
    }

    private WaypointProvider create(Class<? extends WaypointProvider> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void describeProviders(CommandSender sender) {
        Messaging.sendTr(sender, "citizens.waypoints.available-providers-header", new Object[0]);
        for (String name : providers.keySet()) {
            Messaging.send(sender, "    - " + StringHelper.wrap(name));
        }
    }

    public WaypointProvider getCurrentProvider() {
        return this.provider;
    }

    public String getCurrentProviderName() {
        return this.providerName;
    }

    public Editor getEditor(Player player) {
        return this.provider.createEditor(player);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.provider = null;
        this.providerName = key.getString("provider", "linear");
        for (Map.Entry<String, Class<? extends WaypointProvider>> entry : providers.entrySet()) {
            if (!entry.getKey().equals(this.providerName)) continue;
            this.provider = this.create(entry.getValue());
            break;
        }
        if (this.provider == null) {
            return;
        }
        this.provider.load(key.getRelative(this.providerName));
    }

    @Override
    public void onSpawn() {
        if (this.provider != null) {
            this.provider.onSpawn(this.getNPC());
        }
    }

    @Override
    public void save(DataKey key) {
        if (this.provider == null) {
            return;
        }
        this.provider.save(key.getRelative(this.providerName));
        key.setString("provider", this.providerName);
    }

    public boolean setWaypointProvider(String name) {
        Class<? extends WaypointProvider> clazz = providers.get(name = name.toLowerCase());
        if (clazz == null) {
            return false;
        }
        this.provider = this.create(clazz);
        if (this.provider == null) {
            return false;
        }
        this.providerName = name;
        if (this.npc != null && this.npc.isSpawned()) {
            this.provider.onSpawn(this.npc);
        }
        return true;
    }

    public static void registerWaypointProvider(Class<? extends WaypointProvider> clazz, String name) {
        providers.put(name, clazz);
    }

    static {
        providers.put("linear", LinearWaypointProvider.class);
        providers.put("wander", WanderWaypointProvider.class);
    }
}

