/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.EntityTargetNPCEvent;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_4_5.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_4_5.CraftServer;
import org.bukkit.craftbukkit.v1_4_5.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class EventListen
implements Listener {
    private final NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
    private final ListMultimap<ChunkCoord, Integer> toRespawn = ArrayListMultimap.create();
    private static EventListen instance;

    public EventListen() {
        instance = this;
    }

    @EventHandler(ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        ChunkCoord coord = this.toCoord(event.getChunk());
        List ids = this.toRespawn.get((Object)coord);
        for (int i = 0; i < ids.size(); ++i) {
            int id = (Integer)ids.get(i);
            this.spawn(id);
            Messaging.debug("Spawned", id, "due to chunk load at [" + coord.x + "," + coord.z + "]");
        }
        this.toRespawn.removeAll((Object)coord);
    }

    @EventHandler(ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        ChunkCoord coord = this.toCoord(event.getChunk());
        Location location = new Location(null, 0.0, 0.0, 0.0);
        for (NPC npc : this.npcRegistry) {
            if (!npc.isSpawned()) continue;
            location = npc.getBukkitEntity().getLocation(location);
            boolean sameChunkCoordinates = coord.z == location.getBlockZ() >> 4 && coord.x == location.getBlockX() >> 4;
            if (!sameChunkCoordinates || !event.getWorld().equals(location.getWorld())) continue;
            npc.despawn(DespawnReason.CHUNK_UNLOAD);
            this.toRespawn.put((Object)coord, (Object)npc.getId());
            Messaging.debug("Despawned", npc.getId(), "due to chunk unload at [" + coord.x + "," + coord.z + "]");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityChangedWorld(EntityTeleportEvent event) {
        if (event.getFrom() == null || event.getTo() == null) {
            return;
        }
        if (event.getFrom().getWorld() == event.getTo().getWorld() || !this.npcRegistry.isNPC(event.getEntity())) {
            return;
        }
        NMS.updateNavigationWorld((LivingEntity)event.getEntity(), event.getTo().getWorld());
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected", true).booleanValue());
        if (event instanceof EntityCombustByEntityEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByEntityEvent((EntityCombustByEntityEvent)event, npc));
        } else if (event instanceof EntityCombustByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByBlockEvent((EntityCombustByBlockEvent)event, npc));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustEvent(event, npc));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected", true).booleanValue());
        if (event instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent damageEvent = new NPCDamageByEntityEvent(npc, (EntityDamageByEntityEvent)event);
            Bukkit.getPluginManager().callEvent((Event)damageEvent);
            if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
                return;
            }
            Player damager = (Player)damageEvent.getDamager();
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
        } else if (event instanceof EntityDamageByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageByBlockEvent(npc, (EntityDamageByBlockEvent)event));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageEvent(npc, event));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        NPC npc = this.npcRegistry.getNPC((Entity)event.getEntity());
        if (npc == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDeathEvent(npc, event));
        npc.despawn(DespawnReason.DEATH);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() && this.npcRegistry.isNPC((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getTarget());
        if (npc == null) {
            return;
        }
        event.setCancelled(npc.data().get("protected", true).booleanValue());
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetNPCEvent(event, npc));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        if (!(handle instanceof NPCHolder)) {
            return;
        }
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        int maxChecks;
        if (event.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int limit = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (int i = maxChecks = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); i >= 0; --i) {
            if (!event.getCreator().hasPermission("citizens.npc.limit." + i)) continue;
            limit = i;
            break;
        }
        if (limit < 0) {
            return;
        }
        int owned = 0;
        for (NPC npc : this.npcRegistry) {
            if (event.getNPC().equals(npc) || !npc.getTrait(Owner.class).isOwnedBy((CommandSender)event.getCreator())) continue;
            ++owned;
        }
        int wouldOwn = owned + 1;
        if (wouldOwn >= limit) {
            event.setCancelled(true);
            event.setCancelReason(Messaging.tr("citizens.limits.over-npc-limit", limit));
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getRightClicked());
        if (npc == null) {
            return;
        }
        Player player = event.getPlayer();
        NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
        Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Editor.leave(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        for (ChunkCoord chunk : this.toRespawn.keySet()) {
            if (!chunk.worldName.equals(event.getWorld().getName()) || !event.getWorld().isChunkLoaded(chunk.x, chunk.z)) continue;
            List ids = this.toRespawn.get((Object)chunk);
            for (int i = 0; i < ids.size(); ++i) {
                this.spawn((Integer)ids.get(i));
                Messaging.debug("Spawned", ids.get(0), "due to world " + event.getWorld().getName() + " load");
            }
            this.toRespawn.removeAll((Object)chunk);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        for (NPC npc : this.npcRegistry) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getWorld().equals(event.getWorld())) continue;
            this.storeForRespawn(npc);
            npc.despawn();
            Messaging.debug("Despawned", npc.getId() + "due to world unload at", event.getWorld().getName());
        }
    }

    private void spawn(int id) {
        NPC npc = this.npcRegistry.getById(id);
        if (npc == null) {
            return;
        }
        Location spawn = npc.getTrait(CurrentLocation.class).getLocation();
        if (spawn == null) {
            Messaging.debug("Couldn't find a spawn location for despawned NPC ID: " + id);
            return;
        }
        npc.spawn(spawn);
    }

    private void storeForRespawn(NPC npc) {
        this.toRespawn.put((Object)this.toCoord(npc.getBukkitEntity().getLocation()), (Object)npc.getId());
    }

    private ChunkCoord toCoord(Chunk chunk) {
        return new ChunkCoord(chunk);
    }

    private ChunkCoord toCoord(Location loc) {
        return new ChunkCoord(loc.getWorld().getName(), loc.getBlockX() >> 4, loc.getBlockZ() >> 4);
    }

    public static void addForRespawn(Location loc, int id) {
        if (instance == null) {
            return;
        }
        EventListen.instance.toRespawn.put((Object)instance.toCoord(loc), (Object)id);
    }

    private static class ChunkCoord {
        private final String worldName;
        private final int x;
        private final int z;

        private ChunkCoord(Chunk chunk) {
            this(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
        }

        private ChunkCoord(String worldName, int x, int z) {
            this.x = x;
            this.z = z;
            this.worldName = worldName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkCoord other = (ChunkCoord)obj;
            if (this.worldName == null ? other.worldName != null : !this.worldName.equals(other.worldName)) {
                return false;
            }
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + (this.worldName == null ? 0 : this.worldName.hashCode());
            result = 31 * result + this.x;
            result = 31 * result + this.z;
            return result;
        }
    }
}

