/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlStorage
implements Storage {
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private final File file;
    private final String header;
    private final boolean transformLists;

    public YamlStorage(File file) {
        this(file, null);
    }

    public YamlStorage(File file, String header) {
        this(file, header, true);
    }

    public YamlStorage(File file, String header, boolean transformLists) {
        this.file = file;
        this.header = header;
        this.transformLists = transformLists;
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                Messaging.severe("Could not create file: " + file.getName());
            }
            this.save();
        }
    }

    private Object deepCopy(Object source) {
        if (source instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Map.Entry e : ((Map)source).entrySet()) {
                result.put((String)e.getKey(), this.deepCopy(e.getValue()));
            }
            return result;
        }
        if (source instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : (List)source) {
                result.add(this.deepCopy(item));
            }
            return result;
        }
        return source;
    }

    public boolean equals(Object obj) {
        return obj instanceof YamlStorage && Objects.equals(this.file, ((YamlStorage)obj).file);
    }

    @Override
    public DataKey getKey(String root) {
        if (root == null || root.isEmpty()) {
            return new MemoryDataKey(this.data);
        }
        Map current = this.data;
        for (String segment : root.split("\\.")) {
            Object next = current.get(segment);
            if (!(next instanceof Map)) {
                return new MemoryDataKey(new LinkedHashMap<String, Object>());
            }
            current = (Map)next;
        }
        return new MemoryDataKey(current);
    }

    public int hashCode() {
        return Objects.hashCode(this.file);
    }

    @Override
    public boolean load() {
        boolean bl;
        FileReader reader = new FileReader(this.file);
        try {
            Object loaded = new Yaml().load((Reader)reader);
            this.data.clear();
            if (loaded instanceof Map) {
                this.data.putAll((Map)this.deepCopy(loaded));
            }
            if (this.transformLists) {
                this.transformListsToMaps(this.data);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        reader.close();
        return bl;
    }

    @Override
    public void save() {
        this.doSave(false);
    }

    @Override
    public void saveAsync() {
        this.doSave(true);
    }

    private void doSave(boolean async) {
        Map toSave = (Map)this.deepCopy(this.data);
        if (this.transformLists) {
            this.transformMapsToLists(toSave);
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        Runnable task = () -> {
            try (FileWriter writer = new FileWriter(this.file);){
                if (this.header != null && !this.header.isEmpty()) {
                    writer.write("# " + this.header + "\n");
                }
                yaml.dump((Object)toSave, (Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        if (async) {
            ForkJoinPool.commonPool().submit(task);
        } else {
            task.run();
        }
    }

    public String toString() {
        return "YamlStorage{file=" + this.file + "}";
    }

    private void transformListsToMaps(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                LinkedHashMap<String, Object> indexed = new LinkedHashMap<String, Object>();
                int i = 0;
                for (Object item : (Collection)value) {
                    Object copied = this.deepCopy(item);
                    indexed.put(String.valueOf(i++), copied);
                    if (!(copied instanceof Map)) continue;
                    this.transformListsToMaps((Map)copied);
                }
                entry.setValue(indexed);
                continue;
            }
            if (!(value instanceof Map)) continue;
            LinkedHashMap<String, Object> mutable = new LinkedHashMap<String, Object>((Map)value);
            entry.setValue(mutable);
            this.transformListsToMaps(mutable);
        }
    }

    private void transformMapsToLists(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : new ArrayList<Map.Entry<String, Object>>(map.entrySet())) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map child = (Map)entry.getValue();
            this.transformMapsToLists(child);
            if (!this.isSequentialIntKeys(child)) continue;
            ArrayList list = new ArrayList(child.size());
            for (int i = 0; i < child.size(); ++i) {
                list.add(child.get(String.valueOf(i)));
            }
            entry.setValue(list);
        }
    }

    private boolean isSequentialIntKeys(Map<String, ?> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        for (String key : map.keySet()) {
            try {
                if (Integer.parseInt(key) == i++) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

